<?php include 'header.php'; ?>

<main id="main">
    <section class="page-section bg-dark-1  light-content parallax-5" style="background-image: url(images/full-width-images/inner-bg.jpg)">
        <div class="container position-relative pt-50">
            <!-- Section Content -->
            <div class="text-start">
                <div class="row align-items-center">
                    <div class="col-lg-6">
                        <h1 class="hs-title-1 mb-30">
                            <span class="wow charsAnimIn" data-splitting="chars">Comprehensive Security Solutions for a Safer Future</span>
                        </h1>
                    </div>
                    <div class="col-lg-6">
                        <div class="row wow fadeInUp" data-wow-delay="0.6s" data-wow-duration="1.2s">
                            <div class="col-lg-10 offset-lg-1">
                                <p class="section-descr mb-0 peragraph-text ps-lg-3">
                                    At LionHeart, we provide top-tier security training and consulting to safeguard workplaces, schools, places of worship, and beyond. Our expert team delivers tailored strategies, hands-on training, and cutting-edge security solutions to help you anticipate threats and enhance safety. 
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- End Section Content -->
        </div>
    </section>
    <section class="page-section bg-dark-1 light-content our-services" id="services">
        <div class="container position-relative">
            <div class="row">
                <div class="col-lg-6 mb-md-60 mb-sm-30">
                    <div class="row">
                        <div class="col-lg-10">
                            <p class="section-descr mb-50 mb-sm-30 wow fadeInUp peragraph-text" data-wow-delay="0.4s">
                                Whether you're looking to strengthen emergency preparedness, improve organizational security, or integrate the latest technology, we are here to support and empower you.
                            </p>
                        </div>
                    </div>
                    <h3 class="section-title mb-30"><span class="wow charsAnimIn" data-splitting="chars">Our Services</span></h3>
                    <ul class="nav nav-tabs services-tabs wow fadeInUp" data-wow-delay="0.55s" role="tablist">
                        <li role="presentation">
                            <a href="#services-item-1" class="active" aria-controls="services-item-1" role="tab" aria-selected="true" data-bs-toggle="tab">Corporate Security Services</a>
                        </li>
                        <li role="presentation">
                            <a href="#services-item-2" aria-controls="services-item-2" role="tab" aria-selected="false" data-bs-toggle="tab">Safe Churches</a>
                        </li>
                        <li role="presentation">
                            <a href="#services-item-3" aria-controls="services-item-3" role="tab" aria-selected="false" data-bs-toggle="tab">Safe Schools</a>
                        </li>
                    </ul>                                
                </div>
                <div class="col-lg-6 d-flex wow fadeInLeft" data-wow-delay="0.55s" data-wow-offset="275">
                    <div class="tab-content services-content">
                        <div class="tab-pane services-content-item show fade active" id="services-item-1" role="tabpanel">
                            <div class="services-text">
                                <div class="services-text-container">
                                    <h4 class="services-title"><a href="corporate-security">Corporate Security Services</a></h4>
                                    <p class="text-gray mb-0 peragraph-text">
                                        We provide tailored corporate security services to help your organization stay safe and resilient. Our offerings include threat assessments, emergency planning, workplace violence prevention, cyber risk analysis, and executive protection - delivered by a team of former federal agents and law enforcement experts.
                                    </p>
                                </div>
                            </div>
                            <img class="services-image" src="images/services/corporate.png" alt="Image Description" />
                        </div>
                        <div class="tab-pane services-content-item fade" id="services-item-2" role="tabpanel">
                            <div class="services-text">
                                <div class="services-text-container">
                                    <h4 class="services-title"><a href="https://www.securechurch.com/" target="_blank">Safe Churches</a></h4>
                                    <p class="text-gray mb-0 peragraph-text">
                                        SecureChurch is led by career security professionals that combine their diverse expertise in federal law enforcement, police agencies, the United States military, and church leadership to equip your team with the proper church security training to ensure safety and protection.
                                    </p>
                                </div>
                            </div>
                            <img class="services-image" src="images/services/church.png" alt="Image Description" />
                        </div> 
                        <div class="tab-pane services-content-item fade" id="services-item-3" role="tabpanel">
                            <div class="services-text">
                                <div class="services-text-container">
                                    <h4 class="services-title"><a href="safe-schools">Safe Schools</a></h4>
                                    <p class="text-gray mb-0 peragraph-text">
                                        School violence is on the rise and the impact of these incidents is measured in lives affected. We believe that training staff and teachers is a critical step that is often overlooked. Many schools have stopped at hiring a school resource officer and think that is the total solution to protecting the kids at that school. But our children are precious, and more is required to ensure their safety.
                                    </p>
                                </div>
                            </div>
                            <img class="services-image" src="images/services.jpg" alt="Image Description" />
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <hr class="mt-0 mb-0 white">
    <section class="page-section pb-50 pb-sm-60 bg-dark-1 bg-dark-alpha-80 light-content parallax-5">
        <div class="position-absolute top-0 bottom-0 start-0 end-0 bg-gradient-dark"></div>
        <div class="container position-relative pt-0">
            <div class="text-center">
                <div class="row">
                    <div class="col-md-8 offset-md-2">
                        <h1 class="mb-0 section-title">
                            Equip your staff for safety. <br/>
                            <span class="text-blue">Schedule a Safety Consultation.</span>
                        </h1>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="page-section bg-dark-1 light-content pt-0" id="contact">
        <div class="container">
            <div class="row">
                <div class="col-md-10 offset-md-1">
                    <form class="form contact-form wow fadeInUp wch-unset" data-wow-delay=".5s" data-wow-offset="0" id="contact_form">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="name">First Name*</label>
                                    <input type="text" name="name" id="name" class="input-lg round form-control" placeholder="Enter your first name" pattern=".{3,100}" required aria-required="true">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="email">Last Name*</label>
                                    <input type="email" name="email" id="email" class="input-lg round form-control" placeholder="Enter your last name" pattern=".{5,100}" required aria-required="true">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="name">Email*</label>
                                    <input type="text" name="name" id="name" class="input-lg round form-control" placeholder="Enter your email" pattern=".{3,100}" required aria-required="true">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="email">Phone*</label>
                                    <input type="email" name="email" id="email" class="input-lg round form-control" placeholder="Enter your phone" pattern=".{5,100}" required aria-required="true">
                                </div>
                            </div>
                            <div class="col-12 mb-4">
                                <label class="checkbox-inline me-3">
                                    <input type="checkbox" id="inlineCheckbox1" class="form-check-input me-1" value="option1"> <span class="form-check-label text-gray">Sign up for news and updates</span>
                                </label>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="name">Subject*</label>
                                    <input type="text" name="name" id="name" class="input-lg round form-control" placeholder="Enter your subject" pattern=".{3,100}" required aria-required="true">
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="email">Message*</label>
                                    <textarea  class="input-lg round form-control" placeholder="Enter your message" required aria-required="true"></textarea>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="text-center pt-20 pt-xs-40">
                                    <button class="submit_btn btn btn-mod btn-w btn-large btn-round btn-hover-anim" id="submit_btn" aria-controls="result">
                                        <span>Schedule a Consultation</span>
                                    </button>
                                </div>
                            </div>
                        </div>
                        <div id="result" role="region" aria-live="polite" aria-atomic="true"></div>
                    </form>
                </div>
            </div>
        </div>
    </section>
    <hr class="mt-0 mb-0 white">
</main>

<?php include 'footer.php'; ?> 