(function($) {
	"use strict";
	$.buildplus_core_chart = function(){
        if ( $('.sc_chart').length ) {
            $('.sc_chart').find('.chart-md').each(function() {
                var block_id = $(this).data('block-id');
                var canvas = $('#' + block_id);
                var chart_json = canvas.data('chart');
                if (typeof chart_json  !== 'undefined') {
                    var draw_chart = new Chart(canvas, chart_json);
                }
            });
        }

        if ( $('.sc_chart_pie').length ) {
            $('.sc_chart_pie').find('.wrapper-chart').each(function() {
                var block_id = $(this).data('block-id');
                var canvas_pie = $('#' + block_id);
                var chart_json = canvas_pie.data('chart');
                if (typeof chart_json  !== 'undefined') {
                    var draw_chart_pie = new Chart(canvas_pie, chart_json);
                }
            });
        }

		if ( $('.sc_chart_stock').length ) {
            $('.sc_chart_stock').find('.wrapper-chart').each(function() {
                var block_id = $(this).data('block-id');
                var canvas_stock = $('#' + block_id);
                var info_stock = $('#info_' + block_id);
                var chart_json = canvas_stock.data('chart');
                var stock_json = canvas_stock.data('stock');

                if (typeof block_id  !== 'undefined' && typeof stock_json !== 'undefined') {
                    if (stock_json.database == 'quandl') {
                        $.slz_drawChart('', canvas_stock, chart_json);
                    } else {
                        $.slz_marketChart(stock_json.dataset_code, 7000, canvas_stock, stock_json, chart_json);
                    }

                    if ( typeof stock_json.info_display !== 'undefined' && stock_json.info_display == true ) {
                        if ( typeof stock_json.info !== 'undefined' ) {
                            $.slz_ppStockData($.slz_processReturnedData(stock_json.info), info_stock, stock_json, chart_json);
                        } else {
                            $.slz_populateStockData(stock_json.dataset_code, 7000, info_stock, stock_json, chart_json);
                        }
                    }
                }
            });
        }
    }

    /* BEGIN inner marketChart */
    $.slz_marketChart = function(code, to, block_id, stock_json, chart_json) {
        $.slz_getHistoricalData(code, to, stock_json).done(function(response) {
            $.slz_drawChart($.slz_extractData(response), block_id, chart_json);
        }).fail(function(err) {
            /*$.slz_drawChart($.slz_dummyData(err.company), "#chart-tiny-01");*/
        });
    };
    $.slz_getHistoricalData = function(company, timeOut, stock_json) {
        var yql_base_uri = 'https://query.yahooapis.com/v1/public/yql?q=';
        var yql_env = 'store://datatables.org/alltableswithkeys';
        var yql_format = 'json';

        var time_lm = 'month';
        if ( stock_json.dataset_show_type != 'week' ) {
            time_lm = stock_json.dataset_show_type;
        }
        var n = moment();
        var lm = moment().subtract(1, time_lm);

        var convertDateString = function(d) {
            return d.year() + "-" + ((d.month() + 1) < 10 ? "0" + (d.month() + 1) : (d.month() + 1)) + "-" + (d.date() < 10 ? "0" + d.date() : d.date());
        };

        var last_time = convertDateString(lm);
        var today = convertDateString(n);

        if ( typeof stock_json.dataset_startday !== 'undefined' ) {
            last_time = stock_json.dataset_startday;
        }
        if ( typeof stock_json.dataset_endday !== 'undefined' ) {
            today = stock_json.dataset_endday;
        }

        var yql_query = 'select * from yahoo.finance.historicaldata where symbol = "' + company + '" and startDate = "' + last_time + '" and endDate = "' + today + '"';

        var yql = yql_base_uri + encodeURIComponent(yql_query) + '&format=' + yql_format + '&env=' + encodeURIComponent(yql_env);

        return $.ajax({
            dataType: 'jsonp',
            url: yql,
            timeout: timeOut,
            error: function(xhr) {
                xhr.company = company;
            }
        });
    };
    $.slz_extractData = function(r) {
        var q = r.query.results.quote;
        var close = [];
        var date = [];
        var temp = {};

        for (var i = 0; i < q.length; i++) {
            close[i] = parseFloat(q[i].Close);
            date[i] = q[i].Date + "";
        }

        close.reverse();
        date.reverse();

        temp.close = close;
        temp.date = date;
        temp.symbol = q[0].Symbol;

        Cookies.set(temp.symbol, temp);

        return temp;
    };
    $.slz_drawChart = function(data, id, chart_json) {
        if (data) {
            var date = data.date.map(function(i) {
                return moment(i).tz("America/New_York");
            });
            var dataset_data = [];
            for (var i = 0; i < data.close.length; i++) {
                var el = data.close[i];
                dataset_data.push(el.toFixed(2));
            }
            if ( !chart_json.data.datasets[0].data.length ) {
                chart_json.data.datasets[0].data = dataset_data;
            }
            if ( !chart_json.data.labels.length ) {
                chart_json.data.labels = date;
            }
        }

        var ct = $(id);
        var draw_ct = new Chart(ct, chart_json);
    };
    /* END inner marketChart */


    /* BEGIN inner populateStockData */
    $.slz_populateStockData = function(code, to, block_id, stock_json, chart_json) {
        $.slz_getStockData(code, to).done(function(response) {
            $.slz_ppStockData($.slz_processReturnedData(response), block_id, stock_json, chart_json);
        }).fail(function(err) {
            /*$.ppStockData($.dummyStockData(err.company), '#stock-info-1');*/
        });
    };
    $.slz_getStockData = function(company, timeOut) {
        var yql_base_uri = 'https://query.yahooapis.com/v1/public/yql?q=';
        var yql_env = 'store://datatables.org/alltableswithkeys';
        var yql_format = 'json';

        var yql_query = 'select * from yahoo.finance.quote where symbol = "' + company + '"';

        var yql = yql_base_uri + encodeURIComponent(yql_query) + '&format=' + yql_format + '&env=' + encodeURIComponent(yql_env);

        return $.ajax({
            dataType: 'jsonp',
            url: yql,
            timeout: timeOut,
            error: function(xhr) {
                xhr.company = company;
            }
        });
    };
    $.slz_ppStockData = function(t, id) {
        $(id).find('.name').html(t.name);
        $(id).find('.price').html(t.price + ' USD');
        if (t.change < 0) {
            $(id).find('.change').css('color', '#d12a2a');
        }
        $(id).find('.change').html(t.change + ' (' + t.changePercent + ')');
        $(id).find('.date').html(t.date);
    };
    $.slz_processReturnedData = function(r) {
        var temp = {};

        var name = r.query.results.quote.Symbol;
        var price = r.query.results.quote.LastTradePriceOnly;
        var change = r.query.results.quote.Change;

        var changePercent = (change >= 0 ? '+' : '') + (change / price * 100).toFixed(2) + '%';
        if ( typeof r.query.count !== 'undefined' ) {
            var date = moment(r.query.created).tz("America/New_York").format('h:mm A zz DD/MM/YYYY');
        } else {
            var date = moment(r.query.created).format('DD/MM/YYYY');
        }

        temp.name = name;
        temp.price = parseFloat(price).toFixed(2);
        temp.change = parseFloat(change).toFixed(2);
        temp.changePercent = changePercent;
        temp.date = date;

        Cookies.set(name + 'stockData', temp);

        return temp;
    };
    /* END inner populateStockData */

})(jQuery);

jQuery( document ).ready( function() {
	//new WOW().init();
	jQuery.buildplus_core_chart();
});