<?php
/**
 * Core Loader class.
 * 
 * @author Swlabs
 * @since 1.0
 */
if( ! class_exists( 'Buildplus_Core_Loader' ) ) {
	class Buildplus_Core_Loader {
		public static function run(){
		}
		
		/**
		 * Fires after WordPress has finished loading but before any headers are sent.
		 */
		public static function init(){
			add_action('buildplus_core_image_slider',     array( 'Buildplus_Core', '[top.Top_Controller, show_image_slider]' ) );
			add_action('buildplus_core_project_title',    array( 'Buildplus_Core', '[top.Top_Controller, show_project_title]' ) );
			add_action('buildplus_core_project_gallery',  array( 'Buildplus_Core', '[top.Top_Controller, show_project_gallery]' ) );
			add_action('buildplus_core_project_related',  array( 'Buildplus_Core', '[top.Top_Controller, show_project_related]' ) );
			add_action('buildplus_core_project_list',     array( 'Buildplus_Core', '[top.Top_Controller, show_project_list]' ) );
			add_action('buildplus_core_service_gallery',  array( 'Buildplus_Core', '[top.Top_Controller, show_service_gallery]' ) );
			add_action('buildplus_core_service_list',     array( 'Buildplus_Core', '[top.Top_Controller, show_service_list]' ) );
			add_action('buildplus_core_team_list',        array( 'Buildplus_Core', '[top.Top_Controller, show_team_list]' ) );
			add_action('buildplus_core_team_about',       array( 'Buildplus_Core', '[top.Top_Controller, show_team_about]' ) );
			add_action('buildplus_core_social_share',     array( 'Buildplus_Core', '[top.Top_Controller, get_share_link]' ) );
			add_action('buildplus_core_show_entry_video', array( 'Buildplus_Core', '[top.Top_Controller, show_custom_entry_video]' ) );
			add_action('wp_ajax_buildplus_core',        array( 'Buildplus_Core', '[Application, ajax]' ) );
			add_action('wp_ajax_nopriv_buildplus_core', array( 'Buildplus_Core', '[Application, ajax]' ) );
			self::register_post_taxonomy();
		}
		public static function register_post_taxonomy(){
			// get permalink options
			$permalinks = get_option( 'buildplus_permalinks' );
			$custom_slug = array(
				'service'             => 'service',
				'service_cat'         => 'service-category',
				'project'             => 'project',
				'project_cat'         => 'project-category',
				'project_location'    => 'project-location',
				'team'                => 'team',
				'team_cat'            => 'team-category',
			);
			foreach( $custom_slug as $key=>$value ){
				if( isset( $permalinks[$key] ) && !empty( $permalinks[$key] ) ){
					$custom_slug[$key] = $permalinks[$key];
				}
			}
			/*******************************************************************/
			// Services post type
			/*******************************************************************/
			register_post_type( 'buildplus_service', array(
				'public'                => true,
				'has_archive'           => true,
				'menu_position'         => 22,
				'rewrite'               => array( 'slug' => $custom_slug['service'] ),
				'query_var'             => true,
				'menu_icon'             => 'dashicons-clipboard',
				'supports'              => array( 'title', 'editor', 'thumbnail', 'excerpt' ),
				'labels'                => array(
					'name'                  => esc_html__( 'Services',           'slz-core' ),
					'singular_name'         => esc_html__( 'Services',           'slz-core' ),
					'menu_name'             => esc_html__( 'Services',           'slz-core' ),
					'add_new'               => esc_html__( 'Add New',            'slz-core' ),
					'add_new_item'          => esc_html__( 'Add New Service',    'slz-core' ),
					'edit_item'             => esc_html__( 'Edit Service',       'slz-core' ),
				),
			));
			register_taxonomy( 'buildplus_service_cat', array( 'buildplus_service' ), array(
				'hierarchical'       => true,
				'rewrite'            => array( 'slug' => $custom_slug['service_cat'] ),
				'query_var'          => true,
				'labels'             => array(
					'name'                  => esc_html__( 'Service Categories',         'slz-core' ),
					'singular_name'         => esc_html__( 'Service Category',           'slz-core' ),
					'menu_name'             => esc_html__( 'Service Categories',         'slz-core' ),
					'add_new'               => esc_html__( 'Add New',                    'slz-core' ),
					'add_new_item'          => esc_html__( 'Add New Category',           'slz-core' ),
					'edit_item'             => esc_html__( 'Edit Category',              'slz-core' ),
					'parent_item'           => esc_html__( 'Parent Category',            'slz-core' ),
					'search_items'          => esc_html__( 'Search Categories',          'slz-core' ),
				),
			));
	
			/*******************************************************************/
			// Project post type
			/*******************************************************************/
			register_post_type( 'buildplus_project', array(
				'public'                => true,
				'has_archive'           => true,
				'menu_position'         => 21,
				'rewrite'               => array( 'slug' => $custom_slug['project'] ),
				'query_var'             => true,
				'menu_icon'             => 'dashicons-portfolio',
				'supports'              => array( 'title', 'editor', 'thumbnail' ),
				'labels'                => array(
					'name'                  => esc_html__( 'Projects',           'slz-core' ),
					'singular_name'         => esc_html__( 'Projects',           'slz-core' ),
					'menu_name'             => esc_html__( 'Projects',           'slz-core' ),
					'add_new'               => esc_html__( 'Add New',            'slz-core' ),
					'add_new_item'          => esc_html__( 'Add New Project',    'slz-core' ),
					'edit_item'             => esc_html__( 'Edit Project',       'slz-core' ),
				),
			));
			register_taxonomy( 'buildplus_project_cat', array( 'buildplus_project' ), array(
				'hierarchical'       => true,
				'rewrite'            => array( 'slug' => $custom_slug['project_cat'] ),
				'query_var'          => true,
				'labels'             => array(
					'name'                  => esc_html__( 'Project Categories',       'slz-core' ),
					'singular_name'         => esc_html__( 'Project Category',         'slz-core' ),
					'menu_name'             => esc_html__( 'Project Categories',       'slz-core' ),
					'add_new'               => esc_html__( 'Add New',                  'slz-core' ),
					'add_new_item'          => esc_html__( 'Add New Category',         'slz-core' ),
					'edit_item'             => esc_html__( 'Edit Category',            'slz-core' ),
					'parent_item'           => esc_html__( 'Parent Category',          'slz-core' ),
					'search_items'          => esc_html__( 'Search Categories',        'slz-core' ),
				),
			));
			register_taxonomy( 'buildplus_project_location', array( 'buildplus_project' ), array(
				'hierarchical'       => true,
				'rewrite'            => array( 'slug' => $custom_slug['project_location'] ),
				'query_var'          => true,
				'labels'             => array(
					'name'                  => esc_html__( 'Project Locations',       'slz-core' ),
					'singular_name'         => esc_html__( 'Project Location',         'slz-core' ),
					'menu_name'             => esc_html__( 'Project Locations',       'slz-core' ),
					'add_new'               => esc_html__( 'Add New',                  'slz-core' ),
					'add_new_item'          => esc_html__( 'Add New Location',         'slz-core' ),
					'edit_item'             => esc_html__( 'Edit Location',            'slz-core' ),
					'parent_item'           => esc_html__( 'Parent Location',          'slz-core' ),
					'search_items'          => esc_html__( 'Search Locations',        'slz-core' ),
				),
			));
	
			/*******************************************************************/
			// Team post type
			/*******************************************************************/
			register_post_type( 'buildplus_team', array(
				'public'                => true,
				'has_archive'           => true,
				'menu_position'         => 23,
				'rewrite'               => array( 'slug' => $custom_slug['team'] ),
				'query_var'             => true,
				'menu_icon'             => 'dashicons-groups',
				'supports'              => array( 'title', 'editor', 'thumbnail' ),
				'labels'                => array(
					'name'                  => esc_html__( 'Teams',           'slz-core' ),
					'singular_name'         => esc_html__( 'Teams',           'slz-core' ),
					'menu_name'             => esc_html__( 'Teams',           'slz-core' ),
					'add_new'               => esc_html__( 'Add New',         'slz-core' ),
					'add_new_item'          => esc_html__( 'Add New Team',    'slz-core' ),
					'edit_item'             => esc_html__( 'Edit Team',       'slz-core' ),
				),
			));
			register_taxonomy( 'buildplus_team_cat', array( 'buildplus_team' ), array(
				'hierarchical'       => true,
				'rewrite'            => array( 'slug' => $custom_slug['team_cat'] ),
				'query_var'          => true,
				'labels'             => array(
					'name'                  => esc_html__( 'Team Categories',         'slz-core' ),
					'singular_name'         => esc_html__( 'Team Categories',         'slz-core' ),
					'menu_name'             => esc_html__( 'Team Categories',         'slz-core' ),
					'add_new'               => esc_html__( 'Add New',                 'slz-core' ),
					'add_new_item'          => esc_html__( 'Add New Category',        'slz-core' ),
					'edit_item'             => esc_html__( 'Edit Category',           'slz-core' ),
					'parent_item'           => esc_html__( 'Parent Category',         'slz-core' ),
					'search_items'          => esc_html__( 'Search Categories',       'slz-core' ),
				),
			));
	
			/*******************************************************************/
			// Testimonial post type
			/*******************************************************************/
			register_post_type( 'buildplus_testi', array(
				'public'                => true,
				'has_archive'           => true,
				'rewrite'               => array( 'slug' => 'testimonial' ),
				'query_var'             => true,
				'menu_icon'             => 'dashicons-editor-quote',
				'supports'              => array( 'title', 'editor', 'thumbnail'),
				'labels'                => array(
					'name'                  => esc_html__( 'Testimonials',           'slz-core' ),
					'singular_name'         => esc_html__( 'Testimonials',           'slz-core' ),
					'menu_name'             => esc_html__( 'Testimonials',           'slz-core' ),
					'add_new'               => esc_html__( 'Add New',                'slz-core' ),
					'add_new_item'          => esc_html__( 'Add New Testimonial',    'slz-core' ),
					'edit_item'             => esc_html__( 'Edit Testimonial',       'slz-core' ),
				),
			));
			register_taxonomy( 'buildplus_testi_cat', array( 'buildplus_testi' ), array(
				'hierarchical'       => true,
				'rewrite'            => array( 'slug' => 'testimonial-category' ),
				'query_var'          => true,
				'labels'             => array(
					'name'                  => esc_html__( 'Testimonial Categories',  'slz-core' ),
					'singular_name'         => esc_html__( 'Testimonial Categories',  'slz-core' ),
					'menu_name'             => esc_html__( 'Testimonial Categories',  'slz-core' ),
					'add_new'               => esc_html__( 'Add New',                 'slz-core' ),
					'add_new_item'          => esc_html__( 'Add New Category',        'slz-core' ),
					'edit_item'             => esc_html__( 'Edit Category',           'slz-core' ),
					'parent_item'           => esc_html__( 'Parent Category',         'slz-core' ),
					'search_items'          => esc_html__( 'Search Categories',       'slz-core' ),
				),
			));
	
			/*******************************************************************/
			// Gallery post type
			/*******************************************************************/
			register_post_type( 'buildplus_gallery', array(
				'public'                => true,
				'has_archive'           => true,
				'rewrite'               => array( 'slug' => 'gallery' ),
				'query_var'             => true,
				'menu_icon'             => 'dashicons-images-alt2',
				'supports'              => array( 'title', 'editor', 'thumbnail' ),
				'labels'                => array(
					'name'                  => esc_html__( 'Gallery',           'slz-core' ),
					'singular_name'         => esc_html__( 'Gallery',           'slz-core' ),
					'menu_name'             => esc_html__( 'Gallery',           'slz-core' ),
					'add_new'               => esc_html__( 'Add New',           'slz-core' ),
					'add_new_item'          => esc_html__( 'Add New Gallery',   'slz-core' ),
					'edit_item'             => esc_html__( 'Edit Gallery',      'slz-core' ),
				),
			));
			register_taxonomy( 'buildplus_gallery_cat', array( 'buildplus_gallery' ), array(
				'hierarchical'       => true,
				'rewrite'            => array( 'slug' => 'gallery-category' ),
				'query_var'          => true,
				'labels'             => array(
					'name'                  => esc_html__( 'Gallery Categories',      'slz-core' ),
					'singular_name'         => esc_html__( 'Gallery Categories',      'slz-core' ),
					'menu_name'             => esc_html__( 'Gallery Categories',      'slz-core' ),
					'add_new'               => esc_html__( 'Add New',                 'slz-core' ),
					'add_new_item'          => esc_html__( 'Add New Category',        'slz-core' ),
					'edit_item'             => esc_html__( 'Edit Category',           'slz-core' ),
					'parent_item'           => esc_html__( 'Parent Category',         'slz-core' ),
					'search_items'          => esc_html__( 'Search Categories',       'slz-core' ),
				),
			));
			/*******************************************************************/
			// Partners post type
			/*******************************************************************/
			register_post_type( 'buildplus_partner', array(
				'public'                => true,
				'has_archive'           => true,
				'rewrite'               => array( 'slug' => 'partners' ),
				'query_var'             => true,
// 				'menu_icon'             => 'dashicons-groups',
				'supports'              => array( 'title', 'editor', 'thumbnail' ),
				'labels'                => array(
					'name'                  => esc_html__( 'Partners',           'slz-core' ),
					'singular_name'         => esc_html__( 'Partners',           'slz-core' ),
					'menu_name'             => esc_html__( 'Partners',           'slz-core' ),
					'add_new'               => esc_html__( 'Add New',            'slz-core' ),
					'add_new_item'          => esc_html__( 'Add New Partner',    'slz-core' ),
					'edit_item'             => esc_html__( 'Edit Partner',       'slz-core' ),
				),
			));
			register_taxonomy( 'buildplus_partner_cat', array( 'buildplus_partner' ), array(
				'hierarchical'       => true,
				'rewrite'            => array( 'slug' => 'partner-category' ),
				'query_var'          => true,
				'labels'             => array(
					'name'                  => esc_html__( 'Partner Categories',      'slz-core' ),
					'singular_name'         => esc_html__( 'Partner Categories',      'slz-core' ),
					'menu_name'             => esc_html__( 'Partner Categories',      'slz-core' ),
					'add_new'               => esc_html__( 'Add New',                 'slz-core' ),
					'add_new_item'          => esc_html__( 'Add New Category',        'slz-core' ),
					'edit_item'             => esc_html__( 'Edit Category',           'slz-core' ),
				),
			));
			/*******************************************************************/
			// Pricing Table post type
			/*******************************************************************/
			register_post_type( 'buildplus_pricing', array(
				'public'                => true,
				'has_archive'           => true,
				'rewrite'               => array( 'slug' => 'pricing-table' ),
				'query_var'             => true,
				'supports'              => array( 'title' ),
				'labels'                => array(
					'name'                  => esc_html__( 'Pricing Tables',           'slz-core' ),
					'singular_name'         => esc_html__( 'Pricing Tables',           'slz-core' ),
					'menu_name'             => esc_html__( 'Pricing Tables',           'slz-core' ),
					'add_new'               => esc_html__( 'Add New',                  'slz-core' ),
					'add_new_item'          => esc_html__( 'Add New Pricing Table',    'slz-core' ),
					'edit_item'             => esc_html__( 'Edit Pricing Table',       'slz-core' ),
				),
			));
		}
		
		/**
		 * It is triggered before any other hook when a user accesses the admin area. 
		 */
		public static function admin(){
			// add action
			add_action( 'save_post',             array( 'Buildplus_Core', '[Application, save]' ) );
			add_action( 'admin_enqueue_scripts', array( 'Buildplus_Core', '[setting.Setting_Init, enqueue]' ) );
	
			add_action( 'buildplus_core_custom_colums',      array( 'Buildplus_Core', '[setting.Setting_Init, manage_custom_columns]' ) );
			add_action( 'buildplus_core_add_feature_video',  array( 'Buildplus_Core', '[setting.Setting_Init, add_metabox_feature_video]' ) );
			// save feature video
			add_action( 'buildplus_core_save_feature_video', array( 'Buildplus_Core', '[setting.Setting_Init, save_feature_video]' ) );
			// set custom permalink
			add_action( 'current_screen',                    array( 'Buildplus_Core', '[setting.Setting_Init, add_permalink_settings]' ) );
	
			do_action( 'buildplus_core_add_feature_video');
			do_action( 'buildplus_core_custom_colums');
	
			// Service - metaboxs
			add_meta_box( 'buildplus_core_mbox_service',     'Service Options',     array( 'Buildplus_Core', '[posttype.Service_Controller, metabox_service_options]' ), 'buildplus_service', 'normal' );
			// Project - metaboxs
			add_meta_box( 'buildplus_core_mbox_project',     'Project Options',     array( 'Buildplus_Core', '[posttype.Project_Controller, metabox_project_options]' ), 'buildplus_project', 'normal' );
			add_post_type_support( 'buildplus_project', 'author' );
			// Team - metaboxs
			add_meta_box( 'buildplus_core_mbox_team',        'Team Options',        array( 'Buildplus_Core', '[posttype.Team_Controller, metabox_team_options]' ), 'buildplus_team', 'normal' );
			//Testimonial - metaboxs
			add_meta_box( 'buildplus_core_mbox_testimonial', 'Testimonial Options', array( 'Buildplus_Core', '[posttype.Testimonial_Controller, metabox_testimonial_options]' ), 'buildplus_testi', 'normal' );
			//Gallery - metaboxs
			add_meta_box( 'buildplus_core_mbox_gallery',     'Gallery Options',     array( 'Buildplus_Core', '[posttype.Gallery_Controller, metabox_gallery_options]' ), 'buildplus_gallery', 'normal' );
			// Partner - metaboxs
			add_meta_box( 'buildplus_core_mbox_partner',     'Partner Options',     array( 'Buildplus_Core', '[posttype.Partner_Controller, meta_box_url]' ), 'buildplus_partner', 'normal' );
			// Pricing - metaboxs
			add_meta_box( 'buildplus_core_mbox_pricing', esc_html__('Pricing Table', 'slz-core'), array( 'Buildplus_Core', '[posttype.Pricing_Controller, metabox_pricing]' ), 'buildplus_pricing', 'normal' );
		}
	}
}