<?php
class Buildplus_Core_Banner {
	public $attributes;
	public $uniq;
	public $html_format;
	
	public function __construct() {
		$this->meta_attributes();
		$this->uniq = 'banner-' . Buildplus_Core::make_id();
	}
	
	public function meta_attributes() {
		$default = array(
			'style'              => '2',
			'subtitle'           => '',
			'title'              => '',
			'big_title'          => '',
			'bg_image'           => '',
			'subtitle_color'     => '',
			'title_color'        => '',
			'des_color'          => '',
			'big_title_color'    => '',
			'extra_class'        => ''
		);
		$this->attributes = $default;
	}
	public function init( $atts, $content = null ) {
		$this->attributes = Buildplus_Core::set_shortcode_defaults( $this->attributes, $atts);
		if( function_exists( 'wpb_js_remove_wpautop' ) ) {
			$content = wpb_js_remove_wpautop( $content, true );
		}
		$this->attributes['content'] = $content;
	}
	/*-------------------- >> General Functions << --------------------*/
	
	public function setting_html( &$options = array() ){
		$default = array(
			'subtitle_format'    => '<h5 class="subtitle">%1$s</h5>',
			'title_format'       => '<h2 class="title">%1$s</h2>',
			'big_title_format'   => '<div class="big-title">%1$s</div>',
			'description_format' => '<div class="text">%1$s</div>'
		);
		$this->html_format = array_merge( $default, $options);
	}
	public function get_subtitle() {
		$output = '';
		$format = $this->html_format['subtitle_format'];
		if( !empty( $this->attributes['subtitle'] ) && !empty( $format ) ) {
			$output = sprintf( $format, esc_attr( $this->attributes['subtitle'] ));
		}
		return $output;
	}
	public function get_title() {
		$output = '';
		$format = $this->html_format['title_format'];
		if( !empty( $this->attributes['title'] ) && !empty( $format ) ) {
			$output = sprintf( $format, esc_attr( $this->attributes['title'] ));
		}
		return $output;
	}
	public function get_description() {
		$output = '';
		if( $this->attributes['style'] == '2' ){
			$format = $this->html_format['description_format'];
			if( !empty( $this->attributes['content'] ) && !empty( $format ) ) {
				$output = sprintf( $format, wp_kses_post( $this->attributes['content'] ));
			}
		}
		else{
			$format = $this->html_format['big_title_format'];
			if( !empty( $this->attributes['big_title'] ) && !empty( $format ) ) {
				$output = sprintf( $format, esc_attr( $this->attributes['big_title'] ));
			}
		}
		return $output;
	}
	/*-------------------- >> Css Functions << --------------------*/
	public function add_custom_css() {
		$custom_css = '';
		$image_url  = '';
		$block_cls  = trim($this->uniq) . ' .banner-' . $this->attributes['style'];
		if( !empty( $this->attributes['subtitle_color'] ) && !empty( $this->attributes['subtitle'] ) ) {
			$custom_css .= '.%1$s .subtitle{color:%2$s;}' . "\n";
		}
		if( !empty( $this->attributes['title_color'] ) && !empty( $this->attributes['title'] ) ){
			$custom_css .= '.%1$s .title{color:%3$s;}' . "\n";
		}
		if( !empty( $this->attributes['des_color'] ) && !empty( $this->attributes['content'] ) ){
			$custom_css .= '.%1$s .text{color:%4$s;}' . "\n";
		}
		if( !empty( $this->attributes['big_title_color'] ) && !empty( $this->attributes['big_title'] ) ) {
			$custom_css .= '.%1$s .big-title{color:%5$s;}' . "\n";
		}
		if( !empty( $this->attributes['bg_image'] ) && !empty( $this->attributes['big_title'] ) ) {
			$image_atts = wp_get_attachment_image_src( $this->attributes['bg_image'], 'full');
			if( !empty( $image_atts ) ){
				$image_url = $image_atts[0];
				$custom_css .= '.%1$s .big-title{background-image:url(%6$s);}' . "\n";
			}
		}
		if( $this->attributes['style'] == '3' && empty( $image_url ) ){
			$custom_css .= '.%1$s .big-title{-webkit-text-fill-color:initial;
												-moz-text-fill-color:initial;
												-0-text-fill-color:initial;}' . "\n";
		}
		if ( !empty($custom_css) ) {
			$custom_css = sprintf($custom_css,
					esc_attr($block_cls),
					esc_attr($this->attributes['subtitle_color']),
					esc_attr($this->attributes['title_color']),
					esc_attr($this->attributes['des_color']),
					esc_attr($this->attributes['big_title_color']),
					esc_url($image_url)
			);
			do_action( BUILDPLUS_CORE_ADD_INLINE_CSS, $custom_css );
		}
	}
	/*-------------------- >> Render Html << -------------------------*/
	public function render_sc( $html_options = array() ) {
		$this->setting_html( $html_options );
		printf( $this->html_format['html_format'],
				$this->get_subtitle(),
				$this->get_title(),
				$this->get_description(),
				$this->attributes['style']
			);
		$this->add_custom_css();
	}
}