<?php
$model = new Buildplus_Core_Blog;
$model->init( $atts);
$block_cls[] = $model->attributes['block-class'];
$block_cls[] = $model->attributes['responsive-class'];
$block_cls = implode(' ', $block_cls);
// 1: image, 2: meta info, 3: title, 4: description , 5: more button, 6: post class, 7: no-image class, 8: ribbon date
$html_format = '
		<div class="item %6$s">
			<div class="block-1 %7$s">
				%8$s
				%1$s
				%2$s
				<div class="block-content">
					%3$s
					%4$s
					%5$s
				</div>
			</div>
		</div>
';

$html_options = array(
	'html_format'         => $html_format,
	'image_class'         => 'img-full',
);
if( $atts['style'] == '02' ){
	$html_format = '
			<div class="item %6$s">
				<div class="block-2 %7$s">
					%8$s
					%1$s
					<div class="block-content">
						%3$s
						%4$s
						%5$s
					</div>
				</div>
			</div>
	';
	$html_options = array(
		'html_format'         => $html_format,
		'image_class'         => 'img-full',
		'more_btn_format'     => '<a href="%1$s" class="readmore"><span class="text">'.esc_html__( 'read more', 'slz-core' ).'</span><i class="icons fa fa-angle-double-right"></i></a>'
	);
}else if( $atts['style'] == '03' ){
	$html_format = '
			<div class="item  %6$s blog-horizontal-02">
                <div class="block-2 %7$s">
                    <div class="block-image">
						%8$s
                        %1$s
                        %2$s
                    </div>
                    <div class="block-content">
                        %3$s
                        %4$s
                    </div>
                </div>
            </div>
	';
	$html_options = array(
		'html_format'         => $html_format,
		'image_class'         => 'img-full',
		'image_format'        => '%2$s<a href="%1$s" class="link"></a>',
		'more_btn_format'     => '<a href="%1$s" class="readmore"><span class="text">'.esc_html__( 'read more', 'slz-core' ).'</span><i class="icons fa fa-angle-double-right"></i></a>'
	);
}
if( $model->query->have_posts() ) {
?>
<div class="slz-shortcode blog-content <?php echo esc_attr($model->attributes['extra_class'])?>" >
	<div class="list-block <?php echo esc_attr( $block_cls ); ?>" >
		<?php $model->render_list( $html_options ); ?>
	</div>
</div>
<div class="clearfix"></div>
<?php if( $model->attributes['pagination'] == 'yes' ) {
		echo BuildPlus_Core_Pagination::paging_nav( $model->query->max_num_pages, 2, $model->query);
	}
}?>