<?php
$download_type = array(
	esc_html__('Media', 'slz-core')   => 'custom',
	esc_html__('Projects', 'slz-core') => 'project',
	esc_html__('Services', 'slz-core') => 'service',
);
$project_empty = array( 'empty' => esc_html__( '-- All Projects --', 'slz-core' ) );
$project_args  = array( 'post_type' => 'buildplus_project', 'post_status' => 'publish' );
$project_list  = Buildplus_Core_Com::get_post_title2id( $project_args, $project_empty );

$service_empty = array( 'empty' => esc_html__( '-- All Services --', 'slz-core' ) );
$service_args  = array( 'post_type' => 'buildplus_service', 'post_status' => 'publish' );
$service_list  = Buildplus_Core_Com::get_post_title2id( $service_args, $service_empty );

$params = array(
	array(
		'type'        => 'textfield',
		'holder'      => 'div',
		'heading'     => esc_html__( 'Button Text', 'slz-core' ),
		'param_name'  => 'title',
		'value'       => esc_html__( 'Text on button', 'slz-core' ),
		'description' => esc_html__( 'Enter text on the button',  'slz-core'  )
	),
	array(
		'type'        => 'dropdown',
		'heading'     => esc_html__( 'Choose Attachment From', 'slz-core' ),
		'param_name'  => 'download_type',
		'value'       => $download_type,
		'description' => esc_html__( 'Choose a style for block.', 'slz-core' )
	),
	array(
		'type'        => 'param_group',
		'heading'     => esc_html__( 'Add Item', 'slz-core' ),
		'param_name'  => 'project_list',
		'params'      => array(
			array(
				'type'            => 'dropdown',
				'admin_label' => true,
				'heading'         => esc_html__( 'Project', 'slz-core' ),
				'param_name'      => 'project',
				'value'           => $project_list,
				'description'     => esc_html__( 'Choose project to get attachments.', 'slz-core' )
			)
		),
		'value'       => '',
		'dependency'  => array(
			'element' => 'download_type',
			'value'   => array('project')
		)
	),
	array(
		'type'        => 'param_group',
		'heading'     => esc_html__( 'Add Item', 'slz-core' ),
		'param_name'  => 'service_list',
		'params'      => array(
			array(
				'type'            => 'dropdown',
				'admin_label' => true,
				'heading'         => esc_html__( 'Service', 'slz-core' ),
				'param_name'      => 'service',
				'value'           => $service_list,
				'description'     => esc_html__( 'Choose service to get attachments.', 'slz-core' )
			)
		),
		'value'       => '',
		'dependency'  => array(
			'element' => 'download_type',
			'value'   => array('service')
		)
	),
	array(
		'type'        => 'textfield',
		'heading'     => esc_html__( 'Media IDs', 'slz-core' ),
		'param_name'  => 'attach_list',
		'value'       => '',
		'description' => esc_html__( 'Enter list of media ids to download, seperated by a comma. (Ex: 1,4,12)', 'slz-core' ),
		'dependency'  => array(
			'element' => 'download_type',
			'value'   => array('custom')
		)
	),
	array(
		'type'        => 'checkbox',
		'heading'     => esc_html__( 'Background Transparent', 'slz-core' ),
		'param_name'  => 'bg_transparent',
		'value'       => array( esc_html__( 'Yes', 'slz-core' ) => 'yes' ),
		'description' => esc_html__( 'Checked to background button transparent.', 'slz-core' ),
		'group'       => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'        => 'colorpicker',
		'heading'     => esc_html__( 'Background Color', 'slz-core' ),
		'param_name'  => 'button_color',
		'value'       => '',
		'description' => esc_html__( 'Select background color for button.', 'slz-core' ),
		'group'       => esc_html__('Custom', 'slz-core')
	),
	array(
		'type'        => 'colorpicker',
		'heading'     => esc_html__( 'Text Color', 'slz-core' ),
		'param_name'  => 'text_color',
		'value'       => '',
		'description' => esc_html__( 'Select color for button text.', 'slz-core' ),
		'group'       => esc_html__('Custom', 'slz-core')
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Border Color', 'slz-core' ),
		'param_name'      => 'border_color',
		'value'           => '',
		'description'     => esc_html__( 'Select color for border button color.', 'slz-core' ),
		'group'       	  => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'        => 'colorpicker',
		'heading'     => esc_html__( 'File Text Color', 'slz-core' ),
		'param_name'  => 'file_text_color',
		'value'       => '',
		'description' => esc_html__( 'Select color for filename.', 'slz-core' ),
		'group'       => esc_html__('Custom', 'slz-core')
	),
	array(
		'type'        => 'textfield',
		'heading'     => esc_html__( 'Extra Class', 'slz-core' ),
		'param_name'  => 'extra_class',
		'value'       => '',
		'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'slz-core' )
	)
);

vc_map(
	array(
		"name"        => esc_html__( 'SLZ Download File', 'slz-core' ),
		"base"        => "slzcore_download_sc",
		"class"       => "slzcore-sc",
		"category"    => BUILDPLUS_CORE_SC_CATEGORY,
		'icon'        => 'icon-slzcore_download_sc',
		"description" => esc_html__( 'Create download button.', 'slz-core' ),
		"params"      => $params
	)
);
