<?php
$taxonomy = 'buildplus_partner_cat';
$params_cat = array('empty' => esc_html__( '-- All Partner Categories --', 'slz-core' ) );
$categories = Buildplus_Core_Com::get_tax_options2slug( $taxonomy, $params_cat );

$params = array(
	array(
		'type'        => 'dropdown',
		'heading'     => esc_html__( 'Category', 'slz-core' ),
		'param_name'  => 'category',
		'value'       => $categories,
		'description' => esc_html__( 'Choose partner category.', 'slz-core' )
	),
	array(
		'type'        => 'textfield',
		'heading'     => esc_html__( 'Slides To Show', 'slz-core' ),
		'param_name'  => 'number_item',
		'value'       => '',
		'description' => esc_html__( 'Enter number of slides to show at a time.', 'slz-core' )
	),
	array(
		'type'            => 'checkbox',
		'heading'         => esc_html__( 'Show Dots of SLider', 'slz-core' ),
		'param_name'      => 'show_dot',
	),
	array(
		'type'          => 'textfield',
		'heading'       => esc_html__( 'Extra Class', 'slz-core' ),
		'param_name'    => 'extra_class',
		'description'   => esc_html__( 'Enter extra class name.', 'slz-core' )
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Dots Color', 'slz-core' ),
		'param_name'      => 'dot_color',
		'value'           => '',
		'description'     => esc_html__( 'Select color for dots of slider.', 'slz-core' ),
		'group'       	  => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Dots Active Color', 'slz-core' ),
		'param_name'      => 'dot_at_color',
		'value'           => '',
		'description'     => esc_html__( 'Select color for dots when active of slider.', 'slz-core' ),
		'group'       	  => esc_html__('Custom', 'slz-core'),
	),
);
vc_map(array(
	'name'               => esc_html__( 'SLZ Partner', 'slz-core' ),
	'base'               => 'slzcore_partner_sc',
	'class'              => 'slzcore-sc',
	'icon'               => 'icon-slzcore_partner_sc',
	'category'           => BUILDPLUS_CORE_SC_CATEGORY,
	'description'        => esc_html__( 'List partners', 'slz-core' ),
	'params'             => $params
));

