<?php
class Buildplus_Core_Button {
	public $attributes;
	public $uniq;
	public $html_format;
	
	public function __construct() {
		$this->meta_attributes();
		$this->uniq = 'button-' . Buildplus_Core::make_id();
	}
	
	public function meta_attributes() {
		$default = array(
			'title'              => esc_html__( 'Text on button', 'slz-core' ),
			'url'                => '',
			'button_color'       => '',
			'button_color_hover' => '',
			'text_color'         => '',
			'text_color_hover'   => '',
			'border_color'       => '',
			'border_color_hover' => '',
			'file_text_color'    => '',
			'extra_class'        => '',
			'bg_transparent'     => '',
			'download_type'      => 'custom',
			'project_list'       => '',
			'service_list'       => '',
			'attach_types'       => '',
			'attach_list'        => '',
			'align'              => 'left'
		);
		$this->attributes = $default;
	}
	public function init( $atts, $content = null ) {
		$this->attributes = Buildplus_Core::set_shortcode_defaults( $this->attributes, $atts);
		if( function_exists( 'wpb_js_remove_wpautop' ) ) {
			$content = wpb_js_remove_wpautop( $content, true );
		}
		$this->attributes['content'] = $content;
	}
	/*-------------------- >> General Functions << --------------------*/
	
	public function setting_html( &$options = array() ){
		$default = array(
			'button_format' => '<button class="btn">%1$s</button>',
			'href_format'   => '<a href="%2$s" class="btn" %3$s >%1$s</a>',
		);
		$this->html_format = array_merge( $default, $options);
	}
	public function get_download_link(){
		$output = '';
		$atts = array();
		$attachment_ids = array();
		if( !empty( $this->attributes['project_list'] ) ){
			$project_list_parse = '';
			list( $project_list_parse ) = Buildplus_Core_Util::get_list_vc_param_group( $this->attributes, 'project_list', 'project' );
			if( !empty( $project_list_parse ) ){
				$atts['list_post'] = $project_list_parse;
			}
			$model = new BuildPlus_Core_Project();
			$model->init( $atts );
			$attachment_ids = $model->get_attachment_ids();
		}
		elseif( !empty( $this->attributes['service_list'] ) ){
			$service_list_parse = '';
			list( $service_list_parse ) = Buildplus_Core_Util::get_list_vc_param_group( $this->attributes, 'service_list', 'service' );
			if( !empty( $service_list_parse ) ){
				$atts['list_post'] = $service_list_parse;
			}
			$model = new Buildplus_Core_Service();
			$model->init( $atts );
			$attachment_ids = $model->get_attachment_ids();
		}
		elseif( !empty( $this->attributes['attach_list'] ) ){
			$attachment_ids = array_filter(explode(',', $this->attributes['attach_list']));
		}
		if( !empty( $attachment_ids ) ){
			foreach( $attachment_ids as $attach_id ){
				if( !empty( $attach_id ) ){
					$attach_url  = wp_get_attachment_url($attach_id);
					$attach_ext  = pathinfo( $attach_url, PATHINFO_EXTENSION );
					$attach_icon = Buildplus_Core_Util::get_icon_for_extension( $attach_ext );
					$attach_name = basename($attach_url);
					if( $attach_url ){
						$output .= '<a href="'.esc_url( $attach_url ).'" class="link" target="_blank">'.wp_kses_post( $attach_icon ).'<span class="link-name">'.esc_html( $attach_name ).'</span></a>';
					}
				}
			}
		}
		return $output;
	}
	/*-------------------- >> Css Functions << --------------------*/
	public function add_custom_css() {
		$custom_css = '';
		if( !empty( $this->attributes['bg_transparent'] ) && $this->attributes['bg_transparent'] == 'yes' ) {
			$custom_css .= '.%1$s .btn {background-color: transparent;}' . "\n";
		} else {
			if( !empty( $this->attributes['button_color'] ) ) {
				$custom_css .= '.%1$s .btn {background-color:%2$s;}' . "\n";
				if( empty( $this->attributes['button_color_hover'] ) ) {
					$custom_css .= '.%1$s .btn:hover{background-color: transparent;}' . "\n";
				}
			}
		}
		if( !empty( $this->attributes['button_color_hover'] ) ) {
			$custom_css .= '.%1$s .btn:hover{background-color:%3$s;}' . "\n";
		}
		if( !empty( $this->attributes['text_color'] ) ){
			$custom_css .= '.%1$s .btn {color:%4$s;}' . "\n";
		}
		if( !empty( $this->attributes['text_color_hover'] ) ) {
			$custom_css .= '.%1$s .btn:hover{color:%5$s;}' . "\n";
		}
		if( !empty( $this->attributes['border_color']) ){
			$custom_css .= '.%1$s .btn {border-color: %6$s}' ."\n";
		}
		if( !empty( $this->attributes['border_color_hover']) ) {
			$custom_css .= '.%1$s .btn:hover {border-color: %7$s}' . "\n";
		}
		if( !empty( $this->attributes['align']) ) {
			$custom_css .= '.%1$s {text-align: %8$s}' . "\n";
		}
		if ( !empty($custom_css) ) {
			$custom_css = sprintf($custom_css,
					esc_attr(trim($this->uniq)),
					esc_attr($this->attributes['button_color']),
					esc_attr($this->attributes['button_color_hover']),
					esc_attr($this->attributes['text_color']),
					esc_attr($this->attributes['text_color_hover']),
					esc_attr($this->attributes['border_color']),
					esc_attr($this->attributes['border_color_hover']),
					esc_attr($this->attributes['align'])
			);
			do_action( BUILDPLUS_CORE_ADD_INLINE_CSS, $custom_css );
		}
	}
	public function add_download_custom_css() {
		$custom_css = '';
		if( !empty( $this->attributes['bg_transparent'] ) && $this->attributes['bg_transparent'] == 'yes' ) {
			$custom_css .= '.%1$s .btn-download-wrapper .btn-download {background-color: transparent;}' . "\n";
		} else {
			if( !empty( $this->attributes['button_color'] ) ) {
				$custom_css .= '.%1$s .btn-download-wrapper .btn-download {background-color:%2$s;}' . "\n";
				$custom_css .= '.%1$s .btn-download-wrapper .btn-link .link{background-color: %2$s;}' . "\n";
				if( empty( $this->attributes['button_color_hover'] ) ) {
					$custom_css .= '.%1$s .btn-link{background-color: transparent;}' . "\n";
				}
			}
		}
		if( !empty( $this->attributes['text_color'] ) ){
			$custom_css .= '.%1$s .btn-download-wrapper .btn-download {color:%3$s;}' . "\n";
			$custom_css .= '.%1$s .btn-download-wrapper .btn-link .link {color:%3$s;}' . "\n";
		}
		if( !empty( $this->attributes['border_color']) ){
			$custom_css .= '.%1$s .btn-download-wrapper .btn-download {border-color: %4$s}' ."\n";
		}
		if( !empty( $this->attributes['file_text_color']) ) {
			$custom_css .= '.%1$s .btn-download-wrapper .btn-link .link .link-name {color: %5$s}' . "\n";
		}
		if ( !empty($custom_css) ) {
			$custom_css = sprintf($custom_css,
					esc_attr(trim($this->uniq)),
					esc_attr($this->attributes['button_color']),
					esc_attr($this->attributes['text_color']),
					esc_attr($this->attributes['border_color']),
					esc_attr($this->attributes['file_text_color'])
			);
			do_action( BUILDPLUS_CORE_ADD_INLINE_CSS, $custom_css );
		}
	}
	/*-------------------- >> Render Html << -------------------------*/
	public function render_sc( $html_options = array() ) {
		$this->setting_html( $html_options );
		if( $this->attributes['title'] ) {
			$links = Buildplus_Core_Util::parse_vc_link( $this->attributes['url'] );
			extract($links);
			$format = $this->html_format['button_format'];
			if( !empty( $url ) ) { 
				$format = $this->html_format['href_format'];
			}
			printf( $format,
					esc_attr($this->attributes['title']),
					esc_url($url),
					$other_atts);
			$this->add_custom_css();
		}
	}
	public function render_download_sc( $html_options = array() ) {
		$this->setting_html( $html_options );
		printf( $this->html_format['html_format'],
				esc_html( $this->attributes['title'] ),
				$this->get_download_link()
			);
		$this->add_download_custom_css();
	}
}