<?php
class Buildplus_Core_Icon_Box {
	public $attributes;
	public $uniq;
	public $html_format;
	public $block_class;
	
	public function __construct() {
		$this->meta_attributes();
		$this->uniq = 'block-' . Buildplus_Core::make_id();
	}
	
	public function meta_attributes() {
		$default = array(
			'style'                => '',
			'columns'              => '',
			'group_list'           => '',
			'group_values'         => '',
			'extra_class'          => '',
			//custom color
			'icon_color'           => '',
			'icon_hv_color'        => '',
			'icon_bg_color'        => '',
			'item_bg_color'        => '',
			'item_bg_hv_color'     => '',
			'icon_bg_hv_color'     => '',
			'title_color'          => '',
			'title_hv_color'       => '',
			'icon_border_color'    => '',
			'des_color'            => '',
			'show_slider'          => '',
			'disable_box_shadow'   => '',
			'bg_image'             => '',
			'url'                  => '',
		);
		$this->attributes = $default;
	}
	public function init( &$atts, $content = null ) {
		$atts = Buildplus_Core::set_shortcode_defaults( $this->attributes, $atts);
		if( function_exists( 'wpb_js_remove_wpautop' ) ) {
			$content = wpb_js_remove_wpautop( $content, true );
		}
		$atts['content'] = $content;
		if( !empty( $atts['group_list'] ) ){
			$item_content = vc_param_group_parse_atts( $atts['group_list'] );
			$atts['group_values'] = $item_content;
		}
		$atts['columns'] = absint($atts['columns']);
		if( empty($atts['columns']) ) {
			$atts['columns'] = 1;
		}
		$this->attributes = $atts;
		$this->parse_block_class();
	}
	/*-------------------- >> General Functions << --------------------*/
	public function get_icon( $value ) {
		$output = '';
		if( !empty($value) ) {
			$format = $this->html_format['icon_format'];
			if( $format ) {
				//1: icon
				$output = sprintf( $format, esc_attr($value) );
			}
		}
		return $output;
	}
	public function get_title( $value, $links = array() ) {
		$output = '';
		if( !empty($value) ) {
			$format = $this->html_format['title_format'];
			if( $format ) {
				//1: title
				if( !empty($links['url']) ) {
					$value = '<a href="'.esc_url($links['url']).'" '. wp_kses_post($links['other_atts']) .'>'.esc_attr( $value ).'</a>';
				}
				$output = sprintf( $format, $value );
			}
		}
		return $output;
	}
	public function get_description( $value ) {
		$output = '';
		if( !empty($value) ) {
			$format = $this->html_format['desc_format'];
			if( $format ) {
				//1: description
				$output = sprintf( $format, wp_kses_post(nl2br($value)) );
			}
		}
		return $output;
	}
	public function parse_param_group( $param ){
		$param_def = array(
			'icon_type'     => '',
			'icon_fw'       => '',
			'icon_flat'     => '',
			'title'         => '',
			'description'   => '',
			'url'           => '',
			'icon'          => '',
		);
		$param = array_merge($param_def, $param);
		if( $param['icon_type'] == '02' && !empty( $param['icon_fw'] ) ){
			$param['icon'] = $param['icon_fw'];
		}
		if( $param['icon_type'] != '02' && !empty( $param['icon_flat'] ) ){
			$param['icon'] = $param['icon_flat'];
		}
		return $param;
	}
	public function group_content($value, $links = array()) {
		$output = '';
		$group = array(
			'title' => $this->get_title($value['title'], $links ),
			'description' => $this->get_description($value['description']),
		);
		$group = array_filter($group);
		if( $group ) {
			$format = $this->html_format['content_format'];
			$output = sprintf( $format, implode('', $group) );
		}
		return $output;
	}
	public function parse_block_class(){
		$column_cls = 'column-' . $this->attributes['columns'];
		$class = array(
			'block' => 'list-block ' . $column_cls,
			'item'  => 'block-icon-1',
		);
		switch( $this->attributes['style'] ) {
			case '2':
				$class['block'] .= ' list-block-icon-2';
				$class['item'] = 'block-icon-2';
				break;
			case '3':
				$class['item'] = 'contact-info-box';
				break;
			case '4':
				$class['item'] = 'block-icon-5';
				break;
			default:
				
		}
		if( $this->attributes['show_slider'] == 'yes' ) {
			$class['block'] .= ' list-block-slick slide-block';
		}
		$this->block_class = $class;
	}
	public function setting_html( &$options = array() ){
		$default = array(
			'icon_format'   => '<div class="icon-cell">
									<div class="wrapper-icons"><i class="icons %1$s"></i></div>
								</div>',
			'title_format'   => '<div class="title">%1s</div>',
			'desc_format'    => '<div class="text">%1$s</div>',
			'content_format' => '<div class="icon-cell">
									<div class="wrapper-info">
										%1$s
									</div>
								</div>',
		);
		$this->html_format = array_merge( $default, $options);
	}
	/*-------------------- >> Css Functions << --------------------*/
	public function add_custom_css() {
		$custom_css = '';
		if( !empty( $this->attributes['icon_color'] ) ){
			$custom_css .= '.%1$s .wrapper-icons {color:%2$s;}'."\n";
			if( $this->attributes['style'] == '' || $this->attributes['style'] == '1' ){
				$custom_css .= '.%1$s:hover .wrapper-icons::before {background-color:%2$s;}'."\n";
			}
			$custom_css .= '.%1$s .block-icons .icons{color:%2$s;}'."\n";
		}
		if( !empty( $this->attributes['icon_bg_color'] ) ){
			$custom_css .= '.%1$s .wrapper-icons::before{background-color:%3$s;}'."\n";
		}
		if( !empty( $this->attributes['icon_bg_hv_color'] ) ){
			$custom_css .= '.%1$s .wrapper-icons {background-color:%4$s;}'."\n";
		}
		if( !empty( $this->attributes['title_color'] ) ){
			$custom_css .= '.%1$s .wrapper-info .title{color:%5$s;}' ."\n";
			$custom_css .= '.%1$s .block-content .title{color:%5$s;}' ."\n";
		}
		if( !empty( $this->attributes['des_color'] ) ){
			$custom_css .= '.%1$s .wrapper-info .text{color:%6$s;}' ."\n";
			$custom_css .= '.%1$s .block-content .text{color:%6$s;}' ."\n";
			$custom_css .= '.%1$s:hover .wrapper-info .title{color:%6$s;}' ."\n";
		}
		if( !empty( $this->attributes['title_hv_color'] ) ){
			$custom_css .= '.%1$s:hover .wrapper-info .title{color:%7$s;}' ."\n";
		}
		if( !empty( $this->attributes['icon_hv_color'] ) ){
			$custom_css .= '.%1$s:hover .wrapper-icons {color:%8$s;}'."\n";
			$custom_css .= '.%1$s:hover .wrapper-icons::before {background-color:%8$s;}'."\n";
		}

		if( !empty( $this->attributes['item_bg_color'] ) ){
			$custom_css .= '.%1$s.block-service {background-color:%10$s;}'."\n";
		}
		if( !empty( $this->attributes['item_bg_hv_color'] ) ){

			$custom_css .= '.%1$s.block-service .waveShape {fill:%11$s;}'."\n";
		}

		if( !empty( $this->attributes['icon_border_color'] ) ){
			if($this->attributes['style'] == '2'){
				$custom_css .= '.%1$s .wrapper-icons .icons{border-color:%9$s;}'."\n";
			} else {
				$custom_css .= '.%1$s .wrapper-icons{border-color:%9$s;}'."\n";
			}
		}
		if( !empty( $this->attributes['disable_box_shadow'] ) && $this->attributes['disable_box_shadow'] == 'yes') {
			if($this->attributes['style'] != '2' && $this->attributes['style'] != '3'){
				$custom_css .= '.%1$s:hover{box-shadow: none;}'."\n";
			}
		}
		if( !empty( $this->attributes['bg_image'] )) {
			if($this->attributes['style'] == '2'){
				$image = wp_get_attachment_image_src($this->attributes['bg_image'], 'full');
				if( $image && isset($image[0]) ){
					$custom_css .= '.'.$this->uniq.' .item{background-image:url("'.$image[0].'");}'."\n";
					$custom_css .= '.'.$this->uniq.' {margin:0;}'."\n";
				}
			}
		}
		$block_cls = $this->uniq . ' .' . $this->block_class['item'];
		if ( !empty( $custom_css ) ) {
			$custom_css = sprintf($custom_css,
					esc_attr($block_cls),
					esc_attr($this->attributes['icon_color']),
					esc_attr($this->attributes['icon_bg_color']),
					esc_attr($this->attributes['icon_bg_hv_color']),
					esc_attr($this->attributes['title_color']),
					esc_attr($this->attributes['des_color']),
					esc_attr($this->attributes['title_hv_color']),
					esc_attr($this->attributes['icon_hv_color']),
					esc_attr($this->attributes['icon_border_color']),
					esc_attr($this->attributes['item_bg_color']),
					esc_attr($this->attributes['item_bg_hv_color']),$this->uniq
					
			);
			do_action( BUILDPLUS_CORE_ADD_INLINE_CSS, $custom_css );
		}
	}
	/*-------------------- >> Render Html << -------------------------*/
	public function render_sc( $html_options ) {
		$i = 1;
		$this->setting_html( $html_options );
		if( $this->attributes['group_values'] ) {
			foreach( $this->attributes['group_values'] as $item ) {
				if( $item ) {
					$item = $this->parse_param_group($item);
					$links = array();
					if( !empty( $item['icon'] ) || !empty( $item['title'] ) || !empty( $item['description'] ) ) {
						if( !empty($item['url']) ) {
							$links = Buildplus_Core_Util::parse_vc_link($item['url']);
							
						}
						//Buildplus_Core_Util::dump($links);
						printf($this->html_format['html_format'],
								$this->get_icon($item['icon'], $links ),
								$this->group_content($item, $links),
								$this->block_class['item'],
								'',
								$this->get_title($item['title'], $links )
						);
						$i++;
					}
				}
			}
			$this->add_custom_css();
		}
	}
}