<?php
class Buildplus_Core_Toggle {
	public $attributes;
	public $uniq;
	public $html_format;
	
	public function __construct() {
		$this->meta_attributes();
		$this->uniq = 'accordion-' . Buildplus_Core::make_id();
	}
	
	public function meta_attributes() {
		$default = array(
			'extra_class'        => '',
			'active_color'       => '',
			'inactive_color'     => '',
			'title_color'        => '',
			'content_color'      => '',
			'title_color_hover'  => '',
			'group_list'         => '',
			'group_values'       => '',
			'heading_id'         => '',
			'description_id'     => '',
			'collapse_in'        => 'in',
			'collapse_inactive'  => '',
		);
		$this->attributes = $default;
	}
	public function init( $atts, $content = null ) {
		$this->attributes = Buildplus_Core::set_shortcode_defaults( $this->attributes, $atts);
		if( function_exists( 'wpb_js_remove_wpautop' ) ) {
			$content = wpb_js_remove_wpautop( $content, true );
		}
		$this->attributes['content'] = $content;
		if( !empty( $this->attributes['group_list'] ) ){
			$item_content = vc_param_group_parse_atts( $this->attributes['group_list'] );
			$this->attributes['group_values'] = $item_content;
		}
	}
	/*-------------------- >> General Functions << --------------------*/
	public function parse_param_group( $param ){
		$param_def = array(
			'heading' => '',
			'description' => '',
		);
		$param = array_merge($param_def, $param);
		return $param;
	}
	public function get_heading( $value) {
		$output = '';
		if( !empty($value) ) {
			$format = $this->html_format['title_format'];
			if( $format ) {
				//1: heading_id, 2: heading, 3: #desc_id, 4: #block_id, 5: collapsed
				$output = sprintf( $format,
						esc_attr( $this->attributes['heading_id'] ),
						esc_attr( $value ),
						esc_attr( '#' .$this->attributes['description_id'] ),
						esc_attr( '#' .$this->uniq ),
						esc_attr( $this->attributes['collapse_inactive'] )
					);
			}
		}
		return $output;
	}
	public function get_description( $value ) {
		$output = '';
		if( !empty($value) ) {
			$format = $this->html_format['desc_format'];
			if( $format ) {
				//1: desc_id, 2: desc, 3: #heading_id, 4: collapse in
				$output = sprintf( $format,
						esc_attr( $this->attributes['description_id'] ),
						wp_kses_post(nl2br($value)),
						esc_attr( '#' .$this->attributes['heading_id'] ),
						esc_attr( $this->attributes['collapse_in'] )
				);
			}
		}
		return $output;
	}//fa-plus
	public function setting_html( &$options = array() ){
		$default = array(
			'title_format' => '<div id="%1$s" role="tab" class="panel-heading">
								<a role="button" data-toggle="collapse" href="%3$s" aria-expanded="true" data-parent="%4$s" class="panel-title %5$s">
									<i class="icons fa fa-minus"></i>%2$s
								</a>
							</div>',
			'desc_format'  => '<div id="%1$s" role="tabpanel" class="panel-collapse collapse %4$s">
								<div class="panel-body">%2$s</div>
							</div>',
		);
		$this->html_format = array_merge( $default, $options);
	}
	/*-------------------- >> Css Functions << --------------------*/
	public function add_custom_css() {
		$custom_css = '';
		if( !empty( $this->attributes['active_color'] ) ){
			$custom_css .= '.%1$s .icons{background-color:%2$s;}'."\n";
			$custom_css .= '.%1$s .panel-group .panel .panel-body {border-bottom-color:%2$s; border-left-color:%2$s}'."\n";
		}
		if( !empty( $this->attributes['inactive_color'] ) ){
			$custom_css .= '.%1$s .panel-title.collapsed {border-color:%3$s;}'."\n";
			$custom_css .= '.%1$s .panel-title.collapsed .icons{background-color:%3$s}'."\n";
		}
		if( !empty( $this->attributes['title_color'] ) ){
			$custom_css .= '.%1$s .panel-title{color:%4$s;}' ."\n";
		}
		if( !empty( $this->attributes['content_color'] ) ){
			$custom_css .= '.%1$s .panel-body{color:%5$s;}' ."\n";
		}
		if ( !empty( $custom_css ) ) {
			$custom_css = sprintf($custom_css,
					esc_attr($this->uniq),
					esc_attr($this->attributes['active_color']),
					esc_attr($this->attributes['inactive_color']),
					esc_attr($this->attributes['title_color']),
					esc_attr($this->attributes['content_color'])
			);
			do_action( BUILDPLUS_CORE_ADD_INLINE_CSS, $custom_css );
		}
	}
	/*-------------------- >> Render Html << -------------------------*/
	public function render_sc( $html_options ) {
		$i = 1;
		$this->setting_html( $html_options );
		if( $this->attributes['group_values'] ) {
			foreach( $this->attributes['group_values'] as $item ) {
				if( $item ) {
					$item = $this->parse_param_group($item);
					if( !empty( $item['heading'] ) || !empty( $item['description'] ) ) {
						$this->attributes['heading_id'] = $this->uniq . '-heading-' . $i;
						$this->attributes['description_id'] = $this->uniq . '-desc-' . $i;
						printf($this->html_format['html_format'],
								$this->get_heading($item['heading'] ),
								$this->get_description($item['description'])
						);
	
						//reset active
						$this->attributes['collapse_inactive'] = 'collapsed';
						$this->attributes['collapse_in'] = '';
						$i++;
						$icon = 'fa fa-plus';
					}
				}
			}
			$this->add_custom_css();
		}
	}
}