<?php
$model = new Buildplus_Core_Pricing_Table();
$atts = $model->shortcode_atts( $atts );
$model->init( $atts );

// 1: title, 2: price, 3: subtitle, 4: icon, 5: feature list, 6: button, 7: main active, 8: meta data
$html_format = '
		<div class="item %7$s">
			<div class="package-content">
				<div class="heading">
					%1$s
					%3$s
					%4$s
				</div>
				
				<div class="description">
					%5$s
				</div>
				%2$s
				%6$s
			</div>
			%8$s
		</div>
		';
$html_options = array(
	'html_format'  => $html_format,
	'active_class' => ' plan active',
);
?>
<div class="slz-shortcode margin-bottom-30 list-pricing-plan <?php echo esc_attr( $model->post_class );?>">
	<div class="list-block <?php echo esc_attr($model->get_block_class() ) ?>">
		<?php $model->render_sc( $html_options );?>
	</div>
</div>