<?php
$model = new BuildPlus_Core_Service();
$model->init( $atts );
$uniq_id = $model->attributes['uniq_id'];
$block_cls = $model->attributes['extra_class'] . ' ' . $uniq_id;

// 1$ - image, 2$ - description, 3$ - permalink, 4$ - read more, 5$ - post id
$html_format = '
	<div class="item service_%5$s %6$s inline_block">
		<div class="block-1">
			%1$s
			<div class="block-content">
				<a href="%4$s" class="title">%2$s</a>
				%3$s
				%7$s
			</div>
		</div>
	</div>
';
$nav_html_format = '
	<div class="block-icon-3">
		<div class="icon-cell">
			<div class="wrapper-icons">%2$s</div>
		</div>
		<div class="icon-cell">
			<div class="wrapper-info">
				<div class="title">%1$s</div>
			</div>
		</div>
	</div>
';
// 1$ - title, 2$ - icon, 3$ - post id
$html_format = '
	<div class="item">
		<div class="item-wrapper">
			%1$s
			<div class="content-wrapper">
				%2$s
				%4$s
			</div>
			<span class="overlay"></span>
			<a href="javascript:void(0)"></a>
		</div>
	</div>
';
$html_render = array(
	'nav_html_format' 	=> $nav_html_format,
	'html_format' 		=> $html_format,
	'excerpt_format' 	=> '<div class="description">%s</div>',
	'thumb_class' 		=> 'img-full',
	'image_format'		=> '<div class="img-wrapper">%1$s</div>',
	'readmore_format'	=> '<a href="%2$s" class="readmore"><span class="text">%1$s</span><i class="icons fa fa-angle-double-right"></i></a>',
);
?>
<div class="slz-shortcode sc_service_carousel <?php echo esc_attr( $block_cls ); ?>" data-item="<?php echo esc_attr($uniq_id)?>">
	<div class="slider-vertical-wrapper">
		<div class="slider-nav-wrapper">
			<div class="slider-nav list-block-icon-3">
				<?php $model->render_service_carousel_nav_sc( $html_render ); ?>
			</div>
		</div>
		<div class="slider-for-wrapper">
			<div class="slider-for">
				<?php $model->render_service_carousel_sc( $html_render ); ?>
			</div>
		</div>
	</div>
</div>