<?php
/**
 * Options Config (ReduxFramework Sample Config File).
 *
 * For full documentation, please visit: https://docs.reduxframework.com
 *
 */
if (!class_exists('Buildplus_Redux_Framework_Config')) {

	class Buildplus_Redux_Framework_Config {

		public $args     = array();
		public $sections = array();
		public $theme;
		public $ReduxFramework;

		public function __construct() {

			if ( ! class_exists('ReduxFramework') ) {
				return;
			}

			// This is needed. Bah WordPress bugs.  ;)
			if ( true == Redux_Helpers::isTheme( __FILE__ ) ) {
				$this->initSettings();
			} else {
				add_action('plugins_loaded', array($this, 'initSettings'), 10);
			}

		}

		public function initSettings() {

			// Just for demo pureposes. Not needed per say.
			$this->theme = wp_get_theme();

			// Set the default arguments
			$this->setArguments();

			// Set a few help tabs so you can see how it's done
			$this->setHelpTabs();

			// Create the sections and fields
			$this->setSections();

			if (!isset($this->args['opt_name'])) { // No errors please
				return;
			}

			// If Redux is running as a plugin, this will remove the demo notice and links
			add_action( 'redux/loaded', array( $this, 'remove_demo' ) );

			$this->ReduxFramework = new ReduxFramework($this->sections, $this->args);
		}

		/**
		 * This is a test function that will let you see when the compiler hook occurs.
		 *
		 * It only runs if a field   set with compiler=>true is changed.
		 */
		function compiler_action($options, $css) {
			return;
		}

		/**
		 * Custom function for filtering the sections array.
		 *
		 */
		function dynamic_section($sections) {
			$sections[] = array(
				'title'  => esc_html__('Section via hook', 'buildplus'),
				'desc'   => sprintf('<p class="description">%s</p>', esc_html__('This is a section created by adding a filter to the sections array. Can be used by child themes to add/remove sections from the options.', 'buildplus')),
				'icon'   => 'el-icon-paper-clip',
				// Leave this as a blank section, no options just some intro text set above.
				'fields' => array()
			);

			return $sections;
		}

		/**
		 * Filter hook for filtering the args. Good for child themes to override or add to the args array. Can also be used in other functions.
		 *
		 */
		function change_arguments($args) {
			return $args;
		}

		/**
		 * Filter hook for filtering the default value of any given field. Very useful in development mode.
		 */
		function change_defaults($defaults) {
			$defaults['str_replace'] = esc_html__('Testing filter hook!', 'buildplus');

			return $defaults;
		}

		// Remove the demo link and the notice of integrated demo from the redux-framework plugin
		function remove_demo() {

			// Used to hide the demo mode link from the plugin page. Only used when Redux is a plugin.
			if ( class_exists('ReduxFrameworkPlugin') ) {
				remove_filter('plugin_row_meta', array(ReduxFrameworkPlugin::instance(), 'plugin_metalinks'), null, 2);

				// Used to hide the activation notice informing users of the demo panel. Only used when Redux is a plugin.
				remove_action('admin_notices', array(ReduxFrameworkPlugin::instance(), 'admin_notices'));
			}
		}

		public function setSections() {

			/*
			  Used within different fields. Simply examples. Search for ACTUAL DECLARATION for field examples
			*/
			$image_opt_path         = get_template_directory_uri() . '/assets/admin/images/';

			ob_start();

			$ct          = wp_get_theme();
			$this->theme = $ct;
			$item_name   = $this->theme->get('Name');
			$tags        = $this->theme->Tags;
			$screenshot  = $this->theme->get_screenshot();
			$class       = $screenshot ? 'has-screenshot' : '';

			$customize_title = sprintf( esc_html__( 'Customize &#8220;%s&#8221;', 'buildplus' ), $this->theme->display('Name') );

			?>
			<div id="current-theme" class="<?php echo esc_attr($class); ?>">
			<?php if ( $screenshot ) : ?>
				<?php if ( current_user_can('edit_theme_options') ) : ?>
						<a href="<?php echo wp_customize_url(); ?>" class="load-customize hide-if-no-customize" title="<?php echo esc_attr($customize_title); ?>">
							<img src="<?php echo esc_url($screenshot); ?>" alt="<?php esc_attr_e('Current theme preview', 'buildplus'); ?>" />
						</a>
				<?php endif; ?>
					<img class="hide-if-customize" src="<?php echo esc_url($screenshot); ?>" alt="<?php esc_attr_e('Current theme preview', 'buildplus' ); ?>" />
				<?php endif; ?>

				<h4><?php echo esc_html( $this->theme->display('Name') ); ?></h4>

				<div>
					<ul class="theme-info">
						<li><?php printf(esc_html__('By %s', 'buildplus'), $this->theme->display('Author')); ?></li>
						<li><?php printf(esc_html__('Version %s', 'buildplus'), $this->theme->display('Version')); ?></li>
						<li><?php echo '<strong>' . esc_html__('Tags', 'buildplus') . ':</strong> '; ?><?php printf($this->theme->display('Tags')); ?></li>
					</ul>
					<p class="theme-description"><?php echo esc_html( $this->theme->display('Description') ); ?></p>
			<?php
			if ( $this->theme->parent() ) {
				printf(' <p class="howto">' . wp_kses( __('This <a href="%1$s">child theme</a> requires its parent theme, %2$s.', 'buildplus'), array( 'a' => array('href' => array()) ) ) . '</p>', 'http://codex.wordpress.org/Child_Themes', $this->theme->parent()->display('Name'));
			}
			?>

				</div>
			</div>

			<?php
			$item_info = ob_get_contents();

			ob_end_clean();

			$admin_widget_url = '<a href="' . esc_url( admin_url('widgets.php','http')).'" target="_blank">' .esc_html__('Widget', 'buildplus') .'</a>';
			$admin_menus_url  = '<a href="' . esc_url( admin_url('nav-menus.php','http')).'" target="_blank">' .esc_html__('Menus', 'buildplus') .'</a>';
			$admin_icon_url   = '<a href="' . esc_url( admin_url('admin.php?page=buildplus_icon','http')).'" target="_blank">' .esc_html__('Icon Page', 'buildplus') .'</a>';
			$fontawesome_url  = '<a href="' . esc_url('https://fortawesome.github.io/Font-Awesome/icons/'). '">' .esc_html__('Font-Awesome', 'buildplus') .'</a>';
			$get_latlong      = '<a href="' . esc_url('http://www.latlong.net/'). '" target="_blank">http://www.latlong.net/</a>';

			// ACTUAL DECLARATION OF SECTIONS
			// General setting
			$this->sections[] = array(
				'title'     => esc_html__( 'General', 'buildplus' ),
				'icon'      => 'el-icon-adjust-alt',
				'fields'    => array(
					array(
						'id'       => 'slz-layout',
						'type'     => 'image_select',
						'title'    => esc_html__( 'Layout display', 'buildplus' ),
						'subtitle' => esc_html__( 'Choose type of layout', 'buildplus' ),
						'desc'     => esc_html__( 'This option will change layout for all page of theme.', 'buildplus' ),
						'options'  => array(
							'1' => array(
								'alt' => esc_html__( 'Fluid', 'buildplus' ),
								'img' => esc_url($image_opt_path) . 'full.png'
							),
							'2' => array(
								'alt' => esc_html__( 'Boxed', 'buildplus' ),
								'img' => esc_url($image_opt_path) . 'boxed.png'
							),
						),
						'default'  => '1'
					),
					
					array(
						'id'       => 'slz-layout-boxed-bg',
						'type'     => 'background',
						'title'    => esc_html__( 'Body Background', 'buildplus' ),
						'required' => array('slz-layout','=','2'),
						'default'  => array(
							'background-color'      => '#ffffff',
							'background-image'      => '',
							'background-repeat'     => 'no-repeat',
							'background-attachment' => '',
							'background-position'	=> 'center center',
							'background-size'		=> 'cover'
						)
					),
					array(
			            'id'       => 'slz-theme-color',
			            'type'     => 'palette',
			            'title'    => esc_html__( 'Theme color', 'buildplus' ),
			            'subtitle' => esc_html__( 'Select a theme color', 'buildplus' ),
			            'default'  => 'color-default',
			            'palettes' => array(
			                'color-default'  => array(
			                    '#ffb400'
			                ),
			                'color-01' => array(
			                	'#fbd022',
			                    '#0e95db',
			                ),
			                'color-02' => array(
			                    '#1bbde8'
			                ),
			            )
				    ),
					array(
						'id'       => 'slz-logo-header',
						'type'     => 'media',
						'url'      => true,
						'title'    => esc_html__( 'Header Logo', 'buildplus' ),
						'compiler' => 'true',
						'subtitle' => esc_html__( 'Choose logo image', 'buildplus' ),
						'default'  => array( 'url' => esc_url( BUILDPLUS_LOGO ) )
					),
					array(
						'id'		=> 'slz-sticky',
						'type'		=> 'switch',
						'title'		=> esc_html__('Header Sticky Enable', 'buildplus'),
						'subtitle'  => esc_html__( 'Enable or disable fixed header when scroll', 'buildplus' ),
						'default'   => true,
					),
					array(
						'id'       	=> 'slz-backtotop',
						'type'     	=> 'switch',
						'title'    	=> esc_html__( 'Back To Top Button', 'buildplus' ),
						'subtitle' 	=> esc_html__( 'Setting for back to top button', 'buildplus' ),
						'on'       	=> esc_html__( 'Show', 'buildplus' ),
						'off'      	=> esc_html__( 'Hide', 'buildplus' ),
						'default'  	=> true
					),
					array(
						'id'        => 'slz-backtotop-color-type',
						'type'      => 'switch',
						'title'     => esc_html__( 'Back To Top Button Color', 'buildplus' ),
						'on'        => esc_html__( 'Custom', 'buildplus' ),
						'off'       => esc_html__( 'Default', 'buildplus' ),
						'default'   => false
					),
					array(
					    'id'             => 'slz-backtotop-color',
					    'type'           => 'color',
					    'title'          => esc_html__('Back To Top Button Color', 'buildplus'), 
					    'transparent'    => false,
					    'default'        => '#ffb400',
					    'validate'       => 'color',
					    'required'    => array('slz-backtotop-color-type','=',true)
					),
					array(
						'id'       => 'slz-map-key-api',
						'type'     => 'text',
						'default'  => '',
						'title'    => esc_html__( 'Map google API Key', 'buildplus' ),
						'subtitle' => esc_html__( 'This key is used to run a some feature of Map.Please refer document to create a key', 'buildplus' ),
					),
					array(
						'id'        => 'slz-header-account',
						'type'      => 'button_set',
						'title'     => esc_html__( 'Accounts', 'buildplus' ),
						'options'   => array(
							'woo'      => esc_html__( 'Woocomerce Account', 'buildplus'),
							'hide'     => esc_html__( 'Hide', 'buildplus'),
						),
						'subtitle' => esc_html__( 'Show account link on header top right.', 'buildplus' ),
						'default' => 'hide'
					),
					array(
						'id'       => 'slz-language-switcher',
						'type'     => 'switch',
						'title'    => esc_html__( 'Language Switcher On Header Top', 'buildplus' ),
						'subtitle' => esc_html__( 'Show language switcher of plugin WPML on header top', 'buildplus' ),
						'on'       => esc_html__( 'Show', 'buildplus' ),
						'off'      => esc_html__( 'Hide', 'buildplus' ),
						'default'  => false
					),
					array(
						'id'       => 'slz-loading-page',
						'type'     => 'switch',
						'title'    => esc_html__( 'Show Loading Page', 'buildplus' ),
						'on'       => esc_html__( 'Show', 'buildplus' ),
						'off'      => esc_html__( 'Hide', 'buildplus' ),
						'default'  => false
					),
					array(
					    'id'             => 'slz-loading-page-bg-color',
					    'type'           => 'color',
					    'title'          => esc_html__('Loading Page Background Color', 'buildplus'), 
					    'transparent'    => false,
					    'default'        => '#ffb400',
					    'validate'       => 'color',
					    'required'    => array('slz-loading-page','=',true)
					),
				)
			);

			// Social Setting
			$this->sections[] = array (
				'title'     => esc_html__( 'Social Setting', 'buildplus' ),
				'desc'      => esc_html__( 'Setting social links and social share', 'buildplus' ),
				'icon'      => 'el-icon-group-alt',
				'fields'    => array(
					array(
						'id'        => 'slz-social-section-start',
						'type'      => 'section',
						'title'     => esc_html__( 'Social Links', 'buildplus' ),
						'subtitle'  => wp_kses( __( 'These information will be used for content in <strong>Header</strong> & <strong>Footer</strong>', 'buildplus' ), array('<strong>' => array())),
						'indent'    => true,
					),
					array(
						'id'       => 'slz-social-facebook',
						'type'     => 'text',
						'title'    => esc_html__( 'Facebook', 'buildplus' ),
						'default'  => ''
					),
					array(
						'id'       => 'slz-social-twitter',
						'type'     => 'text',
						'title'    => esc_html__( 'Twitter', 'buildplus' ),
						'default'  => ''
					),
					array(
						'id'       => 'slz-social-google-plus',
						'type'     => 'text',
						'title'    => esc_html__( 'Googleplus', 'buildplus' ),
						'default'  => ''
					),
					array(
						'id'       => 'slz-social-pinterest',
						'type'     => 'text',
						'title'    => esc_html__( 'Pinterest', 'buildplus' ),
						'default'  => ''
					),
					array(
						'id'       => 'slz-social-instagram',
						'type'     => 'text',
						'title'    => esc_html__( 'Instagram', 'buildplus' ),
						'default'  => ''
					),
					array(
						'id'       => 'slz-social-dribbble',
						'type'     => 'text',
						'title'    => esc_html__( 'Dribbble', 'buildplus' ),
						'default'  => ''
					),
					array(
						'id'        => 'slz-social-section-end',
						'type'      => 'section',
						'indent'    => false,
					),
					array(
						'id'        => 'slz-social-share-section-start',
						'type'      => 'section',
						'title'     => esc_html__( 'Social Share', 'buildplus' ),
						'subtitle'  => esc_html__( 'Configure social networks to share', 'buildplus' ),
						'indent'    => true,
					),
					array(
						'id'       => 'slz-social-share',
						'type'     => 'sorter',
						'title'    => esc_html__('Social network for share','buildplus'),
						'subtitle' => esc_html__('Choose what social networks to share','buildplus'),
						'options'  => array(
							'disabled' => array(
								'facebook'     => esc_html__( 'Facebook', 'buildplus' ),
								'twitter'      => esc_html__( 'Twitter', 'buildplus' ),
								'pinterest'    => esc_html__( 'Pinterest', 'buildplus' )
							),
							'enabled'  => array(
								'google-plus'  => esc_html__( 'Google plus', 'buildplus' ),
								'linkedin'     => esc_html__( 'Linkedin', 'buildplus' ),
								'digg'         => esc_html__( 'Digg', 'buildplus' )
							),
						),
					),
					array(
						'id'       => 'slz-post-social-share',
						'type'     => 'sorter',
						'title'    => esc_html__('Display Social Share','buildplus'),
						'subtitle' => esc_html__('Choose what post types to display social share in detail pages.','buildplus'),
						'options'  => array(
							'disabled' => array(
								
							),
							'enabled'  => array(
								'post'              => esc_html__( 'Post', 'buildplus' ),
								'buildplus_project' => esc_html__( 'Project', 'buildplus' ),
								'buildplus_service' => esc_html__( 'Service', 'buildplus' ),
							),
						),
					),
					array(
						'id'        => 'slz-social-share-section-end',
						'type'      => 'section',
						'indent'    => false,
					),
				)
			);

			// Header Setting
			$this->sections[] = array(
				'title'   => esc_html__( 'Header', 'buildplus' ),
				'desc'    => esc_html__( 'This section will change setting for header', 'buildplus' ),
				'icon'    => 'el-icon-caret-up',
				'fields'  => array(
					array(
						'id'			=> 'slz-header-layout',
						'type'			=> 'image_select',
						'title'			=> esc_html__( 'Header Style', 'buildplus' ),
						'indent'    	=> true,
						'subtitle'		=> esc_html__( 'Configuration Header Style : Logo, Menu,Header Top', 'buildplus' ),
						'options'  		=> array(
							'one'   => array(
								'alt' =>  esc_html__( 'Style 1', 'buildplus' ),
								'img' => esc_url($image_opt_path) . 'header_style_01.jpg'
							),
							'two'   => array(
								'alt' =>  esc_html__( 'Style 2', 'buildplus' ),
								'img' => esc_url($image_opt_path) . 'header_style_02.jpg'
							),
							'three'   => array(
								'alt' =>  esc_html__( 'Style 3', 'buildplus' ),
								'img' => esc_url($image_opt_path) . 'header_style_03.jpg'
							),
							'four'   => array(
								'alt' =>  esc_html__( 'Style 2', 'buildplus' ),
								'img' => esc_url($image_opt_path) . 'header_style_04.jpg'
							),
							'five'   => array(
								'alt' =>  esc_html__( 'Style 3', 'buildplus' ),
								'img' => esc_url($image_opt_path) . 'header_style_05.jpg'
							)
						),
						'default'  => 'three'
					),
					array(
						'id'        => 'slz-header-search-icon',
						'type'      => 'switch',
						'title'     => esc_html__( 'Search On Header', 'buildplus' ),
						'on'        => esc_html__( 'Show', 'buildplus' ),
						'off'       => esc_html__( 'Hide', 'buildplus' ),
						'default'   => false
					),
					array(
						'id'        => 'slz-header-subcribe',
						'type'      => 'switch',
						'title'     => esc_html__( 'Subcribe On Header', 'buildplus' ),
						'on'        => esc_html__( 'Show', 'buildplus' ),
						'off'       => esc_html__( 'Hide', 'buildplus' ),
						'default'   => false
					),
					array(
						'id'        => 'slz-header-tb-setting-start',
						'type'      => 'section',
						'title'     => esc_html__( 'Top Bar Settings', 'buildplus' ),
						'indent'    => true,
					),
					array(
					    'id'             => 'slz-topbar-icon-color',
					    'type'           => 'color',
					    'title'          => esc_html__('Icon Color', 'buildplus'), 
					    'transparent'    => false,
					    'validate'       => 'color',
					),
					array(
					    'id'             => 'slz-topbar-text-color',
					    'type'           => 'color',
					    'title'          => esc_html__('Text Color', 'buildplus'), 
					    'transparent'    => false,
					    'validate'       => 'color',
					),
					array(
						'id'        => 'slz-header-tl-section-start',
						'type'      => 'section',
						'title'     => esc_html__( 'Top Bar Left Content', 'buildplus' ),
						'subtitle'  => esc_html__( 'Configure detailed information for each content in top bar left', 'buildplus' ),
						'indent'    => true,
					),
					array(
						'id'       => 'slz-topbar-left-content',
						'type'     => 'sorter',
						'title'    => esc_html__( 'Content', 'buildplus' ),
						'subtitle' => esc_html__( 'if you select any content to display, please fill in informations of that content in the bottom', 'buildplus' ),
						'options'  => array(
							'disabled' => array(
								'social'        => esc_html__( 'Social', 'buildplus' ),
								'text'          => esc_html__( 'Simple Text', 'buildplus' ),
							),
							'enabled'  => array(
								'contact-info'  => esc_html__( 'Contact Information', 'buildplus' ),
							),
						),
					),
					array(
						'id'        => 'slz-topbar-left-contact',
						'type'      => 'multi_text',
						'title'     => esc_html__( 'Contact Infomation', 'buildplus' ),
						'subtitle'  => sprintf( wp_kses( __( 'Please use format: icon / content / description.<br>Ex: ["fa-phone","84 909 015 345","Support & Reply To Your Question"]', 'buildplus' ), array('br' => array()) )),
						'default'   => array('["fa-envelope-o","hello@swlabs.com"]','["fa-phone","84 909 015 345"]')
					),
					array(
						'id'       => 'slz-topbar-left-text',
						'type'     => 'text',
						'title'    => esc_html__( 'Simple Text', 'buildplus' ),
					),
					array(
						'id'       => 'slz-topbar-left-social',
						'type'     => 'sorter',
						'title'    => esc_html__( 'Social list', 'buildplus' ),
						'subtitle' => esc_html__( 'Please go on "Social" menu to enter social link', 'buildplus' ),
						'options'  => array(
							'disabled' => array(
								'instagram'    => esc_html__( 'Instagram', 'buildplus' ),
								'dribbble'     => esc_html__( 'Dribbble', 'buildplus' ),
								'pinterest'    => esc_html__( 'Pinterest', 'buildplus' ),
							),
							'enabled'  => array(
								'facebook'     => esc_html__( 'Facebook', 'buildplus' ),
								'google-plus'  => esc_html__( 'Google plus', 'buildplus' ),
								'twitter'      => esc_html__( 'Twitter', 'buildplus' ),
							),
						),
					),
					array(
						'id'     => 'slz-header-tl-section-end',
						'type'   => 'section',
						'indent' => false,
					),
					//top bar right content
					array(
						'id'        => 'slz-header-tr-section-start',
						'type'      => 'section',
						'title'     => esc_html__( 'Top Bar Right Content', 'buildplus' ),
						'subtitle'  => esc_html__( 'Configure detailed information for each content in top bar left', 'buildplus' ),
						'indent'    => true,
					),
					array(
						'id'       => 'slz-topbar-right-content',
						'type'     => 'sorter',
						'title'    => esc_html__( 'Content', 'buildplus' ),
						'subtitle' => esc_html__( 'if you select any content to display, please fill in informations of that content in the bottom', 'buildplus' ),
						'options'  => array(
							'disabled' => array(
								'social'        => esc_html__( 'Social', 'buildplus' ),
								'text'          => esc_html__( 'Simple Text', 'buildplus' ),
							),
							'enabled'  => array(
								'contact-info'  => esc_html__( 'Contact Information', 'buildplus' ),
							),
						),
					),
					array(
						'id'        => 'slz-topbar-right-contact',
						'type'      => 'multi_text',
						'title'     => esc_html__( 'Contact Infomation', 'buildplus' ),
						'subtitle'  => sprintf( wp_kses( __( 'Please use format: icon / Content.<br>Ex: ["fa-phone","84 909 015 345"]', 'buildplus' ), array('br' => array()) )),
						'default'   => array('["fa-envelope-o","hello@swlabs.com"]','["fa-phone","84 909 015 345"]')
					),
					array(
						'id'       => 'slz-topbar-right-text',
						'type'     => 'text',
						'title'    => esc_html__( 'Simple Text', 'buildplus' ),
					),
					array(
						'id'       => 'slz-topbar-right-social',
						'type'     => 'sorter',
						'title'    => esc_html__( 'Social list', 'buildplus' ),
						'subtitle' => esc_html__( 'Please go on "Social" menu to enter social link', 'buildplus' ),
						'options'  => array(
							'disabled' => array(
								'instagram'    => esc_html__( 'Instagram', 'buildplus' ),
								'dribbble'     => esc_html__( 'Dribbble', 'buildplus' ),
								'pinterest'    => esc_html__( 'Pinterest', 'buildplus' ),
							),
							'enabled'  => array(
								'facebook'     => esc_html__( 'Facebook', 'buildplus' ),
								'google-plus'  => esc_html__( 'Google plus', 'buildplus' ),
								'twitter'      => esc_html__( 'Twitter', 'buildplus' ),
							),
						),
					),
					array(
						'id'     => 'slz-header-tr-section-end',
						'type'   => 'section',
						'indent' => false,
					),
				)
			);

			// Menu
			$this->sections[] = array(
				'title'    => esc_html__( 'Menu', 'buildplus' ),
				'desc'     => esc_html__( 'Configuration for main navigation on top', 'buildplus' ),
				'icon'     => 'el-icon-brush',
				'fields'   => array(
					array(
					    'id'             => 'slz-menu-line-color',
					    'type'           => 'color',
					    'title'          => esc_html__('Line Color of Menu', 'buildplus'), 
					    'transparent'    => false,
					    'default'        => '#ffb400',
					    'validate'       => 'color',
					),
					array(
						'id'        => 'slz-submenu-section-start',
						'type'      => 'section',
						'title'     => esc_html__( 'Main Menu Setting', 'buildplus' ),
						'subtitle'  => esc_html__( 'Configuration for Main Menu', 'buildplus' ),
						'indent'    => true,
					),
					array(
						'id'        => 'slz-menu-custom',
						'type'      => 'switch',
						'title'     => esc_html__( 'Main Menu Custom', 'buildplus' ),
						'on'       	=> esc_html__( 'Custom', 'buildplus' ),
						'off'      	=> esc_html__( 'Default', 'buildplus' ),
						'default'   => false,
					),
					array(
						'id'        => 'slz-menu-item-text',
						'type'      => 'link_color',
						'title'     => esc_html__( 'Menu Item Color', 'buildplus' ),
						'subtitle'  => esc_html__( 'Set color for Menu item', 'buildplus' ),
						'required'  => array('slz-menu-custom','=',true),
						'default'   => array(
							'regular'   => '#ffffff',
							'hover'     => '',
							'active'    => ''
						)
					),
					array(
						'id'     => 'slz-submenu-section-end',
						'type'   => 'section',
						'indent' => false,
					),
					array(
						'id'        => 'slz-megamenu-section-start',
						'type'      => 'section',
						'title'     => esc_html__( 'Mega Menu Setting', 'buildplus' ),
						'indent'    => true,
					),
					array(
						'id'        => 'slz-megamenu-custom',
						'type'      => 'switch',
						'title'     => esc_html__( 'Mega Menu Custom', 'buildplus' ),
						'on'       	=> esc_html__( 'Custom', 'buildplus' ),
						'off'      	=> esc_html__( 'Default', 'buildplus' ),
						'default'   => false,
					),
					array(
						'id'        => 'slz-megamenu-color',
						'type'      => 'link_color',
						'title'     => esc_html__( 'Item Color', 'buildplus' ),
						'subtitle'  => esc_html__( 'Set color for text in submenu', 'buildplus' ),
						'required'  => array('slz-megamenu-custom','=',true),
						'default'   => array(
							'regular'   => '#61728d',
							'hover'     => '#ffb400',
							'active'    => '',
						)
					),
					array(
						'id'        => 'slz-megamenu-item-border',
						'type'      => 'border',
						'title'     => esc_html__( 'Border of Item', 'buildplus' ),
						'subtitle'  => esc_html__( 'Set borde attribute for mega menu', 'buildplus' ),
						'required'  => array('slz-megamenu-custom','=',true),
						'all'       => false,
						'top'       => false,
						'left'      => false,
						'right'     => false,
						'default'   => array(
							'border-style'  => 'solid',
							'border-color'  => 'rgba(0, 0, 0, .1)',
							'border-bottom' => '1px',
							'border-top'    => '0px',
							'border-left'   => '0px',
							'border-right'  => '0px'
						)
					),
					array(
						'id'             => 'slz-megamenu-padding',
						'type'           => 'spacing',
						'mode'           => 'padding',
						'all'            => false,
						'units'          => 'px',      // You can specify a unit value. Possible: px, em, %
						'units_extended' => 'false',   // Allow users to select any type of unit
						'title'          => esc_html__( 'SubMenu Item Padding', 'buildplus' ),
						'subtitle'       => esc_html__( 'Choose inwards spacing for each submenu item', 'buildplus' ),
						'desc'           => esc_html__( 'unit is "px"', 'buildplus' ),
						'required'  => array('slz-megamenu-custom','=',true),
						'default'        => false
					),
					array(
						'id'     => 'slz-megamenu-section-end',
						'type'   => 'section',
						'indent' => false,
					),
					
					array(
						'id'        => 'slz-dropdownmenu-section-start',
						'type'      => 'section',
						'title'     => esc_html__( 'Dropdown Menu Setting', 'buildplus' ),
						'subtitle'  => esc_html__( 'Configuration for submenu', 'buildplus' ),
						'indent'    => true,
					),
					array(
						'id'        => 'slz-dropdown-custom',
						'type'      => 'switch',
						'title'     => esc_html__( 'Dropdown Menu Custom', 'buildplus' ),
						'on'       	=> esc_html__( 'Custom', 'buildplus' ),
						'off'      	=> esc_html__( 'Default', 'buildplus' ),
						'default'   => false,
					),
					array(
						'id'        => 'slz-submenu-bg',
						'type'      => 'color_rgba',
						'title'     => esc_html__( 'Item Background Hover Color', 'buildplus' ),
						'required'  => array('slz-dropdown-custom','=',true),
						'default'   => array(
							'color'    => '#f5f5f5',
							'alpha'    => '1',
							'rgba'     => 'rgba(245, 245, 245, 1)'
						),
						'mode'      => 'background',
						'validate'  => 'colorrgba'
					),
					array(
						'id'        => 'slz-submenu-color',
						'type'      => 'link_color',
						'title'     => esc_html__( 'Item Color', 'buildplus' ),
						'subtitle'  => esc_html__( 'Set color for text in submenu', 'buildplus' ),
						'required'  => array('slz-dropdown-custom','=',true),
						'default'   => array(
							'regular'   => '#61728d',
							'hover'     => '#ffb400',
							'active'    => ''
						)
					),
					array(
						'id'             => 'slz-submenu-padding',
						'type'           => 'spacing',
						'mode'           => 'padding',
						'all'            => false,
						'units'          => 'px',      // You can specify a unit value. Possible: px, em, %
						'units_extended' => 'false',   // Allow users to select any type of unit
						'title'          => esc_html__( 'SubMenu Item Padding', 'buildplus' ),
						'subtitle'       => esc_html__( 'Choose inwards spacing for each submenu item', 'buildplus' ),
						'desc'           => esc_html__( 'unit is "px"', 'buildplus' ),
						'required'  => array('slz-dropdown-custom','=',true),
						'default'        => false
					),
					array(
						'id'        => 'slz-dropdownmenu-align',
						'type'      => 'radio',
						'title'     => esc_html__( 'Dropdown Menu Align', 'buildplus' ),
						'options'   => array(
							'left'     => esc_html__( 'Left', 'buildplus' ),
							'right'    => esc_html__( 'Right', 'buildplus' )
						),
						'required'  => array('slz-dropdown-custom','=',true),
						'default'   => 'left'
					),
					array(
						'id'     => 'slz-dropdownmenu-section-end',
						'type'   => 'section',
						'indent' => false,
					),
				)
			);

			// Page title setting
			$this->sections[] = array(
				'title'     => esc_html__( 'Page Title Setting', 'buildplus' ),
				'icon'      => 'el-icon-website',
				'fields'    => array(
					array(
						'id'        => 'slz-page-title-show',
						'type'      => 'switch',
						'title'     => esc_html__( 'Show Page Title', 'buildplus' ),
						'subtitle'  => esc_html__( 'Choose to show or hide page title', 'buildplus' ),
						'on'       	=> esc_html__( 'Show', 'buildplus'),
						'off'      	=> esc_html__( 'Hide', 'buildplus'),
						'default'   => true,
					),
					array(
						'id'        => 'slz-page-title-bg',
						'type'      => 'background',
						'title'     => esc_html__( 'Page Title background image', 'buildplus' ),
						'subtitle'  => esc_html__( 'Body background image for page title section', 'buildplus' ),
						'default'   => array(
							'background-color'      => '#213047',
							'background-repeat'     => 'no-repeat',
							'background-size'       => 'cover',
							'background-attachment' => 'fixed',
							'background-position'   => 'center center',
							'background-image'      => ''
						),
					),
					array(
						'id'     	=> 'slz-pagetitle-pl-notice',
						'type'   	=> 'info',
						'notice' 	=> false,
						'style'  	=> 'info',
						'title'  	=> esc_html__( 'Background Parallax', 'buildplus' ),
						'desc'   	=> esc_html__( 'To use background parallax effect for Page Title, please set background-attachment field is "Fixed"', 'buildplus')
					),
					array(
						'id'             => 'slz-page-title-height',
						'type'           => 'dimensions',
						'units'          => 'px',
						'units_extended' => 'false',
						'all'			 => false,
						'width'			 => false,
						'title'          => esc_html__( 'Page Title Height', 'buildplus' ),
						'default'        => array (
							'width'		=> 'auto',
							'height'	=> '400px'
						)
					),
					array(
					    'id'             => 'slz-pagetitle-line-color',
					    'type'           => 'color',
					    'title'          => esc_html__('Line Color of Page Title', 'buildplus'), 
					    'transparent'    => false,
					    'default'        => '#ffb400',
					    'validate'       => 'color',
					),
					array(
						'id'        => 'slz-pagetitle-align',
						'type'      => 'radio',
						'title'     => esc_html__( 'Page Title Text Align', 'buildplus' ),
						'options'   => array(
							'left'     => esc_html__( 'Left', 'buildplus' ),
							'right'    => esc_html__( 'Right', 'buildplus' ),
						),
						'default'   => 'left'
					),
					array(
						'id'        => 'slz-title-section-start',
						'type'      => 'section',
						'title'     => esc_html__( 'The Title', 'buildplus' ),
						'indent'    => true,
					),
					array(
						'id'       => 'slz-show-title',
						'type'     => 'switch',
						'title'    => esc_html__( 'Show Title', 'buildplus' ),
						'subtitle' => esc_html__( 'Choose to show or hide Title (only apply for page)', 'buildplus' ),
						'on'       => esc_html__( 'Show', 'buildplus'),
						'off'      => esc_html__( 'Hide', 'buildplus'),
						'default'  => true,
					),
					array(
						'id'        => 'slz-page-title-type-display',
						'type'      => 'radio',
						'title'     => esc_html__( 'Type Page Title', 'buildplus' ),
						'subtitle'  => esc_html__( 'Choose "Level Title" to show label of the level  if it at page of archive, taxonomy or page has hierarchical', 'buildplus' ),
						'options'   => array(
										'post' => esc_html__( 'Default', 'buildplus' ),
										'level' => esc_html__( 'Level Title', 'buildplus' )
									),
						'default'   => 'post',
					),
					array(
						'id'             => 'slz-pagetitle-title',
						'type'           => 'typography',
						'title'          => esc_html__( 'Title', 'buildplus' ),
						'google'         => false,
						'font-backup'    => true,
						'line-height'    => false,
						'preview'        => true,
						'text-transform' => true,
						'font-family'    => false,
						'text-align'     => false,
						'all_styles'     => true,
						'units'          => 'px',
						// Defaults to px
						'subtitle'       => esc_html__( 'Config typography for page title text', 'buildplus' ),
						'default'        => array(
							'color'           => '#ffffff',
							'font-weight'     => '700',
							'font-size'       => '30px',
							'text-transform'  => 'uppercase'
						),
					),
					array(
						'id'     => 'slz-title-section-end',
						'type'   => 'section',
						'indent' => false,
					),
					array(
						'id'        => 'slz-breadcrumb-section-start',
						'type'      => 'section',
						'title'     => esc_html__( 'Breadcrumb', 'buildplus' ),
						'subtitle'  => esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipisicing.', 'buildplus' ),
						'indent'    => true,
					),
					array(
						'id'        => 'slz-show-breadcrumb',
						'type'      => 'switch',
						'title'     => esc_html__( 'Show Breadcrumb', 'buildplus' ),
						'subtitle'  => esc_html__( 'Choose to show or hide breadcrumb', 'buildplus' ),
						'on'        => esc_html__( 'Show', 'buildplus'),
						'off'       => esc_html__( 'Hide', 'buildplus'),
						'default'   => true,
					),
					array(
						'id'             => 'slz-breadcrumb-path',
						'type'           => 'typography',
						'title'          => esc_html__( 'Breadcrumb Path', 'buildplus' ),
						'google'         => false,
						'font-backup'    => true,
						'line-height'    => false,
						'preview'        => true,
						'text-transform' => true,
						'font-family'    => false,
						'text-align'     => false,
						'all_styles'     => true,
						'units'          => 'px',
						// Defaults to px
						'subtitle'       => esc_html__( 'Config typography for breadcrumb title', 'buildplus' ),
						'default'        => array(
							'color'           => '#d4e3ee',
							'font-weight'     => '400',
							'font-size'       => '14px',
							'text-transform'  => 'capitalize',
						)
					),
					array(
						'id'             => 'slz-breadcrumb-path2',
						'type'           => 'typography',
						'title'          => esc_html__( 'Breadcrumb Text', 'buildplus' ),
						'google'         => false,
						'font-backup'    => false,
						'line-height'    => false,
						'preview'        => true,
						'text-transform' => true,
						'font-family'    => false,
						'text-align'     => false,
						'all_styles'     => false,
						'units'          => 'px',
						// Defaults to px
						'subtitle'       => esc_html__( 'Config typography for breadcrumb title', 'buildplus' ),
						'default'        => array(
							'color'           => '#fff',
							'font-weight'     => '400',
							'font-size'       => '14px',
							'text-transform'  => 'capitalize',
						)
					),
					array(
						'id'     => 'slz-breadcrumb-section-end',
						'type'   => 'section',
						'indent' => false,
					),
				)
			);

			// Sidebar setting
			$this->sections[] = array(
				'title'     => esc_html__( 'Sidebar', 'buildplus' ),
				'desc'      => esc_html__( 'Configuration for sidebar', 'buildplus' ),
				'icon'      => 'el-icon-caret-right',
				'fields'    => array(
					array(
						'id'        => 'slz-sidebar-section-st',
						'type'      => 'section',
						'title'     => esc_html__( 'Default Sidebar', 'buildplus' ),
						'indent'    => true,
					),
					array(
						'id'        => 'slz-sidebar-layout',
						'type'      => 'image_select',
						'title'     => esc_html__( 'Default Sidebar Layout', 'buildplus' ),
						'subtitle'  => esc_html__( 'Set how to display default sidebar', 'buildplus' ),
						'options'   => array(
							'left'  => array(
								'alt' => esc_html__( 'left', 'buildplus' ),
								'img' => esc_url($image_opt_path) . 'left.png'
							),
							'right' => array(
								'alt' => esc_html__( 'right', 'buildplus' ),
								'img' => esc_url($image_opt_path) . 'right.png'
							),
							'none'  => array(
								'alt' => esc_html__( 'none', 'buildplus' ),
								'img' => esc_url($image_opt_path) . 'nosidebar.png'
							)
						),
						'default'   => 'left'
					),
					array(
						'id'       	=> 'slz-sidebar',
						'type'     	=> 'select',
						'data'     	=> 'sidebars',
						'title'    	=> esc_html__( 'Default Sidebar', 'buildplus' ),
						'subtitle'	=> sprintf(esc_html__( 'You can create new sidebar in Appearance -> %s', 'buildplus' ), $admin_widget_url ),
						'default'  	=> ''
					),
					
					array(
						'id'        => 'slz-bsidebar-section-st',
						'type'      => 'section',
						'title'     => esc_html__( 'Blog Sidebar', 'buildplus' ),
						'indent'    => true,
					),
					array(
						'id'        => 'slz-blog-sidebar-layout',
						'type'      => 'image_select',
						'title'     => esc_html__( 'Blog Sidebar Layout', 'buildplus' ),
						'subtitle'  => esc_html__( 'Set how to display sidebar  in blog single pages.', 'buildplus' ),
						'options'   => array(
							'left'  => array(
								'alt' => esc_html__( 'left', 'buildplus' ),
								'img' => esc_url($image_opt_path) . 'left.png'
							),
							'right' => array(
								'alt' => esc_html__( 'right', 'buildplus' ),
								'img' => esc_url($image_opt_path) . 'right.png'
							),
							'none'  => array(
								'alt' => esc_html__( 'none', 'buildplus' ),
								'img' => esc_url($image_opt_path) . 'nosidebar.png'
							)
						),
						'default'   => 'left'
					),
					array(
						'id'       	=> 'slz-blog-sidebar',
						'type'     	=> 'select',
						'data'     	=> 'sidebars',
						'title'    	=> esc_html__( 'Blog Sidebar', 'buildplus' ),
						'subtitle'	=> sprintf( esc_html__( 'You can create new sidebar in Appearance -> %s', 'buildplus' ), $admin_widget_url ),
						'default'  	=> ''
					),
					array(
						'id'     => 'slz-bsidebar-section-ed',
						'type'   => 'section',
						'indent' => false,
					),
					
					//project  sidebar
					array(
						'id'        => 'slz-psidebar-section-st',
						'type'      => 'section',
						'title'     => esc_html__( 'Project Sidebar', 'buildplus' ),
						'indent'    => true,
					),
					array(
						'id'        => 'slz-project-sidebar-layout',
						'type'      => 'image_select',
						'title'     => esc_html__( 'Project Detail Sidebar Layout', 'buildplus' ),
						'subtitle'  => esc_html__( 'Set how to display sidebar in project detail pages.', 'buildplus' ),
						'options'   => array(
							'left'  => array(
								'alt' => esc_html__( 'left', 'buildplus' ),
								'img' => esc_url($image_opt_path) . 'left.png'
							),
							'right' => array(
								'alt' => esc_html__( 'right', 'buildplus' ),
								'img' => esc_url($image_opt_path) . 'right.png'
							),
							'none'  => array(
								'alt' => esc_html__( 'none', 'buildplus' ),
								'img' => esc_url($image_opt_path) . 'nosidebar.png'
							)
						),
						'default'   => 'none'
					),
					array(
						'id'        => 'slz-project-sidebar',
						'type'      => 'select',
						'data'      => 'sidebars',
						'title'     => esc_html__( 'Project Detail Sidebar', 'buildplus' ),
						'subtitle'  => sprintf( esc_html__( 'You can create new sidebar in Appearance -> %s', 'buildplus' ), $admin_widget_url ),
						'default'   => ''
					),
					//archive project
					array(
						'id'        => 'slz-project-ac-sidebar-layout',
						'type'      => 'image_select',
						'title'     => esc_html__( 'Project Archive Sidebar Layout', 'buildplus' ),
						'subtitle'  => esc_html__( 'Set how to display sidebar in project archive pages.', 'buildplus' ),
						'options'   => array(
							'left'  => array(
								'alt' => esc_html__( 'left', 'buildplus' ),
								'img' => esc_url($image_opt_path) . 'left.png'
							),
							'right' => array(
								'alt' => esc_html__( 'right', 'buildplus' ),
								'img' => esc_url($image_opt_path) . 'right.png'
							),
							'none'  => array(
								'alt' => esc_html__( 'none', 'buildplus' ),
								'img' => esc_url($image_opt_path) . 'nosidebar.png'
							)
						),
						'default'   => 'left'
					),
					array(
						'id'        => 'slz-project-ac-sidebar',
						'type'      => 'select',
						'data'      => 'sidebars',
						'title'     => esc_html__( 'Project Archive Sidebar', 'buildplus' ),
						'subtitle'  => sprintf( esc_html__( 'You can create new sidebar in Appearance -> %s', 'buildplus' ), $admin_widget_url ),
						'default'   => ''
					),

					array(
						'id'        => 'slz-psidebar-section-ed',
						'type'      => 'section',
						'indent'    => false,
					),
					//service  sidebar
					array(
						'id'        => 'slz-sersidebar-section-st',
						'type'      => 'section',
						'title'     => esc_html__( 'Service Sidebar', 'buildplus' ),
						'indent'    => true,
					),
					array(
						'id'        => 'slz-service-sidebar-layout',
						'type'      => 'image_select',
						'title'     => esc_html__( 'Service Detail Sidebar Layout', 'buildplus' ),
						'subtitle'  => esc_html__( 'Set how to display sidebar in service detail pages.', 'buildplus' ),
						'options'   => array(
							'left'  => array(
								'alt' => esc_html__( 'left', 'buildplus' ),
								'img' => esc_url($image_opt_path) . 'left.png'
							),
							'right' => array(
								'alt' => esc_html__( 'right', 'buildplus' ),
								'img' => esc_url($image_opt_path) . 'right.png'
							),
							'none'  => array(
								'alt' => esc_html__( 'none', 'buildplus' ),
								'img' => esc_url($image_opt_path) . 'nosidebar.png'
							)
						),
						'default'   => 'left'
					),
					array(
						'id'        => 'slz-service-sidebar',
						'type'      => 'select',
						'data'      => 'sidebars',
						'title'     => esc_html__( 'Service Detail Sidebar', 'buildplus' ),
						'subtitle'  => sprintf( esc_html__( 'You can create new sidebar in Appearance -> %s', 'buildplus' ), $admin_widget_url ),
						'default'   => ''
					),
					//service archive
					array(
						'id'        => 'slz-service-sc-sidebar-layout',
						'type'      => 'image_select',
						'title'     => esc_html__( 'Service Archive Sidebar Layout', 'buildplus' ),
						'subtitle'  => esc_html__( 'Set how to display sidebar in service archive pages.', 'buildplus' ),
						'options'   => array(
							'left'  => array(
								'alt' => esc_html__( 'left', 'buildplus' ),
								'img' => esc_url($image_opt_path) . 'left.png'
							),
							'right' => array(
								'alt' => esc_html__( 'right', 'buildplus' ),
								'img' => esc_url($image_opt_path) . 'right.png'
							),
							'none'  => array(
								'alt' => esc_html__( 'none', 'buildplus' ),
								'img' => esc_url($image_opt_path) . 'nosidebar.png'
							)
						),
						'default'   => 'left'
					),
					array(
						'id'        => 'slz-service-sc-sidebar',
						'type'      => 'select',
						'data'      => 'sidebars',
						'title'     => esc_html__( 'Service Archive Sidebar', 'buildplus' ),
						'subtitle'  => sprintf( esc_html__( 'You can create new sidebar in Appearance -> %s', 'buildplus' ), $admin_widget_url ),
						'default'   => ''
					),
						
					array(
						'id'        => 'slz-sersidebar-section-ed',
						'type'      => 'section',
						'indent'    => false,
					),
					//team  sidebar
					array(
						'id'        => 'slz-tsidebar-section-st',
						'type'      => 'section',
						'title'     => esc_html__( 'Team Sidebar', 'buildplus' ),
						'indent'    => true,
					),
					array(
						'id'        => 'slz-team-sidebar-layout',
						'type'      => 'image_select',
						'title'     => esc_html__( 'Team Detail Sidebar Layout', 'buildplus' ),
						'subtitle'  => esc_html__( 'Set how to display sidebar in team detail pages.', 'buildplus' ),
						'options'   => array(
							'left'  => array(
								'alt' => esc_html__( 'left', 'buildplus' ),
								'img' => esc_url($image_opt_path) . 'left.png'
							),
							'right' => array(
								'alt' => esc_html__( 'right', 'buildplus' ),
								'img' => esc_url($image_opt_path) . 'right.png'
							),
							'none'  => array(
								'alt' => esc_html__( 'none', 'buildplus' ),
								'img' => esc_url($image_opt_path) . 'nosidebar.png'
							)
						),
						'default'   => 'none'
					),
					array(
						'id'        => 'slz-team-sidebar',
						'type'      => 'select',
						'data'      => 'sidebars',
						'title'     => esc_html__( 'Team Detail Sidebar', 'buildplus' ),
						'subtitle'  => sprintf( esc_html__( 'You can create new sidebar in Appearance -> %s', 'buildplus' ), $admin_widget_url ),
						'default'   => ''
					),
					//team archive
					array(
						'id'        => 'slz-team-ac-sidebar-layout',
						'type'      => 'image_select',
						'title'     => esc_html__( 'Team Archive Sidebar Layout', 'buildplus' ),
						'subtitle'  => esc_html__( 'Set how to display sidebar in team archive pages.', 'buildplus' ),
						'options'   => array(
							'left'  => array(
								'alt' => esc_html__( 'left', 'buildplus' ),
								'img' => esc_url($image_opt_path) . 'left.png'
							),
							'right' => array(
								'alt' => esc_html__( 'right', 'buildplus' ),
								'img' => esc_url($image_opt_path) . 'right.png'
							),
							'none'  => array(
								'alt' => esc_html__( 'none', 'buildplus' ),
								'img' => esc_url($image_opt_path) . 'nosidebar.png'
							)
						),
						'default'   => 'left'
					),
					array(
						'id'        => 'slz-team-ac-sidebar',
						'type'      => 'select',
						'data'      => 'sidebars',
						'title'     => esc_html__( 'Team Archive Sidebar', 'buildplus' ),
						'subtitle'  => sprintf( esc_html__( 'You can create new sidebar in Appearance -> %s', 'buildplus' ), $admin_widget_url ),
						'default'   => ''
					),
					array(
						'id'        => 'slz-tsidebar-section-ed',
						'type'      => 'section',
						'indent'    => false,
					),
					//product  sidebar
					array(
						'id'        => 'slz-productsidebar-section-st',
						'type'      => 'section',
						'title'     => esc_html__( 'Product Sidebar', 'buildplus' ),
						'indent'    => true,
					),
					array(
						'id'        => 'slz-shop-sidebar-layout',
						'type'      => 'image_select',
						'title'     => esc_html__( 'Product Sidebar Layout', 'buildplus' ),
						'subtitle'  => esc_html__( 'Set how to display sidebar in product pages.', 'buildplus' ),
						'options'   => array(
							'left'  => array(
								'alt' => esc_html__( 'left', 'buildplus' ),
								'img' => esc_url($image_opt_path) . 'left.png'
							),
							'right' => array(
								'alt' => esc_html__( 'right', 'buildplus' ),
								'img' => esc_url($image_opt_path) . 'right.png'
							),
							'none'  => array(
								'alt' => esc_html__( 'none', 'buildplus' ),
								'img' => esc_url($image_opt_path) . 'nosidebar.png'
							)
						),
						'default'   => 'left'
					),
					array(
						'id'        => 'slz-shop-sidebar',
						'type'      => 'select',
						'data'      => 'sidebars',
						'title'     => esc_html__( 'Product Detail Sidebar', 'buildplus' ),
						'subtitle'  => sprintf( esc_html__( 'You can create new sidebar in Appearance -> %s', 'buildplus' ), $admin_widget_url ),
						'default'   => ''
					),
						
					array(
						'id'        => 'slz-productsidebar-section-ed',
						'type'      => 'section',
						'indent'    => false,
					),
					
				)
			);

			// Footer setting
			$this->sections[] = array(
				'title'     => esc_html__( 'Footer', 'buildplus' ),
				'icon'      => 'el-icon-caret-down',
				'desc'      => esc_html__( 'Configuration for footer of site', 'buildplus' ),
				'fields'    => array(
					array(
						'id'        => 'slz-footer',
						'type'      => 'switch',
						'title'     => esc_html__( 'Footer Section', 'buildplus' ),
						'on'        => esc_html__( 'Show', 'buildplus' ),
						'off'       => esc_html__( 'Hide', 'buildplus' ),
						'default'   => true
					),
					array(
						'id'        => 'slz-footer-subcribe',
						'type'      => 'switch',
						'title'     => esc_html__( 'Subcribe On Footer', 'buildplus' ),
						'on'        => esc_html__( 'Show', 'buildplus' ),
						'off'       => esc_html__( 'Hide', 'buildplus' ),
						'default'   => false
					),
					array(
						'id'       => 'slz-footer-style',
						'type'     => 'button_set',
						'title'    => esc_html__('Footer Style', 'buildplus'),
						'options' => array(
							'dark'     => esc_html__( 'Dark', 'buildplus'), 
							'light'    => esc_html__( 'Light', 'buildplus'),
						), 
						'default' => 'dark'
					),
					array(
						'id'        => 'slz-footer-top-section-st',
						'type'      => 'section',
						'title'     => esc_html__( 'Footer Top', 'buildplus' ),
						'indent'    => true,
					),
					array(
						'id'        => 'slz-footer-top-show',
						'type'      => 'switch',
						'title'     => esc_html__( 'Footer Top', 'buildplus' ),
						'subtitle'	=> sprintf(esc_html__( 'You can add widget in footer top at Appearance -> %s -> Footer Top Area', 'buildplus' ), $admin_widget_url ),
						'on'        => esc_html__( 'Show', 'buildplus' ),
						'off'       => esc_html__( 'Hide', 'buildplus' ),
						'default'   => false
					),
					array(
						'id'        => 'slz-footerbt-top-section-ed',
						'type'      => 'section',
						'indent'    => true,
					),
					array(
						'id'        => 'slz-footerbt-main-section-st',
						'type'      => 'section',
						'title'     => esc_html__( 'Footer Main', 'buildplus' ),
						'indent'    => true,
					),
					array(
						'id'        => 'slz-footer-main-info',
						'type'      => 'switch',
						'title'     => esc_html__( 'Footer Main', 'buildplus' ),
						'on'        => esc_html__( 'Show', 'buildplus' ),
						'off'       => esc_html__( 'Hide', 'buildplus' ),
						'default'   => false
					),
					array(
						'id'        => 'slz-footer-bg',
						'type'      => 'background',
						'title'     => esc_html__( 'Footer Dark Background Image', 'buildplus' ),
						'subtitle'  => esc_html__( 'Set background image for footer section', 'buildplus' ),
						'required'  => array('slz-footer-style','=','dark'),
						'default'   => array(
							'background-color'      => '#1d2a3d',
							'background-image'      => '',
							'background-repeat'     => 'no-repeat',
							'background-attachment' => '',
							'background-position'	=> '',
							'background-size'		=> ''
						)
					),
					array(
						'id'        => 'slz-footer-light-bg',
						'type'      => 'background',
						'title'     => esc_html__( 'Footer Light background image', 'buildplus' ),
						'subtitle'  => esc_html__( 'Set background image for footer section', 'buildplus' ),
						'required'  => array('slz-footer-style','=',array('light','default')),
						'default'   => array(
							'background-color'      => '#f9f9f9',
							'background-image'      => '',
							'background-repeat'     => 'no-repeat',
							'background-attachment' => '',
							'background-position'	=> '',
							'background-size'		=> ''
						)
					),
					array(
					    'id'        => 'slz-footer-mask',
					    'type'      => 'color_rgba',
					    'title'     => esc_html__( 'Footer overlay background', 'buildplus' ),
					    'subtitle'  => esc_html__( 'Set background color for mask layer above footer', 'buildplus' ),
					    'default'   => array(
					        'color'     => '',
					        'rgba'     => 'rgba(255, 255, 255, 0)',
					        )
				    ),
					array(
						'id'        => 'slz-footer-col',
						'type'      => 'radio',
						'title'     => esc_html__( 'Columns', 'buildplus' ),
						'subtitle'  => sprintf( wp_kses( __( 'Choose grid layout for footer.<br> Please go on "Appearance->%1$s" to set data for footer', 'buildplus' ), array('br' => array()) ), $admin_widget_url),
						'options'   => array(
							'11' => esc_html__( '1 Column & Text Center', 'buildplus' ),
							'1'  => esc_html__( '1 Column', 'buildplus' ),
							'2'  => esc_html__( '2 Columns', 'buildplus' ),
							'3'  => esc_html__( '3 Columns', 'buildplus' ),
							'4'  => esc_html__( '4 Columns', 'buildplus' )
						),
						'default'   => '4'
					),
					array(
						'id'        => 'slz-footerbt-main-section-ed',
						'type'      => 'section',
						'indent'    => true,
					),
					array(
						'id'        => 'slz-footerbt-section-st',
						'type'      => 'section',
						'title'     => esc_html__( 'Footer Bottom', 'buildplus' ),
						'indent'    => true,
					),
					array(
						'id'        => 'slz-footerbt-show',
						'type'      => 'switch',
						'title'     => esc_html__( 'Footer Bottom', 'buildplus' ),
						'on'        => esc_html__( 'Show', 'buildplus' ),
						'off'       => esc_html__( 'Hide', 'buildplus' ),
						'default'   => true,
					),
					array(
						'id'        => 'slz-footerbt-col1',
						'type'      => 'sorter',
						'title'     => esc_html__( 'Content Of 1st Column', 'buildplus' ),
						'subtitle'  => esc_html__( 'Choose what information to show in 1st column', 'buildplus' ),
						'options'   => array(
							'disabled' => array(
								'social'  => esc_html__( 'Social', 'buildplus' ),
								'menu'    => esc_html__( 'Navigation', 'buildplus' ),
							),
							'enabled'  => array(
								'text'    => esc_html__( 'Text', 'buildplus' ),
							),
						),
					),
					array(
						'id'        => 'slz-footerbt1-text',
						'type'      => 'textarea',
						'title'     => esc_html__( 'Text Of 1st Column', 'buildplus' ),
						'subtitle'  => esc_html__( 'Information of footer bottom', 'buildplus' ),
						'default'   => BUILDPLUS_COPYRIGHT,
					),
					array(
						'id'        => 'slz-footerbt-col2',
						'type'      => 'sorter',
						'title'     => esc_html__( 'Content Of 2nd Column', 'buildplus' ),
						'subtitle'  => esc_html__( 'Choose what information to show in 2nd column', 'buildplus' ),
						'options'   => array(
							'disabled' => array(
								'menu'    => esc_html__( 'Navigation', 'buildplus' ),
								'social'  => esc_html__( 'Social', 'buildplus' ),
								'text'    => esc_html__( 'Text', 'buildplus' ),
							),
							'enabled'  => array(
							),
						),
					),
					array(
						'id'        => 'slz-footerbt2-text',
						'type'      => 'textarea',
						'title'     => esc_html__( 'Text Of 2nd Column', 'buildplus' ),
						'default'   => BUILDPLUS_COPYRIGHT,
					),
					array(
						'id'        => 'slz-footerbt-col3',
						'type'      => 'sorter',
						'title'     => esc_html__( 'Content Of 3rd Column', 'buildplus' ),
						'subtitle'  => esc_html__( 'Choose what information to show in 3rd column', 'buildplus' ),
						'options'   => array(
							'disabled' => array(
								'text'    => esc_html__( 'Text', 'buildplus' ),
								'social'  => esc_html__( 'Social', 'buildplus' ),
							),
							'enabled'  => array(
								
								'menu'    => esc_html__( 'Navigation', 'buildplus' ),
							),
						),
					),
					array(
						'id'        => 'slz-footerbt3-text',
						'type'      => 'textarea',
						'title'     => esc_html__( 'Text Of 3rd Column', 'buildplus' ),
						'default'   => BUILDPLUS_COPYRIGHT,
					),
					array(
						'id'       => 'slz-footerbt-social',
						'type'     => 'sorter',
						'title'    => esc_html__('Social','buildplus'),
						'subtitle' => esc_html__('Choose what social networks to share','buildplus'),
						'options'  => array(
							'disabled' => array(
								'facebook'     => esc_html__( 'Facebook', 'buildplus' ),
								'twitter'      => esc_html__( 'Twitter', 'buildplus' ),
								'pinterest'    => esc_html__( 'Pinterest', 'buildplus' )
							),
							'enabled'  => array(
								'google-plus'  => esc_html__( 'Google plus', 'buildplus' ),
								'linkedin'     => esc_html__( 'Linkedin', 'buildplus' ),
								'digg'         => esc_html__( 'Digg', 'buildplus' )
							),
						),
					),
					array(
						'id'     => 'slz-footerbt-section-ed',
						'type'   => 'section',
						'indent' => false,
					)
				)
			);
			// Subcribe
			$this->sections[] = array(
				'title'     => esc_html__( 'Subcribe', 'buildplus' ),
				'icon'      => 'el el-pencil',
				'desc'      => esc_html__( 'Configuration for subcribe of site', 'buildplus' ),
				'fields'    => array(
					array(
						'id'        => 'slz-footer-subcribe-title',
						'type'      => 'editor',
						'title'     => esc_html__( 'Title & Description', 'buildplus' ),
					),
					array(
						'id'        => 'slz-footer-subcribe-bg',
						'type'      => 'background',
						'title'     => esc_html__( 'Subcribe Background', 'buildplus' ),
						'subtitle'  => esc_html__( 'Body background for subcribe section', 'buildplus' ),
						'default'   => array(
							'background-color'      => '#ffb400',
							'background-repeat'     => 'no-repeat',
							'background-size'       => 'cover',
							'background-attachment' => 'fixed',
							'background-position'   => 'center center',
							'background-image'      => ''
						),
					),
					array(
						'id'        => 'slz-footer-subcribe-btn',
						'type'      => 'text',
						'required'  => array('slz-footer-subcribe','=',true),
						'title'     => esc_html__( 'Button Text', 'buildplus' ),
						'subtitle'  => esc_html__( 'Enter text of button, leave this box blank if you do not show button', 'buildplus' ),
					),
					array(
						'id'        => 'slz-footer-subcribe-btn-link-custom',
						'type'      => 'text',
						'title'     => esc_html__( 'Button Link(Custom)', 'buildplus'),
						'subtitle'  => esc_html__( 'Empty this field if you want to choose link to page', 'buildplus' ),
					),
					array(
						'id'        => 'slz-footer-subcribe-btn-link',
						'type'      => 'select',
						'data'      => 'pages',
						'title'     => esc_html__( 'Button Link(Link To Page)', 'buildplus' ),
						'default'   => '1',
					),
					array(
						'id'        => 'slz-footer-subcribe-end',
						'type'      => 'section',
						'indent'    => false,
					),
				)
			);
			
			// Blog Setting
			$this->sections[] = array(
				'title'     => esc_html__( 'Blog Display', 'buildplus' ),
				'icon'      => 'el-icon-edit',
				'desc'      => esc_html__( 'Configuration layout for blog template', 'buildplus' ),
				'fields'    => array(
					array(
						'id'       => 'slz-blog-showdate',
						'type'     => 'button_set',
						'title'    => esc_html__('Date Style', 'buildplus'),
						'options' => array(
							'ribbon'   => esc_html__( 'Ribbon', 'buildplus'),
							'normal'   => esc_html__( 'Normal', 'buildplus'), 
							'hie'      => esc_html__( 'Hide', 'buildplus'),
						), 
						'default' => 'ribbon'
					),
					array(
						'id'        => 'slz-bloginfo',
						'type'      => 'sorter',
						'title'     => esc_html__( 'Blog Info', 'buildplus' ),
						'subtitle'  => esc_html__( 'Choose what information to show below blog content', 'buildplus' ),
						'options'   => array(
							'disabled' => array(

							),
							'enabled'  => array(
								'author'    => esc_html__( 'Author', 'buildplus' ),
								'view'      => esc_html__( 'View', 'buildplus' ),
								'comment'   => esc_html__( 'Comment number', 'buildplus' ),
							),
						),
					),
					
					array(
						'id'        => 'slz-blog-author',
						'type'      => 'switch',
						'title'     => esc_html__( 'Author Section', 'buildplus' ),
						'on'        => esc_html__( 'Show', 'buildplus' ),
						'off'       => esc_html__( 'Hide', 'buildplus' ),
						'default'   => true
					),
					array(
						'id'        => 'slz-blog-tag',
						'type'      => 'switch',
						'title'     => esc_html__( 'Tag Section', 'buildplus' ),
						'on'        => esc_html__( 'Show', 'buildplus' ),
						'off'       => esc_html__( 'Hide', 'buildplus' ),
						'default'   => true
					),
					array(
						'id'        => 'slz-blog-cat',
						'type'      => 'switch',
						'title'     => esc_html__( 'Category Section', 'buildplus' ),
						'on'        => esc_html__( 'Show', 'buildplus' ),
						'off'       => esc_html__( 'Hide', 'buildplus' ),
						'default'   => true
					),
					array(
						'id'        => 'slz-blog-related-post',
						'type'      => 'switch',
						'title'     => esc_html__( 'Post Navigation', 'buildplus' ),
						'on'        => esc_html__( 'Show', 'buildplus' ),
						'off'       => esc_html__( 'Hide', 'buildplus' ),
						'default'   => true
					),
					array(
						'id'        => 'slz-commentbox',
						'type'      => 'switch',
						'title'     => esc_html__( 'Comments Section', 'buildplus' ),
						'on'        => esc_html__( 'Show', 'buildplus' ),
						'off'       => esc_html__( 'Hide', 'buildplus' ),
						'default'   => true
					),
				)
			);

			// Project Setting
			$this->sections[] = array(
				'title'     => esc_html__( 'Project Setting', 'buildplus' ),
				'icon'      => 'el el-list',
				'desc'      => esc_html__( 'Setting for page project detail', 'buildplus' ),
				'fields'    => array(
					array(
						'id'        => 'slz-project-show',
						'type'      => 'switch',
						'title'     => esc_html__( 'Show Related Project', 'buildplus' ),
						'on'        => esc_html__( 'Show', 'buildplus' ),
						'off'       => esc_html__( 'Hide', 'buildplus' ),
						'default'   => true
					),
					array(
						'id'        => 'slz-project-title',
						'type'      => 'text',
						'title'     => esc_html__( 'Related Project Title', 'buildplus' ),
						'required'  => array( 'slz-project-show','=',true ),
					),
					array(
						'id'        => 'slz-project-subtitle',
						'type'      => 'text',
						'title'     => esc_html__( 'Related Project Sub Title', 'buildplus' ),
						'required'  => array( 'slz-project-show','=',true ),
					),
					array(
						'id'       => 'slz-project-bg',
						'type'     => 'background',
						'title'    => esc_html__( 'Background', 'buildplus' ),
						'subtitle' => esc_html__( 'Choose background for related project session in  page "project detail"', 'buildplus' ),
						'required'  => array( 'slz-project-show','=',true ),
						'default'  => array(
							'background-color'      => '#ffffff',
							'background-image'      => '',
							'background-repeat'     => 'no-repeat',
							'background-attachment' => '',
							'background-position'	=> 'center center',
							'background-size'		=> 'cover'
						)
					),
				)
			);

			// 404  Setting
			$this->sections[] = array(
				'title'     => esc_html__( '404 Setting', 'buildplus' ),
				'icon'      => 'el-icon-info-circle',
				'desc'      => esc_html__( 'This page will display options for 404 page', 'buildplus' ),
				'fields'    => array(
					array(
						'id'        => 'slz-404-illustration-image',
						'type'      => 'media',
						'title'     => esc_html__( 'Illustration image ', 'buildplus' ),
					),
					array(
						'id'        => 'slz-404-title',
						'type'      => 'text',
						'title'     => esc_html__( 'Main Title', 'buildplus' ),
						'default'   => esc_html__( 'Page not found', 'buildplus' ),
					),
					array(
						'id'        => 'slz-404-desc',
						'type'      => 'editor',
						'title'     => esc_html__( 'Description', 'buildplus' ),
						'default'   => esc_html__( 'Please go back to home and try to find out once again.', 'buildplus' ),
					),
					array(
						'id'        => 'slz-404-backhome',
						'type'      => 'text',
						'title'     => esc_html__( 'Back to home text', 'buildplus' ),
						'default'   => esc_html__( 'Go Home', 'buildplus' ),
					),
					array(
						'id'        => 'slz-404-button-02',
						'type'      => 'text',
						'title'     => esc_html__( 'Button 02 text', 'buildplus' ),
						'default'   => esc_html__( 'Get Help', 'buildplus' ),
					),
					array(
						'id'        => 'slz-404-button-02-link-custom',
						'type'      => 'text',
						'title'     => esc_html__( 'Button 02 Link(Custom)', 'buildplus'),
						'subtitle'  => esc_html__( 'Empty this field if you want to choose link to page', 'buildplus' ),
					),
					array(
						'id'        => 'slz-404-button-02-link',
						'type'      => 'select',
						'data'      => 'pages',
						'title'     => esc_html__( 'Button 02 Link(Link To Page)', 'buildplus' ),
						'default'   => '1'
					)
				)
			);

			// Custom CSS
			$this->sections[] = array(
				'title'     => esc_html__( 'Custom Style', 'buildplus' ),
				'icon'      => 'el-icon-css',
				'desc'      => esc_html__( 'Customize your site by code', 'buildplus' ),
				'fields'    => array(
					array(
						'id'       => 'slz-custom-css',
						'type'     => 'ace_editor',
						'title'    => esc_html__( 'CSS Code', 'buildplus' ),
						'subtitle' => esc_html__( 'Paste your CSS code here.', 'buildplus' ),
						'mode'     => 'css',
						'theme'    => 'monokai',
						'default'  => "body{\n   margin: 0 auto;\n}"
					)
				)
			);

			// Custom js
			$this->sections[] = array(
				'title'     => esc_html__( 'Custom Script', 'buildplus' ),
				'icon'      => 'el-icon-link',
				'desc'      => esc_html__( 'Customize your site by code', 'buildplus' ),
				'fields'    => array(
					array(
						'id'       => 'slz-custom-js',
						'type'     => 'ace_editor',
						'title'    => esc_html__( 'JS Code', 'buildplus' ),
						'subtitle' => esc_html__( 'Paste your JS code here.', 'buildplus' ),
						'mode'     => 'javascript',
						'theme'    => 'chrome',
						'default'  => "jQuery(document).ready(function(){\n\n});"
					),
				)
			);

			// Typography
			$this->sections[] = array(
				'title'     => esc_html__( 'Typography', 'buildplus' ),
				'icon'      => 'el-icon-text-height',
				'desc'      => esc_html__( 'Customize your site by code', 'buildplus' ),
				'fields'    => array(
					array(
						'id'        => 'slz-typo-body',
						'type'      => 'typography',
						'title'     => esc_html__( 'Body text', 'buildplus' ),
						'subtitle'  => esc_html__( 'Set font ', 'buildplus' ),
						'google'    => true,
						'default'   => false
					),
					array(
						'id'        => 'slz-typo-p',
						'type'      => 'typography',
						'title'     => esc_html__( 'Paragraph text', 'buildplus' ),
						'google'    => true,
						'default'   => false
					),
					array(
						'id'       => 'slz-link-color',
						'type'     => 'link_color',
						'title'    => esc_html__( 'Links Color Option', 'buildplus' ),
						'subtitle' => esc_html__( 'Only color validation can be done on this field type', 'buildplus' ),
						'default'  => array(
							'regular' => '#3a4d6a',
							'hover'   => '#ffb400',
							'active'  => '#ffb400',
						)
					),
					array(
						'id'        => 'slz-typo-h1',
						'type'      => 'typography',
						'title'     => esc_html__( 'H1 text', 'buildplus' ),
						'google'    => true,
						'default'   => false
					),
					array(
						'id'        => 'slz-typo-h2',
						'type'      => 'typography',
						'title'     => esc_html__( 'H2 text', 'buildplus' ),
						'google'    => true,
						'default'   => false
					),
					array(
						'id'        => 'slz-typo-h3',
						'type'      => 'typography',
						'title'     => esc_html__( 'H3 text', 'buildplus' ),
						'google'    => true,
						'default'   => false
					),
					array(
						'id'        => 'slz-typo-h4',
						'type'      => 'typography',
						'title'     => esc_html__( 'H4 text', 'buildplus' ),
						'google'    => true,
						'default'   => false
					),
					array(
						'id'        => 'slz-typo-h5',
						'type'      => 'typography',
						'title'     => esc_html__( 'H5 text', 'buildplus' ),
						'google'    => true,
						'default'   => false
					),
					array(
						'id'        => 'slz-typo-h6',
						'type'      => 'typography',
						'title'     => esc_html__( 'H6 text', 'buildplus' ),
						'google'    => true,
						'default'   => false
					)
				)
			);

		}

		public function setHelpTabs() {

			// Custom page help tabs, displayed using the help API. Tabs are shown in order of definition.
			$this->args['help_tabs'][] = array(
				'id'        => 'redux-help-tab-1',
				'title'     => esc_html__('Theme Information 1', 'buildplus'),
				'content'   => sprintf('<p>%s</p>', esc_html__('This is the tab content, HTML is allowed.', 'buildplus'))
			);

			$this->args['help_tabs'][] = array(
				'id'        => 'redux-help-tab-2',
				'title'     => esc_html__('Theme Information 2', 'buildplus'),
				'content'   => sprintf('<p>%s</p>', esc_html__('This is the tab content, HTML is allowed.', 'buildplus'))
			);

			// Set the help sidebar
			$this->args['help_sidebar'] = sprintf('<p>%s</p>', esc_html__('This is the sidebar content, HTML is allowed.', 'buildplus'));
		}

		/*
	      All the possible arguments for Redux.
	      For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments
		*/

		public function setArguments() {

			$theme = wp_get_theme(); // For use with some settings. Not necessary.

			$this->args = array(
				'opt_name'              => 'buildplus_options',
				'dev_mode'              => false, // disable dev mode when release
				'use_cdn'               => false,
				'global_variable'       => 'buildplus_options',
				'display_name'          => esc_html__( 'Buildplus', 'buildplus' ),
				'display_version'       => false,
				'page_slug'             => 'BuildPlus_options',
				'page_title'            => esc_html__( 'BuildPlus Option Panel', 'buildplus' ),
				'update_notice'         => false,
				'menu_type'             => 'menu',
				'menu_title'            => esc_html__( 'Theme Options', 'buildplus' ),
				'menu_icon'             => ReduxFramework::$_url.'assets/img/menu-icon.png',
				'allow_sub_menu'        => true,
				'page_priority'         => '31',
				'page_parent'           => 'buildplus_welcome',
				'customizer'            => true,
				'default_mark'          => '*',
				'class'                 => 'sw_theme_options_panel',
				'hints'                 => array(
					'icon'          => 'el-icon-question-sign',
					'icon_position' => 'right',
					'icon_size'     => 'normal',
					'tip_style'     => array(
						'color' => 'light',
					),
					'tip_position' => array(
						'my' => 'top left',
						'at' => 'bottom right',
					),
					'tip_effect' => array(
						'show' => array(
							'duration' => '500',
							'event'    => 'mouseover',
						),
						'hide' => array(
							'duration' => '500',
							'event'    => 'mouseleave unfocus',
						),
					),
				),
				'intro_text'         => '',
				'footer_text'        => '<p>'. esc_html__( 'Thank you for purchased BuildPlus!', 'buildplus' ).'</p>',
				'page_icon'          => 'icon-themes',
				'page_permissions'   => 'manage_options',
				'save_defaults'      => true,
				'show_import_export' => true,
				'database'           => 'options',
				'transient_time'     => '3600',
				'network_sites'      => true,
			);

			$this->args['share_icons'][] = array(
				'url'   => esc_url('https://www.facebook.com/swlabs/'),
				'title' => esc_html__( 'Like us on Facebook', 'buildplus' ),
				'icon'  => esc_attr('el-icon-facebook')
			);
			$this->args['share_icons'][] = array(
				'url'   => esc_url('http://themeforest.net/user/swlabs'),
				'title' => esc_html__( 'Follow us on themeforest', 'buildplus' ),
				'icon'  => esc_attr('el-icon-user')
			);
			$this->args['share_icons'][] = array(
				'url'   => esc_attr('mailto:admin@swlabs.co'),
				'title' => esc_html__( 'Send us email', 'buildplus' ),
				'icon'  => esc_attr('el-icon-envelope')
			);
		}

	}

	global $buildplus_reduxConfig;
	$buildplus_reduxConfig = new Buildplus_Redux_Framework_Config();
}
/*
  Custom function for the callback validation referenced above
*/
if (!function_exists('buildplus_validate_callback_function')):
	function buildplus_validate_callback_function($field, $value, $existing_value) {
		$error = false;
		$value = 'just testing';

		$return['value'] = $value;
		if ($error == true) {
			$return['error'] = $field;
		}
		return $return;
	}
endif;