<?php
/**
 * Header Content
 */
$post_id = get_the_ID();
$template = Buildplus::get_option( 'slz-header-layout' );
$show_header = Buildplus::get_option('slz-header-hide');
$show_laguage_switcher = Buildplus::get_option('slz-language-switcher');

if ( $show_header != '1' ) {
	$page_option  = get_post_meta( $post_id, 'buildplus_page_options', true );
	$header_logo_url = Buildplus::get_value($page_option , 'header_logo');
	if(empty($header_logo_url)){
		$header_logo_url  = Buildplus::get_option( 'slz-logo-header', 'url' );
	}
	if(is_numeric($header_logo_url)){
		$header_logo_url = wp_get_attachment_url($header_logo_url);
	}
	$show_search  =  Buildplus::get_option('slz-header-search-icon');
	if( empty($header_logo_url) ) {
		$header_logo_data = '<span>' .get_bloginfo( 'name', 'display' ) . '</span>';
	} else {
		$header_logo_data = '<img src="'. esc_url($header_logo_url).'" alt="" class="logo">';
	}
	$key_lr  = array('left','right');
	foreach ($key_lr as $name ) {
		$content[$name] = '';
		$topbar[$name] = Buildplus::get_option('slz-topbar-'.$name.'-content');

		if( $topbar[$name] ) {
			foreach ($topbar[$name]['enabled'] as $k => $v) {
				switch ($k) {
					case 'contact-info':
						$info_html = '';
						$info = Buildplus::get_option('slz-topbar-'.$name.'-contact');
						if ( !empty($info) ) {
							foreach ($info as $value) {
								$parse_json = json_decode($value);
								if (is_array($parse_json) && isset($parse_json[1])){
									$content[$name]  .= 
									'<div class="item">
										<i class="topbar-icons fa '.esc_attr($parse_json[0]).'"></i>
										<div class="topbar-text">'.wp_kses_post($parse_json[1]);
										if( $template == 'four' ){
											if(isset($parse_json[2])){
												$content[$name]  .= '<p class="topbar-description">'.wp_kses_post($parse_json[2]).'</p>';
											}

										}
									$content[$name]  .= '</div></div>';
								}
							}
						}
						break;
					case 'social':
						$social_map = Buildplus_Params::get('header-social');
						$header_social_active = Buildplus::get_option('slz-topbar-'.$name.'-social');
						if( $header_social_active ) {
							$header_social = '';
							foreach ($header_social_active['enabled'] as $key => $value) {
								$social_key = Buildplus::get_option('slz-social-' . $key);
								if( !empty( $social_key ) && isset( $social_map[$key] ) ) {
									$header_social .= '<a href="'. esc_url($social_key) .'" class="social-item '.esc_attr($key).'" target="_blank"><i class="icons fa ' . esc_attr($social_map[$key]) . '"></i></a>';
								}
							}
							$content[$name] .= '<div class="item list-social" >' . $header_social . '</div>';
						}
						break;
					case 'text':
						$text =  Buildplus::get_option('slz-topbar-'.$name.'-text');
						if( $text  ){
							$content[$name] .= '<div class="item"><p class="topbar-text">'.wp_kses_post($text ).'</p></div>';
						}
						
					break;
					
					default:
						break;
				}
			}
			
		}
	}

	/************************* Layout **************************/
	
	$layouts = array('one','two','three','four','five');
	if( ! in_array( $template , $layouts)) {
		$template = 'three';
	}

	include locate_template('inc/header/header-' . $template . '.php');
}

