<?php
/**
 * Widget_About_Us class.
 * 
 * @since 1.0
 */

class Buildplus_Widget_About_Us extends WP_Widget {

	public function __construct() {
		$widget_ops = array(
			'classname'   => 'widget_about_us',
			'description' => esc_html__( "The about us information.", 'buildplus')
		);
		parent::__construct( 'buildplus_about_us', esc_html_x( 'SLZ: About us', 'About us widget', 'buildplus' ), $widget_ops );
	}

	function form( $instance ) {
		$default = array(
			'title'       => esc_html__( "About us", 'buildplus'),
			'description' => ''
		);
		$social_default = array();
		$arr_social     = Buildplus_Params::get('social-icons');
		foreach($arr_social as $k => $v){
			$social_default[$k] = '';
		}
		$instance    = wp_parse_args( (array) $instance, $social_default );
		$instance    = wp_parse_args( (array) $instance, $default );
		$title       = $instance['title'];
		$description = $instance['description'];
		?>
		<p>
			<label for="<?php echo  esc_attr( $this->get_field_id('title') ); ?>"><?php esc_html_e('Title', 'buildplus');?></label>
			<input class="widefat" type="text" id="<?php echo esc_attr( $this->get_field_id('title') ); ?>" name="<?php echo esc_attr( $this->get_field_name('title') ); ?>" value="<?php echo esc_attr( $title ); ?>" />
		</p>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id('description') ); ?>"><?php esc_html_e('Description', 'buildplus');?></label>
			<textarea class="widefat" rows="5" id="<?php echo esc_attr( $this->get_field_id('description') ); ?>" name="<?php echo esc_attr( $this->get_field_name('description') ); ?>" ><?php echo esc_textarea( $description ); ?></textarea>
		</p>
		<?php
		foreach( $social_default as $k => $v ){
			printf('<p><label for="%1$s">%2$s<input type="text" class="widefat" id="%1$s" name="%3$s" value="%4$s" /></label></p>',
				esc_attr( $this->get_field_id($k) ),
				esc_attr( ucfirst( str_replace('-', ' ', $k ) ) ),
				esc_attr( $this->get_field_name($k) ),
				esc_attr($instance[$k])
			);
		}
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title']       = strip_tags( $new_instance['title'] );
		$instance['description'] = $new_instance['description'];
		$arr_social        = Buildplus_Params::get('social-icons');
		foreach( $arr_social as $k => $v ){
			$instance[$k] = $new_instance[$k];
		}
		return $instance;
	}

	function widget( $args, $instance ) {
		extract( $args );
		$default = array(
			'title'       => '',
			'description' => ''
		);
		$instance = wp_parse_args( (array) $instance, $default );
		$title    = apply_filters( 'widget_title', $instance['title'] );
		$description = $instance['description'];
		$arr_social  = Buildplus_Params::get('social-icons');
		echo wp_kses_post($before_widget); ?>
		<div class="widget about-us-widget"><?php
			if( !empty( $title ) ) {
				echo wp_kses_post( $before_title );
				echo esc_html( $title );
				echo wp_kses_post( $after_title );
			}?>
			<div class="about-us-inner"><?php
				if(!empty($description)){?>
					<div class="text"><?php echo wp_kses_post(nl2br($description)); ?></div><?php
				} ?>
				<div class="list-social"><?php
					foreach( $arr_social as $k => $v ){
						if( !empty( $instance[$k] ) ){
							printf('<div class="item"><a href="%1$s" class="link" target="_blank"><i class="icons fa %3$s"></i></a></div>',
							esc_url( $instance[$k] ),
							esc_attr($k),
							esc_attr($v)
							);
						}
					} ?>
				</div>
			</div>
		</div><?php
		echo wp_kses_post($after_widget);
	}
}