<?php
/**
 * Widget_Contact class.
 * 
 * @since 1.0
 */

class Buildplus_Widget_Contact extends WP_Widget {

	public function __construct() {
		$widget_ops = array(
			'classname' => 'widget_contact',
			'description' => esc_html__( "The contact information.", 'buildplus')
		);
		parent::__construct( 'buildplus_contact', esc_html_x( 'SLZ: Contact', 'Contact widget', 'buildplus' ), $widget_ops );
	}

	function form( $instance ) {
		$default = array(
			'title'    => esc_html__( "Contact us", 'buildplus'),
			'address'  => '',
			'phone'    => '',
			'mail'     => '',
		);
		$instance = wp_parse_args( (array) $instance, $default );
		$title    = $instance['title'];
		$address  = $instance['address'];
		$phone    = $instance['phone'];
		$mail     = $instance['mail'];
		?>
		<p>
			<label for="<?php echo  esc_attr( $this->get_field_id('title') ); ?>"><?php esc_html_e('Title', 'buildplus');?></label>
			<input class="widefat" type="text" id="<?php echo esc_attr( $this->get_field_id('title') ); ?>" name="<?php echo esc_attr( $this->get_field_name('title') ); ?>" value="<?php echo esc_attr( $title ); ?>" />
		</p>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id('address') ); ?>"><?php esc_html_e('Address', 'buildplus');?></label>
			<textarea class="widefat" rows="2" id="<?php echo esc_attr( $this->get_field_id('address') ); ?>" name="<?php echo esc_attr( $this->get_field_name('address') ); ?>" ><?php echo esc_textarea( $address ); ?></textarea>
		</p>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id('phone') ); ?>"><?php esc_html_e('Phone', 'buildplus');?></label>
			<textarea class="widefat" rows="1" id="<?php  echo esc_attr( $this->get_field_id('phone') ); ?>" name="<?php echo esc_attr( $this->get_field_name('phone') ); ?>" ><?php echo esc_textarea( $phone ); ?></textarea>
		</p>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id('mail') ); ?>"><?php esc_html_e('Email', 'buildplus');?></label>
			<textarea class="widefat" rows="1" id="<?php echo esc_attr( $this->get_field_id('mail') ); ?>" name="<?php echo esc_attr( $this->get_field_name('mail') ); ?>" ><?php echo esc_textarea( $mail ); ?></textarea>
		</p>
		<?php
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title']   = strip_tags( $new_instance['title'] );
		$instance['address'] = $new_instance['address'];
		$instance['phone']   = strip_tags( $new_instance['phone'] );
		$instance['mail']    = strip_tags( $new_instance['mail'] );
		return $instance;
	}

	function widget( $args, $instance ) {
		extract( $args );
		$default = array(
			'title'   => '',
			'address' => '',
			'phone'   => '',
			'mail'    => '',
		);
		$instance = wp_parse_args( (array) $instance, $default );
		$title    = apply_filters( 'widget_title', $instance['title'] );
		$address  = $instance['address'];
		$phone    = $instance['phone'];
		$email    = $instance['mail'];
		$custom_css  = '';
		$id      = Buildplus::make_id();
		$uniq_id = 'widget-contact-'.esc_attr($id);
		echo wp_kses_post($before_widget);?>
		<div class="widget contact-us-now-widget wg-contact <?php echo esc_attr($uniq_id);  ?>">
			<?php 
				if( !empty( $title ) ) {
					echo wp_kses_post( $before_title );
					echo esc_html( $title );
					echo wp_kses_post( $after_title );
				}
			?>
			<div class="list-contact"><?php 
				if(!empty($address)){ ?>
					<div class="contact-info-box">
						<div class="contact-info-cell">
							<div class="wrapper-icons"><i class="icons fa fa-map-marker"></i></div>
						</div>
						<div class="contact-info-cell">
							<div class="wrapper-info">
								<div class="text"><?php echo wp_kses_post(nl2br($address)); ?></div>
							</div>
						</div>
					</div><?php 
 				}
				if(!empty($phone)){ ?>
					<div class="contact-info-box">
						<div class="contact-info-cell">
							<div class="wrapper-icons"><i class="icons fa fa-phone"></i></div>
						</div>
						<div class="contact-info-cell">
							<div class="wrapper-info">
								<div class="text phone"><?php echo esc_html_e('Hotline: ', 'buildplus' );
									$arr_phone = preg_split('/\s([^\d+]+)/', $phone);
									$count     = count($arr_phone);
									if($count > 1){
										$custom_css .= '.%1$s .contact-info-box .wrapper-info .text.phone .text-bold{display:block;}' ."\n";
									}
									foreach ($arr_phone as $key => $val) { 
										$phoneRe = str_replace(' ', '', $val);?>
										<a href="tel:<?php echo esc_attr($phoneRe); ?>" class="text-bold"><?php echo nl2br(esc_textarea($val)); ?></a><?php
									}?>
								</div>
							</div>
						</div>
					</div><?php
				}
				if( !empty( $email ) ){?>
					<div class="contact-info-box">
						<div class="contact-info-cell">
							<div class="wrapper-icons"><i class="icons fa fa-envelope"></i></div>
						</div>
						<div class="contact-info-cell">
							<div class="wrapper-info"><?php  
								$arr_email  = preg_split ( '/$\R?^/m', $email );
								$count_mail = count($arr_email);
								if($count_mail > 1){
									$custom_css .= '.%1$s .contact-info-box .wrapper-info .text{display:block;}' ."\n";
								}
								foreach($arr_email as $value){ ?>
									<a href="mailto:<?php echo esc_attr($value); ?>" class="text"><?php echo nl2br( esc_textarea( $value ) ); ?></a><?php
								}?>
							</div>
						</div>
					</div><?php
				}?>
			</div>
		</div><?php
		echo wp_kses_post($after_widget);
		//custom_css
		if ( !empty( $custom_css ) ) {
			$custom_css = sprintf($custom_css, $uniq_id);
			do_action( 'buildplus_add_inline_style', $custom_css );
		}
	}
}