<?php
/**
 * Widget_Recent_Post class.
 * 
 * @since 1.0
 */
Buildplus::load_class( 'front.Blog' );
class Buildplus_Widget_Recent_Post extends WP_Widget {

	public function __construct() {
		$widget_ops = array( 'classname' => 'widget_slz_recent_post', 'description' => esc_html__( "A recent posts list.", 'buildplus') );
		parent::__construct( 'buildplus_recent_post', esc_html_x( 'SLZ: Recent Posts', 'Recent posts widget', 'buildplus' ), $widget_ops );
	}
	function form( $instance ) {
		$default = array(
			'style'           => '',
			'title'           => esc_html__( "Recent Post", 'buildplus'),
			'limit_post'      => '5',
			'sort_by'         => '',
			'show_thumbnail'  => 'on',
			'show_date'       => 'on',
			'show_author'     => 'on',
			'show_comments'   => '',
			'show_views'      => '',
		);
		$check_box = array(
			'show_thumbnail' => esc_html__( 'Display thumbnail', 'buildplus' ),
			'show_date'      => esc_html__( 'Display post date', 'buildplus' ),
			'show_author'    => esc_html__( 'Display author', 'buildplus' ),
			'show_comments'  => esc_html__( 'Display comment counts', 'buildplus' ),
			'show_views'     => esc_html__( 'Display view counts', 'buildplus' ),
		);
		$instance = wp_parse_args( (array) $instance, $default );
		$sort_arr   = Buildplus_Params::get('sort_blog');
		$title      = $instance['title'];
		$limit_post = $instance['limit_post'];
		$style      = $instance['style'];
		$sort_by    = $instance['sort_by'];
		?>
		<p>
			<label for="<?php echo  esc_attr( $this->get_field_id('style') ); ?>"><?php esc_html_e('Choose Style', 'buildplus');?></label>
			<select class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'style' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name('style') ); ?>" >
				<option value="1"<?php if( $style == 1 ) { echo " selected"; } ?>><?php esc_html_e('Style 1', 'buildplus');?></option>
				<option value="2"<?php if( $style == 2 ) { echo " selected"; } ?>><?php esc_html_e('Style 2', 'buildplus');?></option>
				<option value="3"<?php if( $style == 3 ) { echo " selected"; } ?>><?php esc_html_e('Style 3', 'buildplus');?></option>
			</select>
		</p>
		<p>
			<label for="<?php echo  esc_attr( $this->get_field_id('title') ); ?>"><?php esc_html_e( 'Title', 'buildplus' );?></label>
			<input class="widefat" type="text" id="<?php echo esc_attr( $this->get_field_id('title') ); ?>" name="<?php echo esc_attr( $this->get_field_name('title') ); ?>" value="<?php echo esc_attr( $title ); ?>" />
		</p>
		<p>
			<label for="<?php echo  esc_attr( $this->get_field_id('limit_post') ); ?>"><?php esc_html_e( 'Number Post', 'buildplus' );?></label>
			<input class="widefat" type="text" id="<?php echo esc_attr( $this->get_field_id('limit_post') ); ?>" name="<?php echo esc_attr( $this->get_field_name('limit_post') ); ?>" value="<?php echo esc_attr( $limit_post ); ?>" />
		</p>
		<p>
			<label for="<?php echo  esc_attr( $this->get_field_id('sort_by') ); ?>"><?php esc_html_e( 'Sort By', 'buildplus' );?></label>
			<select class="widefat" id="<?php echo esc_attr( $this->get_field_id('sort_by') ); ?>" name="<?php echo esc_attr( $this->get_field_name('sort_by') ); ?>" >
				<?php foreach( $sort_arr  as $k => $v ){?>
					<option value="<?php echo esc_attr($v); ?>"<?php if( $sort_by == $v ) echo " selected"; ?>><?php echo esc_html($k); ?></option>
				<?php } ?>
			</select>
		</p>
		<?php
			$format = '
				<p>
					<input class="checkbox" type="checkbox" %1$s id="%2$s" name="%3$s" />
					<label for="%4$s">%5$s</label>
				</p>';
			foreach( $check_box as $field => $text ) {
				printf( $format,
						checked($instance[$field], 'on', false ),
						esc_attr( $this->get_field_id($field) ),
						esc_attr( $this->get_field_name($field) ),
						esc_attr( $this->get_field_id($field) ),
						$text
					);
			}
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$params = array(
				'style',
				'title',
				'limit_post',
				'sort_by',
				'show_thumbnail',
				'show_date',
				'show_author',
				'show_comments',
				'show_views',
			);
		foreach( $params as $item ) {
			$instance[$item] = strip_tags( $new_instance[$item] );
		}
		return $instance;
	}

	function widget($args, $instance) {
	
		$default = array(
			'style'           => '',
			'title'           => '',
			'limit_post'      => '',
			'sort_by'         => '',
			'show_date'       => '',
			'show_thumbnail'  => '',
			'show_author'     => '',
			'show_comments'   => '',
			'show_views'      => '',
		);
		$check_box = array(
			'show_date'      => '',
			'show_thumbnail' => '',
			'show_author'    => '',
			'show_comments'  => '',
			'show_views'     => '',
		);
		$instance = wp_parse_args( (array) $instance, $default );
		$title    = apply_filters('widget_title', $instance['title']);
		extract( $args );
		extract( $instance );
		$atts = $instance;
		foreach( $check_box as $k => $v ) {
			if( isset($atts[$k]) && $atts[$k] != 'on'){
				$atts[$k] = 'hide';
			}
			if( isset($atts[$k]) && $atts[$k] == 'on') {
				$atts[$k] = '';
			}
		}
		$id    = Buildplus::make_id();
		$model = new Buildplus_Blog();
		$model->init( $atts);
		$show_thumbnail = $show_meta = $cls = '';
		// $1- image, $2- title, $3- meta, $4 - post class
		if( $atts['show_thumbnail'] != 'hide' ) {
			$show_thumbnail = '<div class="media-left">%1$s</div>';
		}
		$meta_icon = '';
		$html_options = array();
		switch($style){
			case '2':
				$meta_icon = '<i class="icons fa fa-bookmark"></i>';
				$left = '%3$s' . $show_thumbnail;
				$right = '<div class="media-right">%2$s</div>';
				$cls = 'style-2';
				break;
			case '3':
				$cls = 'style-3';
				$left = $show_thumbnail;
				$right = '<div class="media-right">%2$s %3$s</div>'; //title, meta
				$html_options['view_format']    = '<div class="meta-info"><span class="link">%1$s</span></div>';
				$html_options['comment_format'] = '<div class="meta-info"><a href="%1$s" class="link">%1$s</a></div>';
				break;
			default:
				$left = $show_thumbnail;
				$right = '<div class="media-right">%3$s %2$s</div>'; //meta, title
		}
		$html_format = '<div class="media '.esc_attr($cls).' %4$s">
							'.$left.$right.'
						</div>';
		echo wp_kses_post( $before_widget );?>
		<div class="widget recent-post-widget wg-recent-post-<?php echo esc_attr( $id );?>">
			<?php
				if( !empty( $title ) ){
					echo wp_kses_post( $before_title );
					echo esc_attr( $title );
					echo wp_kses_post( $after_title );
				}
				if ( $model->query->have_posts() ) :?>
					<div class="recent-post-inner"> 
						<?php
							$post_options = array(
								'small_post_format' => $html_format,
								'thumb_href_class'  => 'wrapper-image',
								'thumb_class'       => 'media-object',
								'meta_icon'         => $meta_icon,
							);
							$post_options = $model->set_widget_options( $post_options );
							$html_options = array_merge( $post_options, $html_options );
							$model->render_widget( $html_options );
						?>
					</div>
				<?php
				endif;
			?>
		</div>
		<?php 
		echo wp_kses_post( $after_widget );
	}
}