<?php
// css to show/hide sidebar.
$buildplus_container_css = buildplus_get_container_css();
// attachment
$attachments    = get_post_meta(get_the_ID(), 'buildplus_project_attachment_ids', true);
$attach         = Buildplus_Core_Util::get_single_attachments($attachments);
get_header();
?>
<div class="content-session project-detail padding-top-100 padding-bottom-100">
	<div class="<?php echo esc_attr( $buildplus_container_css['container_css'] ); ?>">
		<div class="row">
			<div class="col-md-12">
			<?php do_action('buildplus_core_project_title');?>
			</div>
			<div id="page-content" class="main-detail <?php echo esc_attr( $buildplus_container_css['content_css'] ); ?>">
				<?php if ( have_posts() ) :
						while ( have_posts() ) :
							the_post();
						?>
							<div <?php post_class(); ?> >
								<div class="project-content">
									<!-- gallery -->
									<?php do_action( 'buildplus_core_project_gallery', $buildplus_container_css );?>
									<!-- content -->
									<div class="detail-content entry-content">
									<?php
										the_content( sprintf( '<a href="%s" class="read-more">%s<i class="fa fa-angle-right"></i></a>',
												esc_url(get_permalink()),
												esc_html__( 'Read more', 'buildplus' )
										) );
										wp_link_pages( array( 'before' => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'buildplus' ) . '</span>', 'after' => '</div>', 'link_before' => '<span>', 'link_after' => '</span>' ) );
									?>
									</div>
									<?php if(!empty($attach)){?>
										<div class="detail-content attach-single-detail style-attach list-download">
											<h4 class="title"><?php esc_html_e( 'Attachments', 'buildplus' ) ?></h4>
											<?php printf( '%s', $attach); ?>
										</div>
									<?php }?>
								</div>
							</div>
							
							<?php
						endwhile;
					else:
						get_template_part( 'inc/content', 'none' );
					endif;
				?>
			</div><!-- #page-content -->
			<?php if ( $buildplus_container_css['has_sidebar'] != 'none' ) :?>
				<div id='page-sidebar' class="sidebar <?php echo esc_attr( $buildplus_container_css['sidebar_css'] )?>">
					<?php buildplus_get_sidebar($buildplus_container_css['sidebar_id']);?>
				</div>
			<?php endif;?>
		</div>
	</div>
</div>
<?php do_action('buildplus_core_project_related');?>
<?php get_footer(); ?>