<?php
/**
 * The template for displaying all single posts.
 * 
 * @author Swlabs
 * @package BuildPlus
 * @since 1.0
 */
$buildplus_post_type = get_post_type();
$buildplus_params = array('buildplus_project', 'buildplus_service', 'buildplus_team');
if(in_array( $buildplus_post_type, $buildplus_params ) && BUILDPLUS_CORE_IS_ACTIVE ){
	$buildplus_post_type = str_replace('buildplus_', '', $buildplus_post_type);
	get_template_part( 'inc/single', $buildplus_post_type );
	return;
}
// css to show/hide sidebar.
$buildplus_container_css = buildplus_get_container_css();

/**
 * Start Template
 */
get_header();
?>
<div class="content-session blog-detail padding-top-100 padding-bottom-100">
	<div class="<?php echo esc_attr( $buildplus_container_css['container_css'] ); ?>">
		<div class="blog-detail-wrapper row">
			<div id="page-content" class="blog-content <?php echo esc_attr( $buildplus_container_css['content_css'] ); ?>">
				<div class=" blog-detail-wrapper">
					<?php if ( have_posts() ) : ?>
						
						<?php /* The loop */ ?>
						<?php while ( have_posts() ) : the_post(); ?>
							<?php get_template_part( 'inc/single' ); ?>
						<?php endwhile; ?>
						<?php
						if ( is_single() && ( comments_open() || get_comments_number() ) ) :
							echo '<div class="entry-comment comments clearfix blog-comment">';
							comments_template();
							echo '</div>';
						endif;
						?>
						
						<div class="clear-fix" ></div>
					<?php else : ?>
						<?php get_template_part( 'inc/content', 'none' ); ?>
					<?php endif; // have_posts?>
				</div>
			</div><!-- #page-content -->
			<?php if ( $buildplus_container_css['has_sidebar'] != 'none' ) :?>
			<div id='page-sidebar' class="sidebar <?php echo esc_attr( $buildplus_container_css['sidebar_css'] )?>">
				<?php buildplus_get_sidebar($buildplus_container_css['sidebar_id']);?>
			</div>
			<?php endif;?>
		</div>
	</div>
</div>
<?php get_footer(); ?>