<?php include 'header.php'; ?>

<main id="main">
    <section class="page-section bg-dark-1  light-content bg-scroll pb-0 mb-100 mb-md-70 mb-sm-50 z-index-1 pt-sm-120" style="background-image: url(images/full-width-images/inner-bg.jpg)">
        <div class="container position-relative">                    
            <div class="row">
                <div class="col-md-10 offset-md-1 col-lg-8 offset-lg-2 text-center">
                    <h2 class="section-caption-border mb-30 mb-xs-20 wow fadeInUp animated" data-wow-duration="1.2s" style="visibility: visible; animation-duration: 1.2s; animation-name: fadeInUp;">
                        NEWS
                    </h2>
                    <h3 class="section-title mb-60 mb-sm-40"><span class="wow charsAnimIn" data-splitting="chars">
                        Staying Alert is the Cornerstone of Personal Safety
                    </span></h3>
                </div>
            </div>
        </div>
    </section>
    <section class="page-section bg-dark-1  light-content bg-scroll pb-0 mb-100 mb-md-70 z-index-1 pt-0">
        <div class="container position-relative">
            <div class="news-text">
                <p class="mb-60 text-gray peragraph-text">
                    By Tim Miller, Founder and President of LionHeart International Services Group<br/><br/>
                    Stay Alert, Stay Alive!  As a young Marine officer, this mantra was drilled into my mind by experienced Gunnery Sergeants from day one. While many people recognize the dangers of combat, they may not understand that even the most routine day to day operations of the military are full of potential threats. Rumbling tracked vehicles, spinning helicopter rotors and cranes loading heavy cargo containers are just a few of the daily hazards encountered by our armed forces. Simple things like igniting a field heater or just pounding a tent stake into the ground come with risks. Marines understand that seemingly mundane tasks are full of inherent risks and that staying alert is the key to survival. As each day brings new reports of random crime and targeted violence, it's more important than ever to apply this same mindset as we go about our daily routines at home, school and work.
                </p>
                <h4>Put Down Your Phone</h4>
                <p class="mb-60 text-gray peragraph-text">
                    This isn't to shame anybody's screen time or go on about the virtues of a phone-free dinner conversation. It's simply a fact that when you are focused on your smart phone, you aren't alert to your surroundings. So many of us go through the day with our heads buried in a smart phone that we rarely look up to even notice the people around us.  Before you start firing off emails while walking down the street or posing for a selfie in front of that cool mural, take a moment to scan the space around you.  Even better, if you are touring a new town with a friend, ask them to keep an eye out while you search for directions or make that online dinner reservation. 
                </p>
                <h4>Look at People</h4>
                <p class="mb-60 text-gray peragraph-text">
                    Many of us were taught to greet people by looking them in the eye and extending a firm handshake.  The same concept holds true in staying alert to your surroundings.  Make eye contact with people and acknowledge that you see them. Police agencies have long advocated "great customer service" as a deterrent to bank robbers who don't wish to be seen or remembered.  The same holds true for many would-be criminals that wish to anonymously target you for a robbery or worse.  Remember that criminals look for "easy targets" so don't be that person; stay alert and engaged with your surroundings.
                </p>
                <h4>Know the Routines – and Notice the Changes</h4>
                <p class="mb-60 text-gray peragraph-text">
                    Whether it's our neighborhoods, schools or workplaces, take a moment each day to take note of the routines around us.  Services deliveries and trash removal usually occur at a similar time and consistent entrances / exits. Your colleagues, neighbors or classmates will typically park their vehicles and arrive or depart at similar times each day. Observing the everyday routines around you will make you more alert to any changes as they occur. 
                </p>
                <h4>Take Note of Clothing and Accessories</h4>
                <p class="mb-60 text-gray peragraph-text">
                    The coffee shops and stores that we frequent will typically have customers that dress consistent with the location, weather and type of business nearby– be it a warehouse district, downtown financial center or even just a touristy part of town. Bookbags and briefcases can be very common near school campuses or corporate work spaces, but large backpacks might be out of place. Sunglasses on bright day can be very common on a busy street, but less common inside an enclosed shopping mall. Be alert to things that don't seem to quite fit in to the environment and ask yourself the question "does this make sense?"  Once unusual behavior is identified, observe carefully and begin to focus on a basic plan should things go wrong. Remember that being alert may not just save you but your family and others around you as well. 
                </p>
                <h4>Being Alert Makes the Difference</h4>
                <p class="mb-60 text-gray peragraph-text">
                    Being alert to your surroundings is the cornerstone of personal safety. Whenever a threatening situation develops, being alert will enhance your ability to quickly assess the threat and respond to it.  Being alert and prepared will make the difference between being a victim and returning home safely. The good news is that training our minds to be alert can start today.  Whether stepping into a commercial office, concert venue or even just a local shopping center, our awareness of the people and structures around us will make a life saving difference in a violent situation.  <br/><br/>
                    Tim Miller is a 30-year law enforcement and military professional. As a Secret Service Special Agent assigned to the Washington Field Office, Tim coordinated all aspects of security for the President, Vice-President, and foreign heads of state on a regular basis. 
                </p>
                <center><img src="images/alert.jpg" class="m-auto d-inline-block mb-50"/></center>
            </div>
            <div class="next-prev-news d-flex justify-content-between">
                <a href="mar-a-lago-job-openings-raise-security-concerns-cbs-12-feature">
                    <i class="mi-chevron-left"></i>
                    Prev 
                    <span>Mar-A-Lago Job Openings Raise Security Concerns | CBS 12 Feature</span>
                </a>
                <a href="living-in-preparation-not-in-fear">
                    Next
                    <i class="mi-chevron-right"></i>
                   <span>Living in Preparation, Not in Fear</span>
                </a>
            </div>
        </div>
    </section>
</main>

<?php include 'footer.php'; ?> 