<?php
$nb_settings = get_option( 'nb_new_settings' ); ?>
<div class="wrap">
    
    <h2><?php _e( 'Notice Bar Settings', 'notice-bar' ); ?></h2>
    <?php if ( isset( $_GET['success'] ) && 'true' == $_GET['success'] ) : ?>
        <div id="notice-bar-settings_updated" class="updated settings-error notice is-dismissible"> 
            <p>
                <strong><?php echo ($_GET['msg'] == 1) ? __( 'Settings saved.', 'notice-bar' ) : __( 'Default settings restored successfully.', 'notice-bar' ); ?></strong>
            </p>
            <button type="button" class="notice-dismiss">
                <span class="screen-reader-text"><?php _e( 'Dismiss this notice.', 'notice-bar' ); ?></span>
            </button>
        </div>
    <?php endif; ?>

    <div class="nb-settings-form-wrap" >
        <form method="POST" action="<?php echo admin_url( 'admin-post.php' ); ?>" class="nb-settings-form">
            <input type="hidden" name="action" value="nb_settings_save"/>
            <?php wp_nonce_field( 'nb-settings-nonce', 'nb_settings_nonce_field' ); ?>       
            <?php do_action( 'notice_bar_before_setting_fields', $nb_settings ); ?>
            <div class="nb-new-settings-wrap">
                <h3 class="settings-title"><a class="toggle-settings" href="javascript:void(0);"><?php _e( 'Settings', 'notice-bar' ); ?><span class="dashicons dashicons-arrow-down custom-toggle-settings"></span></a></h3>
                <div class="nb-basic-configurations nb-configurations show">
                    <div class="nb-option-field-wrap">
                        <label><?php _e( 'Enable Debug Mode', 'notice-bar' ); ?></label>
                        <div class="nb-option-field">
                            <label class="nb-plain-label">
                                <input type="checkbox" value="1" name="nb_settings[debug_mode]" <?php
                                if ( isset( $nb_settings['debug_mode'] ) ) {
                                    checked( $nb_settings['debug_mode'], true );
                                }
                                ?>>
                                <div class="nb-option-side-note"><?php _e( 'Check if you want to enable debug mode in frontend.', 'notice-bar' ); ?></div>
                                <div class="nb-option-note"><?php _e( 'Enabling debug mode will use uncompressed css and js files in frontend which can be used to debug the css and js conflicts.', 'notice-bar' ); ?></div>
                            </label>
                        </div>
                    </div>
                </div>
            </div>
            <?php do_action( 'notice_bar_after_setting_fields', $nb_settings ); ?>
            <div class="nb-option-field-wrap">
                <label></label>
                <div class="nb-option-field-submit">
                    <input type="submit" name="nb_settings_save_submit" value="<?php _e( 'Save Changes', 'notice-bar' ); ?>" class="button button-primary"/>
                </div>
            </div>

        </form>  
    </div>      
    <?php include(NOTICE_BAR_BASE_PATH . '/inc/backend/sidebar.php'); ?>

</div>