<?php
$args = array(
	'post_type'        => 'buildplus_pricing',
);
$options = array( 'empty' => esc_html__( '-Select Pricing Table-', 'slz-core' ) );
$cus_post = Buildplus_Core_Com::get_post_title2name( $args, $options );

$action_link = array(
	esc_html__( 'Column Link', 'slz-core' )  => 'column_link',
	esc_html__( 'Custom Link', 'slz-core' )  => 'custom_link',
);
$sign_pos = array(
	esc_html__( 'Before', 'slz-core' ) => '',
	esc_html__( 'After', 'slz-core' )  => 'after',
);
$params = array(
	array(
		'type'        => 'dropdown',
		'heading'     => esc_html__( 'Pricing Table', 'slz-core' ),
		'param_name'  => 'pricing_slug',
		'value'       => $cus_post,
		'description' => esc_html__( 'Choose pricing table to display. To add new pricing table, please go to ', 'slz-core') . '<a href="'.esc_url(admin_url( 'post-new.php?post_type=buildplus_pricing' )).'">' . esc_html__('here', 'slz-core') . '</a>'
	),
	array(
		'type'        => 'textfield',
		'class'       => '',
		'heading'     => esc_html__( 'Currency Sign ', 'slz-core' ),
		'param_name'  => 'currency_sign',
		'value'       => '$',
		'description' => esc_html__( 'Enter currency sign for pricing table. Default is $.', 'slz-core' )
	),
	array(
		'type'        => 'dropdown',
		'class'       => '',
		'heading'     => esc_html__( 'Currency Sign Position ', 'slz-core' ),
		'param_name'  => 'currency_sign_pos',
		'value'       => $sign_pos,
		'description' => esc_html__( 'Choose position to display currency sign for pricing table.', 'slz-core' )
	),
	array(
		'type'        => 'textfield',
		'class'       => '',
		'heading'     => esc_html__( 'Link Content', 'slz-core' ),
		'param_name'  => 'btn_content',
		'value'       => esc_html__( 'Get Start', 'slz-core' ),
		'description' => esc_html__( 'Enter content to button', 'slz-core' )
	),
	array(
		'type'        => 'dropdown',
		'heading'     => esc_html__( 'Select Action To Button', 'slz-core' ),
		'param_name'  => 'action_link',
		'value'       => $action_link,
		'std'         => 'column_link',
		'description' => esc_html__( 'Choose action type to button.', 'slz-core')
	),
	
	array(
		'type'        => 'vc_link',
		'heading'     => esc_html__( 'URL (Link)', 'slz-core' ),
		'param_name'  => 'custom_link',
		'description' => esc_html__( 'Add link to image.',  'slz-core'  ),
		'dependency'     => array(
			'element'  => 'action_link',
			'value'    => array( 'custom_link'),
		),
	),
	array(
		'type'        => 'textfield',
		'heading'     => esc_html__( 'Extra Class', 'slz-core' ),
		'param_name'  => 'extra_class',
		'value'       => '',
		'description' => esc_html__( 'Add extra class to block', 'slz-core' )
	),
	array(
		'type'        => 'colorpicker',
		'class'       => '',
		'heading'     => esc_html__( 'Block Background Color', 'slz-core' ),
		'param_name'  => 'block_color',
		'description' => esc_html__( 'Choose background color for block.', 'slz-core' ),
		'group'       => esc_html__( 'Color Options', 'slz-core' ),
	),
	array(
		'type'        => 'colorpicker',
		'class'       => '',
		'heading'     => esc_html__( 'Title Color', 'slz-core' ),
		'param_name'  => 'title_color',
		'description' => esc_html__( 'Choose color for title', 'slz-core' ),
		'group'       => esc_html__( 'Color Options', 'slz-core' ),
	),
	array(
		'type'        => 'colorpicker',
		'class'       => '',
		'heading'     => esc_html__( 'SubTitle Color', 'slz-core' ),
		'param_name'  => 'subtitle_color',
		'description' => esc_html__( 'Choose color for subtitle', 'slz-core' ),
		'group'       => esc_html__( 'Color Options', 'slz-core' ),
	),
	array(
		'type'        => 'colorpicker',
		'class'       => '',
		'heading'     => esc_html__( 'Icon Color', 'slz-core' ),
		'param_name'  => 'icon_color',
		'description' => esc_html__( 'Choose color for icon.', 'slz-core' ),
		'group'       => esc_html__( 'Color Options', 'slz-core' ),
	),
	array(
		'type'        => 'colorpicker',
		'class'       => '',
		'heading'     => esc_html__( 'Feature Color', 'slz-core' ),
		'param_name'  => 'feature_color',
		'description' => esc_html__( 'Choose color for feature', 'slz-core' ),
		'group'       => esc_html__( 'Color Options', 'slz-core' ),
	),
	array(
		'type'        => 'colorpicker',
		'class'       => '',
		'heading'     => esc_html__( 'Price Color', 'slz-core' ),
		'param_name'  => 'price_color',
		'description' => esc_html__( 'Choose color for price.', 'slz-core' ),
		'group'       => esc_html__( 'Color Options', 'slz-core' ),
	),
	array(
		'type'        => 'checkbox',
		'heading'     => esc_html__( 'Button Transparent', 'slz-core' ),
		'param_name'  => 'button_transparent',
		'value'       => array( esc_html__( 'Yes', 'slz-core' ) => 'yes' ),
		'description' => esc_html__( 'Check it to set background transparent for button.', 'slz-core' ),
		'group'       => esc_html__( 'Color Options', 'slz-core' ),
	),
	array(
		'type'        => 'colorpicker',
		'class'       => '',
		'heading'     => esc_html__( 'Button Color', 'slz-core' ),
		'param_name'  => 'button_color',
		'description' => esc_html__( 'Choose color for button.', 'slz-core' ),
		'group'       => esc_html__( 'Color Options', 'slz-core' ),
	),
	array(
		'type'        => 'colorpicker',
		'class'       => '',
		'heading'     => esc_html__( 'Button Border Color', 'slz-core' ),
		'param_name'  => 'button_border_color',
		'description' => esc_html__( 'Choose color for border button.', 'slz-core' ),
		'group'       => esc_html__( 'Color Options', 'slz-core' ),
	),
	array(
		'type'        => 'colorpicker',
		'class'       => '',
		'heading'     => esc_html__( 'Button Hover Color', 'slz-core' ),
		'param_name'  => 'button_hover_color',
		'description' => esc_html__( 'Choose hover color for button.', 'slz-core' ),
		'group'       => esc_html__( 'Color Options', 'slz-core' ),
	),
);
vc_map(array(
	'name'        => esc_html__( 'SLZ Pricing Table', 'slz-core' ),
	'base'        => 'slzcore_pricing_sc',
	'class'       => 'slzcore-sc',
	'icon'        => 'icon-slzcore_pricing_sc',
	'category'    => BUILDPLUS_CORE_SC_CATEGORY,
	'description' => esc_html__( 'Pricing Table.', 'slz-core' ),
	'params'      => $params
));