<?php
$style = array(
	esc_html__( 'Style List', 'slz-core' )	    => 'list',
	esc_html__( 'Style Grid 01', 'slz-core' )	=> 'grid',
	esc_html__( 'Style Grid 02', 'slz-core' )	=> 'grid-2',
	esc_html__( 'Style Slide', 'slz-core' )	    => 'slide',
);
$column = array(
	esc_html__( 'One', 'slz-core' )   		=> '1',
	esc_html__( 'Two', 'slz-core' )   		=> '2',
	esc_html__( 'Three', 'slz-core' ) 		=> '3',
	esc_html__( 'Four', 'slz-core' )  		=> '4',
);
$yes_no  = array(
	esc_html__('Yes', 'slz-core')			=> 'yes',
	esc_html__('No', 'slz-core')			=> 'no',
);
$method = array(
	esc_html__( 'Category', 'slz-core' )	=> 'cat',
	esc_html__( 'Service', 'slz-core' ) 	=> 'service'
);
$sort_by = BuildPlus_Core_Params::get('sort-other');

$args = array('post_type'     => 'buildplus_service');
$options = array('empty'      => esc_html__( '-All Service-', 'slz-core' ) );
$services = BuildPlus_Core_Com::get_post_title2id( $args, $options );

$taxonomy = 'buildplus_service_cat';
$params_cat = array('empty'   => esc_html__( '-All Service Categories-', 'slz-core' ) );
$categories = BuildPlus_Core_Com::get_tax_options2slug( $taxonomy, $params_cat );

$params = array(
	array(
		'type'        	=> 'dropdown',
		'heading'     	=> esc_html__( 'Style', 'slz-core' ),
		'admin_label'	=> true,
		'param_name'  	=> 'style',
		'value'       	=> $style,
		'std'      		=> 'grid',
		'description' 	=> esc_html__( 'Choose style will be displayed.', 'slz-core' )
	),
	array(
		'type'        	=> 'dropdown',
		'heading'     	=> esc_html__( 'Column', 'slz-core' ),
		'admin_label'	=> true,
		'param_name'  	=> 'column',
		'value'       	=> $column,
		'std'      		=> '3',
		'description' 	=> esc_html__( 'Choose number column will be displayed.', 'slz-core' ),		
	),
	array(
		'type'        	=> 'dropdown',
		'heading'     	=> esc_html__( 'Show Description ?', 'slz-core' ),
		'param_name'  	=> 'show_desc',
		'value'       	=> $yes_no,
		'std'      		=> 'yes',
		'description' 	=> esc_html__( 'If choose Yes, block will be show description.', 'slz-core' ),
	),
	array(
		'type'            => 'textfield',
		'heading'         => esc_html__( 'Description Length', 'slz-core' ),
		'param_name'      => 'desc_lenght',
		'description'     => esc_html__( 'Enter number for limiting the number of word displayed.', 'slz-core' ),
		'dependency'     => array(
			'element'  => 'show_desc',
			'value'    => array( 'yes' ),
		),
	),
	array(
		'type'            => 'textfield',
		'heading'         => esc_html__( 'Button Text', 'slz-core' ),
		'param_name'      => 'button_text',
		'description'     => esc_html__( 'Enter value for button displayed. If blank, the button does not show.', 'slz-core' ),
	),
	array(
		'type'        	=> 'dropdown',
		'heading'     	=> esc_html__( 'Show Thumbnail ?', 'slz-core' ),
		'param_name'  	=> 'show_thumbnail',
		'value'       	=> $yes_no,
		'std'      		=> 'yes',
		'description' 	=> esc_html__( 'If choose Yes, block will be show thumbnail image.', 'slz-core' ),
	),
	array(
		'type'        	=> 'dropdown',
		'heading'     	=> esc_html__( 'Show Pagination ?', 'slz-core' ),
		'param_name'  	=> 'pagination',
		'value'       	=> $yes_no,
		'std'      		=> 'no',
		'description' 	=> esc_html__( 'If choose Yes, block will be show pagination.', 'slz-core' ),
		'dependency'  => array(
			'element'   => 'style',
			'value'     => array( 'grid' )
		),
	),

	array(
		'type'            => 'textfield',
		'heading'         => esc_html__( 'Limit Posts', 'slz-core' ),
		'param_name'      => 'limit_post',
		'value'           => '-1',
		'description'     => esc_html__( 'Add limit posts per page. Set -1 or empty to show all.', 'slz-core' )
	),
	array(
		'type'            => 'textfield',
		'heading'         => esc_html__( 'Max Posts', 'slz-core' ),
		'param_name'      => 'max_post',
		'value'           => '',
		'description'     => esc_html__( 'Add total posts when paging.', 'slz-core' ),
		'dependency'  => array(
			'element'   => 'pagination',
			'value'     => array( 'yes' )
		),
	),
	array(
		'type'            => 'textfield',
		'heading'         => esc_html__( 'Offset Posts', 'slz-core' ),
		'param_name'      => 'offset_post',
		'value'           => '0',
		'description'     => esc_html__( 'Enter offset to pass over posts. If you want to start on record 6, using offset 5', 'slz-core' )
	),
	array(
		'type'            => 'dropdown',
		'heading'         => esc_html__( 'Sort By', 'slz-core' ),
		'param_name'      => 'sort_by',
		'value'           => $sort_by,
		'description'     => esc_html__( 'Select order to display list properties.', 'slz-core' ),
	),
	array(
		'type'            => 'textfield',
		'heading'         => esc_html__( 'Extra Class', 'slz-core' ),
		'param_name'      => 'extra_class',
		'description'     => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'slz-core' )
	),

	array(
		'type'        => 'dropdown',
		'heading'     => esc_html__( 'Display By', 'slz-core' ),
		'param_name'  => 'method',
		'value'       => $method,
		'description' => esc_html__( 'Choose service category or special services to display', 'slz-core' ),
		'group'       	=> esc_html__('Filter', 'slz-core'),
	),
	array(
		'type'        => 'param_group',
		'heading'     => esc_html__( 'Category', 'slz-core' ),
		'param_name'  => 'category',
		'params'     => array(
			array(
				'type'        => 'dropdown',
				'admin_label' => true,
				'heading'     => esc_html__( 'Add Category', 'slz-core' ),
				'param_name'  => 'category_slug',
				'value'       => $categories,
				'description' => esc_html__( 'Choose special category to filter', 'slz-core'  )
			),
		),
		'value'       => '',
		'callbacks'   => array(
			'after_add' => 'vcChartParamAfterAddCallback'
		),
		'description' => esc_html__( 'Choose Service Category.', 'slz-core' ),
		'dependency'  => array(
			'element'   => 'method',
			'value'     => array( 'cat' )
		),
		'group'       	=> esc_html__('Filter', 'slz-core'),
	),
	array(
		'type'            => 'param_group',
		'heading'         => esc_html__( 'Services', 'slz-core' ),
		'param_name'      => 'list_post',
		'params'          => array(
			array(
				'type'        => 'dropdown',
				'admin_label' => true,
				'heading'     => esc_html__( 'Add Service', 'slz-core' ),
				'param_name'  => 'service',
				'value'       => $services,
				'description' => esc_html__( 'Choose special service to show',  'slz-core'  )
			),
			
		),
		'value'           => '',
		'dependency'  => array(
			'element'   => 'method',
			'value'     => array( 'service' )
		),
		'callbacks'       => array(
			'after_add'   => 'vcChartParamAfterAddCallback'
		),
		'description'     => esc_html__( 'Default display All Service if no service is selected and Number service is empty.', 'slz-core' ),
		'group'       	=> esc_html__('Filter', 'slz-core'),
	),

	array(
		'type'        	=> 'dropdown',
		'heading'     	=> esc_html__( 'Is Auto Play ?', 'slz-core' ),
		'param_name'  	=> 'slide_autoplay',
		'value'       	=> $yesno,
		'std'      		=> 'no',
		'description' 	=> esc_html__( 'Choose YES to slide auto play.', 'slz-core' ),
		'dependency'  => array(
			'element'   => 'style',
			'value'     => array( 'slide' )
		),
		'group'         => esc_html__('Slide Custom', 'slz-core'),
	),
	array(
		'type'        	=> 'dropdown',
		'heading'     	=> esc_html__( 'Is Dots Navigation ?', 'slz-core' ),
		'param_name'  	=> 'slide_dots',
		'value'       	=> $yesno,
		'std'      		=> 'yes',
		'description' 	=> esc_html__( 'Choose YES to show dot navigation.', 'slz-core' ),
		'dependency'  => array(
			'element'   => 'style',
			'value'     => array( 'slide' )
		),
		'group'         => esc_html__('Slide Custom', 'slz-core'),
	),
	array(
		'type'        	=> 'dropdown',
		'heading'     	=> esc_html__( 'Is Arrows Navigation ?', 'slz-core' ),
		'param_name'  	=> 'slide_arrows',
		'value'       	=> $yesno,
		'std'      		=> 'yes',
		'description' 	=> esc_html__( 'Choose YES to show arrow navigation.', 'slz-core' ),
		'dependency'  => array(
			'element'   => 'style',
			'value'     => array( 'slide' )
		),
		'group'         => esc_html__('Slide Custom', 'slz-core'),
	),
	array(
		'type'        	=> 'dropdown',
		'heading'     	=> esc_html__( 'Is Loop Infinite ?', 'slz-core' ),
		'param_name'  	=> 'slide_infinite',
		'value'       	=> $yesno,
		'std'      		=> 'yes',
		'description' 	=> esc_html__( 'Choose YES to slide loop infinite.', 'slz-core' ),
		'dependency'  => array(
			'element'   => 'style',
			'value'     => array( 'slide' )
		),
		'group'         => esc_html__('Slide Custom', 'slz-core'),
	),
	array(
		'type'           => 'textfield',
		'heading'        => esc_html__( 'Speed Slide', 'slz-core' ),
		'param_name'     => 'slide_speed',
		'value'			 => '600',
		'description'    => esc_html__( 'Enter number value. Unit is millisecond. Example: 600.', 'slz-core' ),
		'dependency'  => array(
			'element'   => 'style',
			'value'     => array( 'slide' )
		),
		'group'          => esc_html__('Slide Custom', 'slz-core'),
	),

	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Title Color', 'slz-core' ),
		'param_name'      => 'color_title',
		'value'           => '',
		'description'     => esc_html__( 'Choose color title for block.', 'slz-core' ),
		'group'       	  => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Title Color Hover', 'slz-core' ),
		'param_name'      => 'color_title_hv',
		'value'           => '',
		'description'     => esc_html__( 'Choose color title for block when hover.', 'slz-core' ),
		'group'       	  => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Description Color', 'slz-core' ),
		'param_name'      => 'color_description',
		'value'           => '',
		'description'     => esc_html__( 'Choose color description for block.', 'slz-core' ),
		'group'       	  => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Item Image Background Color Hover', 'slz-core' ),
		'param_name'      => 'color_item_img_bg_hv',
		'value'           => '',
		'description'     => esc_html__( 'Choose background item image for item when hover.', 'slz-core' ),
		'dependency'  => array(
			'element'   => 'style',
			'value'     => array( 'grid','list' ,'slide')
		),
		'group'       	  => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Item Background Color', 'slz-core' ),
		'param_name'      => 'color_item_bg',
		'value'           => '',
		'description'     => esc_html__( 'Choose background color for item.', 'slz-core' ),
		'dependency'  => array(
			'element'   => 'style',
			'value'     => array( 'grid','slide')
		),
		'group'       	  => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Item Background Hover Color', 'slz-core' ),
		'param_name'      => 'color_item_bg_hv',
		'value'           => '',
		'description'     => esc_html__( 'Choose background color for item when hover.', 'slz-core' ),
		'dependency'  => array(
			'element'   => 'style',
			'value'     => array( 'grid-2' )
		),
		'group'       	  => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Item Border Bottom Color', 'slz-core' ),
		'param_name'      => 'color_item_border',
		'value'           => '',
		'description'     => esc_html__( 'Choose border bottom color for item.', 'slz-core' ),
		'dependency'  => array(
			'element'   => 'style',
			'value'     => array( 'grid','slide')
		),
		'group'       	  => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Button Readmore Color', 'slz-core' ),
		'param_name'      => 'color_button',
		'value'           => '',
		'description'     => esc_html__( 'Choose color button readmore for item.', 'slz-core' ),
		'dependency'  => array(
			'element'   => 'style',
			'value'     => array( 'grid','slide')
		),
		'group'       	  => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Button Readmore Color Hover', 'slz-core' ),
		'param_name'      => 'color_button_hv',
		'value'           => '',
		'description'     => esc_html__( 'Choose color button readmore for item when hover.', 'slz-core' ),
		'dependency'  => array(
			'element'   => 'style',
			'value'     => array( 'grid','slide')
		),
		'group'       	  => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Slide Arrow Color', 'slz-core' ),
		'param_name'      => 'color_slide_arrow',
		'value'           => '',
		'description'     => esc_html__( 'Choose color slide arrow for slide.', 'slz-core' ),
		'dependency'  => array(
			'element'   => 'slide_arrows',
			'value'     => array( 'yes' )
		),
		'group'       	  => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Slide Arrow Color Hover', 'slz-core' ),
		'param_name'      => 'color_slide_arrow_hv',
		'value'           => '',
		'description'     => esc_html__( 'Choose color slide arrow for slide when hover.', 'slz-core' ),
		'dependency'  => array(
			'element'   => 'slide_arrows',
			'value'     => array( 'yes' )
		),
		'group'       	  => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Slide Arrow Background Color', 'slz-core' ),
		'param_name'      => 'color_slide_arrow_bg',
		'value'           => '',
		'description'     => esc_html__( 'Choose background color slide arrow for slide.', 'slz-core' ),
		'dependency'  => array(
			'element'   => 'slide_arrows',
			'value'     => array( 'yes' )
		),
		'group'       	  => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Slide Arrow Background Color Hover', 'slz-core' ),
		'param_name'      => 'color_slide_arrow_bg_hv',
		'value'           => '',
		'description'     => esc_html__( 'Choose background color slide arrow for slide when hover.', 'slz-core' ),
		'dependency'  => array(
			'element'   => 'slide_arrows',
			'value'     => array( 'yes' )
		),
		'group'       	  => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Slide Dots Color', 'slz-core' ),
		'param_name'      => 'color_slide_dots',
		'value'           => '',
		'description'     => esc_html__( 'Choose color slide dots for slide.', 'slz-core' ),
		'dependency'  => array(
			'element'   => 'slide_dots',
			'value'     => array( 'yes' )
		),
		'group'       	  => esc_html__('Custom', 'slz-core'),
	),
);
vc_map(array(
	'name'        => esc_html__( 'SLZ Service List', 'slz-core' ),
	'base'        => 'slzcore_service_list_sc',
	'class'       => 'slzcore-sc',
	'icon'        => 'icon-slzcore',
	'category'    => BUILDPLUS_CORE_SC_CATEGORY,
	'description' => esc_html__( 'List of Services.', 'slz-core' ),
	'params'      => $params
	)
);