<?php
class Buildplus_Core_Partner extends Buildplus_Core_Custom_Post_Model {

	private $post_type = 'buildplus_partner';

	public function __construct() {
		$this->meta_attributes();
		$this->set_meta_attributes();
		$this->post_meta_prefix = $this->post_type . '_';
		$this->taxonomy_cat = 'buildplus_partner_cat';
		$this->uniq_id = 'block-' . Buildplus_Core::make_id();
	}
	public function meta_attributes() {
		$meta_atts = array( 
			'url'             => esc_html__( 'Url', 'slz-core' ),
		);
		$this->post_meta_atts = $meta_atts;
	}
	public function set_meta_attributes() {
		$meta_arr = array();
		$meta_label_arr = array();
		foreach( $this->post_meta_atts as $att => $name ){
			$key = $att;
			$meta_arr[$key] = '';
			$meta_label_arr[$key] = $name;
		}
		$this->post_meta_def = $meta_arr;
		$this->post_meta = $meta_arr;
		$this->post_meta_label = $meta_label_arr;
	}
	public function init( $atts = array(), $query_args = array() ) {
		// set attributes
		$default_atts = array(
			'offset_post' => '0',
			'limit_post'  => '-1',
			'sort_by'     => 'post__in',
			'post_id'     => '',
		);
		$atts = array_merge( $default_atts, $atts );
		$atts['post_id'] = $this->parse_cat_slug_to_post_id(
											$this->taxonomy_cat,
											$atts['category'],
											$this->post_type
										);
		$this->attributes = $atts;
		// query
		$default_args = array(
			'post_type' => $this->post_type,
		);
		$query_args = array_merge( $default_args, $query_args );
		// setting
		$this->setting( $query_args);
	}
	public function setting( $query_args ){
		if( !isset( $this->attributes['uniq_id'] ) ) {
			$this->attributes['uniq_id'] = $this->post_type . '_' .Buildplus_Core::make_id();
		}
		
		// query
		$this->query = $this->get_query( $query_args, $this->attributes );
		$this->post_count = 0;
		if( $this->query->have_posts() ) {
			$this->post_count = $this->query->post_count;
		}
	}
	/*-------------------- >> Css Functions << --------------------*/
	public function add_custom_css() {
		$custom_css = '';
		if( !empty( $this->attributes['dot_color'] ) ){
			$custom_css .= '.%1$s .slick-dots li button:before {color:%2$s;}'."\n";
		}
		if( !empty( $this->attributes['dot_color'] ) ){
			$custom_css .= '.%1$s .slick-dots li.slick-active button:before {color:%3$s;}'."\n";
		}
		
		if ( !empty( $custom_css ) ) {
			$custom_css = sprintf($custom_css,
					esc_attr($this->uniq_id),
					esc_attr($this->attributes['dot_color']),
					esc_attr($this->attributes['dot_at_color'])

			);
			do_action( BUILDPLUS_CORE_ADD_INLINE_CSS, $custom_css );
		}
	}
	public function reset(){
		wp_reset_postdata();
	}
	/*-------------------- >> Render Html << -------------------------*/
	/**
	 * Render html.
	 *
	 * @param array $html_options
	 * Format: 1$ - url mete, 2$ - feature image
	 */
	public function render_partner( $html_options = array() ) {
		while ( $this->query->have_posts() ) {
			$this->query->the_post();
			$this->loop_index();
			$partner_id = get_the_id();
			if( $this->has_thumbnail ) {
				printf( $html_options['html_format'],
						esc_url( $this->get_url() ),
						get_the_post_thumbnail($partner_id, 'full', array('class' => 'img-responsive'))
					);
			}
		}
		$this->add_custom_css();
		$this->reset();
	}
	/*-------------------- >> General Functions << --------------------*/
	public function get_url() {
		$url = $this->post_meta['url'];
		if( empty( $url ) ) {
			return '';
		}
 		return $url;
	}
}