<?php
/**
 * Buildplus loader class.
 * 
 * @author Swlabs
 * @package BuildPlus
 * @since 1.0
 */
class Buildplus_Loader {
	public static function run(){
		// Register widgets
		add_action( 'widgets_init', array( 'Buildplus', '[widget.Widget_Init, load]') );
		// action inline css
		add_action( 'buildplus_add_inline_style', array( 'Buildplus', '[theme.Theme_Init, add_inline_style]') );
		// get page options
		add_action( 'buildplus_page_options',      array( 'Buildplus', '[theme.Theme_Init, get_page_options]') );
		// show index content
		add_action( 'buildplus_show_index',        array( 'Buildplus', '[front.Top_Controller, show_post_index]') );
		// show project archive content
		add_action( 'buildplus_show_project_archive',        array( 'Buildplus', '[front.Top_Controller, show_project_archive]') );
		// show service archive content
		add_action( 'buildplus_show_service_archive',        array( 'Buildplus', '[front.Top_Controller, show_service_archive]') );
		// show team archive content
		add_action( 'buildplus_show_team_archive',        array( 'Buildplus', '[front.Top_Controller, show_team_archive]') );
		
		add_action( 'buildplus_show_header',         array( 'Buildplus', '[front.Top_Controller, header]') );
		add_action( 'buildplus_show_footer',         array( 'Buildplus', '[front.Top_Controller, footer_main]'));
		add_action( 'buildplus_show_breadcrumb',     array( 'Buildplus', '[front.Top_Controller, breadcrumb]') );
		add_action( 'buildplus_entry_thumbnail',     array( 'Buildplus', '[front.Top_Controller, show_post_entry_thumbnail]') );
		add_action( 'buildplus_entry_video',         array( 'Buildplus', '[front.Top_Controller, show_post_entry_video]') );
		add_action( 'buildplus_entry_meta',          array( 'Buildplus', '[front.Top_Controller, show_post_entry_meta]') );
		add_action( 'buildplus_tags_meta',           array( 'Buildplus', '[front.Top_Controller, show_post_tags_meta]') );
		add_action( 'buildplus_categories_meta',     array( 'Buildplus', '[front.Top_Controller, show_post_category_meta]') );
		add_action( 'buildplus_show_page_title',     array( 'Buildplus', '[front.Top_Controller, show_page_title]') );
		add_action( 'buildplus_show_slider',         array( 'Buildplus', '[front.Top_Controller, show_slider]') );
		add_action( 'buildplus_post_author',         array( 'Buildplus', '[front.Top_Controller, show_post_author]') );
		add_action( 'buildplus_post_author_list',    array( 'Buildplus', '[front.Top_Controller, show_author_list]') );
		
		add_action( 'buildplus_show_frm_comment',    array( 'Buildplus', '[front.Top_Controller, show_frm_comment]') );
		add_action( 'buildplus_show_help_link',      array( 'Buildplus', '[front.Top_Controller, show_help_link]') );
		add_action( 'buildplus_show_post_nav',       array( 'Buildplus', '[front.Top_Controller, show_post_nav]') );
		add_action( 'buildplus_show_hamburger_menu', array( 'Buildplus', '[front.Top_Controller, show_hamburger_menu]') );
	
		// login
		add_action( 'buildplus_login_link',          array( 'Buildplus', '[front.Top_Controller, show_login_link]') );

		// subcribe
		add_action( 'buildplus_subcribe',          array( 'Buildplus', '[front.Top_Controller, show_subcribe]') );

		// loading page
		add_action( 'buildplus_loading_page',          array( 'Buildplus', '[front.Top_Controller, loading_page]') );
	}
	
	/**
	 * Fires after WordPress has finished loading but before any headers are sent.
	 */
	public static function init(){
		// Regist Menu
		register_nav_menu( 'main-nav',   esc_html__( 'Main Navigation', 'buildplus' ) );
		register_nav_menu( 'footer-nav', esc_html__( 'Footer Navigation', 'buildplus' ) );
		register_nav_menu( 'page-404-nav', esc_html__( '404 Navigation', 'buildplus' ) );
		
		// Ajax
		add_action( 'wp_ajax_buildplus',        array( 'Buildplus', '[Application, ajax]' ) );
		add_action( 'wp_ajax_nopriv_buildplus', array( 'Buildplus', '[Application, ajax]' ) );
		
		// Welcome page
		add_action( 'admin_menu', array( 'Buildplus', '[theme.Theme_Controller, add_welcome]' ) );
		add_action( 'admin_init', array( 'Buildplus', '[theme.Theme_Controller, call_tgm_plugin_action]' ) );
		
		// Add sidebar area
		add_action( 'admin_print_scripts',                   array( 'Buildplus', '[theme.Widget_Init, add_widget_field]' ) );
		add_action( 'load-widgets.php',                      array( 'Buildplus', '[widget.Widget_Init, add_sidebar_area]' ) );
		add_action( 'wp_ajax_buildplus_del_custom_sidebar', array( 'Buildplus', '[widget.Widget_Init, delete_custom_sidebar]' ) );
	}
	
	/**
	 * It is triggered before any other hook when a user accesses the admin area. 
	 */
	public static function admin(){
		// add action
		add_action( 'save_post',             array( 'Buildplus', '[Application, save]' ) );
		add_action( 'admin_enqueue_scripts', array( 'Buildplus', '[theme.Theme_Init, admin_enqueue]' ) );
		
		// init page options
		add_action( 'buildplus_init_page_setting',   array( 'Buildplus', '[theme.Theme_Init, init_page_setting]' ) );
		do_action(  'buildplus_init_page_setting');
		
		// save_page
		add_action( 'buildplus_save_page',           array( 'Buildplus', '[theme.Theme_Init, save_page]') );
		
		// add mbox page options
		add_action( 'buildplus_metabox_pageoption',  array( 'Buildplus', '[theme.Theme_Init, add_page_options]' ) );
		do_action(  'buildplus_metabox_pageoption' );
		
		add_action( 'buildplus_get_theme_header',    array( 'Buildplus', '[theme.Theme_Controller, get_theme_header]') );
	}
}