<?php
Buildplus::load_class( 'models.Blog_Model' );

class Buildplus_Blog extends Buildplus_Blog_Model {

	private $row_post_counter = 0;
	private $row_counter;
	private $post_counter = 0;
	private $block_atts;
	
	public $large_image_post = true;
	public $start_group = true;
	public $show_full_meta = true;
	public $show_widget_meta = false;

	public function init( $atts ) {
		// default
		$this->large_image_post = true;
		$this->start_group = true;
		$this->row_post_counter = 0;
		$this->row_counter = 1;
		$this->post_counter = 0;

		// set attributes
		$this->block_atts = $atts;
		$this->set_attributes( $atts );
		$this->block_atts['block-class'] = $this->attributes['block-class'];

		$this->get_thumb_size();
		$this->set_responsive_class($atts);
		$this->html_format = $this->set_post_options_defaults( $atts );
	}
	public function set_post_options_defaults( $atts ) {
		$default = array(
			'large_post_format' => '',
			'small_post_format' => '',
			'open_group'        => '',
			'open_row'          => '',
			'close_row'         => '',
			'close_group'       => '',
			'content_length'    => '',
			'large_post_counter'=> 1,
			'show_related_post' => '',
			'new_row'           => '1',
			'thumb_href_class'  => '',
			'show_full_meta'    => '',
			'show_widget_meta'  => '',
			'meta_more_format'  => '',
			'html_format'       => '',
			'title_format'      => '<a href="%2$s" class="title">%1$s</a>',
			'excerpt_format'    => '<div class="description">%1$s</div>',
			'meta_info_format'  => '<div class="block-info">%1$s</div>',
			'image_format'      => '<div class="block-image"></div>',
			'video_format'      => '<div class="block-image block-video">
										<div class="btn-play"> <img src="assets/images/more-images/btn-playvideo.png" alt="" class="img-responsive"></div>
										<div class="btn-close"><img src="assets/images/more-images/btn-closevideo.png" alt="" class="img-responsive"></div>
										%2$s
										%1$s
									</div>',
			'author_format'     => '<div class="meta-info">%3$s<a href="%1$s" class="link">%2$s</a></div>',
			'view_format'       => '<div class="block"><a href="%3$s" class="link">%1$s</a></div>',
			'comment_format'    => '<div class="block"><a href="%3$s" class="link">%1$s</a></div>',
			'date_format'       => '<div class="meta-info time"><span>'.esc_html__('Date: ', 'buildplus').'</span><span><a href="%1$s" class="link">%2$s</a></span></div>',
			'more_btn_format'   => '<a href="%1$s" class="%2$s"><i class="icons fa fa-plus"></i></a>',
			'no_thumbnails_image' => '',
			'bg_image'          => '',
			'meta_icon'         => '',
		);
		foreach($default as $key => $val ) {
			if( isset( $atts[$key] ) ) {
				$default[$key] = $atts[$key];
				unset( $atts[$key] );
			}
		}
		if( $atts ) {
			foreach($atts as $key => $val ) {
				$default[$key] = $atts[$key];
			}
		}
		return $default;
	}
	public function set_widget_options( &$html_options = array() ) {
		$default = array(
			'title_format'      => '<a href="%2$s" class="media-heading" >%1$s</a>',
			'meta_info_format'  => '<div class="meta">%2$s%1$s</div>',
			'image_format'      => '<div class="media-left"><a href="%1$s" class="%4$s">%2$s</a></div>',
			'author_format'     => '<div class="meta-info"><span>%3$s</span><a href="%1$s" class="link">%2$s</a></div>',
			'view_format'       => '<div class="meta-info view"><i class="icon-meta fa fa-eye"></i><span class="link">%2$s</span></div>',
			'comment_format'    => '<div class="meta-info comment"><i class="icon-meta fa fa-comments"></i><a href="%3$s" class="link">%2$s</a></div>',
		);
		$html_options = array_merge( $default, $html_options );
		return $html_options;
	}
	public function set_responsive_class($atts) {
		$class = '';
		$column = $this->attributes['column'];
		if( isset($atts['res_class']) ) {
			$class = $atts['res_class'];
		}
		$def = array(
			'1' => 'col-sm-12',
			'2' => 'col-sm-6 ' . $class,
			'3' => 'col-sm-4 col-xs-12',
			'4' => 'col-sm-3',
		);;
		
		if( $column && isset($def[$column])) {
			$this->attributes['responsive-class'] = $def[$column];
		} else {
			$this->attributes['responsive-class'] = $def['1'];
		}
	}
	/**
	 * Render html to author
	 *
	 */
	public function render_author( $options = array() ) {
		$this->html_format = $this->set_post_options_defaults( $options );
		$number_post = $this->query->query_vars['posts_per_page'] * ( $this->query->query_vars['paged'] -1 );
		$count = 0;
		if( $this->query->have_posts() ) {
			while ( $this->query->have_posts() ) {
				$count++;
				$this->query->the_post();
				$this->loop_index();
				$post_class = $this->get_post_class();
				$excerpt = $this->get_excerpt();
				if( $this->attributes['style'] == 'layout-2' && $this->attributes['show_content'] == 'content' ){
					$excerpt = apply_filters('the_content', get_the_content());
				}
				printf( $this->html_format['html_format'],
						$this->get_featured_by_format( 'large', $options ),
						$this->get_meta_info(),
						$this->get_title(),
						$excerpt,
						$this->view_more_button(),
						$post_class
				);
			}// end while
			// reset query
			wp_reset_postdata();
		}
	}
	public function render_widget( $options = array() ) {
		$this->html_format = $this->set_post_options_defaults( $options );
		while ( $this->query->have_posts() ) {
			$this->query->the_post();
			$this->loop_index();
			// render post
			$html_format = $options['small_post_format'];
			printf( $html_format,
					$this->get_featured_image('large', false, $options),
					$this->get_title(),
					$this->get_meta_info(),
					$this->get_post_class()
			);
		}// end while
		// reset postdata
		wp_reset_postdata();
	}

	public function get_meta_info() {
		$meta_array = array(
			'date'     => $this->get_date(),
			'author'   => $this->get_author(),
			'view'     => $this->get_views(),
			'comment'  => $this->get_comments()
		);
		$output = '';
		foreach( $meta_array as $key => $val ) {
			if( !empty( $val ) ) {
				$output .= $val;
			}
		}
		if( !empty( $output ) ) {
			$output = sprintf( $this->html_format['meta_info_format'], $output, $this->html_format['meta_icon'] );
		}
		return $output;
	}

	private function get_thumb_size() {
		$params = Buildplus_Params::get('default-image-size');
		if( !isset($params[$this->attributes['layout']]) ) {
			$this->attributes['thumb-size'] = array(
				'large'          => 'post-thumbnail',
				'no-image-large' => 'thumb-no-image.gif',
			);
		}
		else {
			$this->attributes['thumb-size'] = $this->get_thumb_sizes( $params[$this->attributes['layout']], $this->attributes );
		}
	}
	
	private function get_post_date() {
		$format = '<div class="block"><span class="link">%5$s</span><a href="%4$s" class="link date">%2$s %1$s, %3$s</a></div>';
		$day    = get_the_time('d');
		$month  = get_the_time('M');
		$year   = get_the_time('Y');
		$output = sprintf( $format, $day, $month, $year, esc_url( buildplus_get_link_url() ),esc_html__('Date:', 'buildplus') );
		return $output;
	}
	public function get_adjacent_post( $adjacent_post, $previous = true ) {
		$format = '<div class="recent-post-inner">
					<div class="media style-3">
						%1$s
						<div class="media-right">
							%2$s
							<div class="meta">
								%3$s
								%4$s
							</div>
						</div>
					</div>
				</div>';
		$img_format = '<div class="media-left">
							<a href="%1$s" class="wrapper-image">%2$s</a>
						</div>';
		if($adjacent_post){
			$post_id = $adjacent_post->ID;
			$title = $adjacent_post->post_title;
		
			if ( empty( $adjacent_post->post_title ) )
				$title = $previous ? esc_html__( 'Previous Post', 'buildplus' ) : esc_html__( 'Next Post', 'buildplus' );
		
			/** This filter is documented in wp-includes/post-template.php */
			$title = apply_filters( 'the_title', $title, $post_id );
		
			$date = mysql2date( get_option( 'date_format' ), $adjacent_post->post_date );
			$rel = $previous ? 'prev' : 'next';
			$permalink = get_permalink( $adjacent_post );
			
			$title_str = '<a href="' . esc_url($permalink) . '" rel="'.$rel.'" class="media-heading">'. $title. '</a>';
			$thumb = '';
			if(has_post_thumbnail($adjacent_post)){
				$thumb = sprintf($img_format, esc_url($permalink), get_the_post_thumbnail( $post_id, 'post-thumbnail', array('class' => 'media-object') ) );
			}
			$author = '<div class="meta-info"><span>'.esc_html__('By', 'buildplus').'</span><a href="'.esc_url(get_author_posts_url( $adjacent_post->post_author )).'" class="link">'.esc_html( get_the_author_meta('display_name', $adjacent_post->post_author ) ).'</a></div>';
			$comment_text = '';
			if ( ! post_password_required($adjacent_post) && ( comments_open($adjacent_post) || get_comments_number($adjacent_post) ) ) {
				$comment_text = '<div class="meta-info"><a href="'.esc_url( get_comments_link($adjacent_post) ).'" class="link">'.$this->get_comment_string($adjacent_post).'</a></div>';
			}
			
			printf($format, $thumb, $title_str, $author, $comment_text );
		}
	}
	public function get_comment_string( $cur_post, $zero = false, $one = false, $more = false ) {
		$output = '';
		if ( ! post_password_required($cur_post) && ( comments_open($cur_post) || get_comments_number($cur_post) ) ) {
			$number = get_comments_number($cur_post);
			if ( $number > 1 ) {
				if ( false === $more ) {
					/* translators: %s: number of comments */
					$output = sprintf( _n( '%s Comment', '%s Comments', $number, 'buildplus' ), number_format_i18n( $number ) );
				} else {
					// % Comments
					$output = str_replace( '%', number_format_i18n( $number ), $more );
				}
			} elseif ( $number == 0 ) {
				$output = ( false === $zero ) ? esc_html__( 'No Comments', 'buildplus' ) : $zero;
			} else { // must be one
				$output = ( false === $one ) ? esc_html__( '1 Comment', 'buildplus' ) : $one;
			}
		}
		return $output;
	}
	//paging
	public  function paging_nav( $pages = '', $range = 2, $current_query = '' ) {
		$theme_post_pagination_link = 'buildplus_post_pagination_link';
		global $paged;
		if( $current_query == '' ) {
			if( empty( $paged ) ) $paged = 1;
		} else {
			$paged = $current_query->query_vars['paged'];
		}
		$prev = $paged - 1;
		$next = $paged + 1;
		$range = 1; // only edit this if you want to show more page-links
		$showitems = ($range * 2);
		
		if( $pages == '' ) {
			global $wp_query;
			$pages = $wp_query->max_num_pages;
			if( ! $pages ) {
				$pages = 1;
			}
		}
		$method = "get_pagenum_link";
		if(is_single()) {
			$method = 'buildplus_post_pagination_link';
		}
		$output = $output_page = $showpages = $disable = '';
		$page_format = '<li><a href="%2$s" class="link" >%1$s</a></li>';
		if( 1 != $pages ) {
			$output_page .= '<ul class="pagination">';
			// prev
			if( $paged == 1 ) {
				$disable = ' hide';
			}
			$output_page .= '<li><a href="'.$method($prev).'" class="link previous">'.esc_html__('previous', 'buildplus').'</a></li>';
			// first pages
			if( $paged > $showitems ) {
				$output_page .= sprintf( $page_format, 1, $method(1) );
			}
			// show ...
			if( $paged - $range > $showitems && $paged - $range > 2 ) {
				$output_page .= sprintf( $page_format, '&bull;&bull;&bull;', $method($paged - $range - 1) );'<li><a href="'.$method($prev).'">&bull;&bull;&bull;</a></li>';
			}
			for ($i=1; $i <= $pages; $i++) {
				if (1 != $pages &&( !($i >= $paged+$showitems || $i <= $paged-$showitems) || $pages <= $showitems )) {
					if( $paged == $i ) {
						$output_page .= '<li><span class="link active">'.$i.'</span></li>';
					} else {
						$output_page .= sprintf( $page_format, $i, $method($i) );
					}
					$showpages = $i;
				}
			}
			// show ...
			if( $paged < $pages-1 && $showpages < $pages -1 ){
				$showpages = $showpages + 1;
				$output_page .= sprintf( $page_format, '...', $method($showpages) );
			}
			// end pages
			if( $paged < $pages && $showpages < $pages ) {
				$output_page .= sprintf( $page_format, $pages, $method($pages) );
			}
			//next
			$disable = '';
			if( $paged == $pages ) {
				$disable = ' hide';
			}
			$output_page .= '<li><a href="'.$method($next).'" class="link next">'.esc_html__('next', 'buildplus').'</a></li>';
			$output_page .= '</ul>'."\n";
			$output = sprintf('<div class="pagination-wrapper undefined margin-top-30">%1$s</div>', $output_page );
		}
		return $output;
	}
	
}