<?php
/**
 * Widget_Files_List class.
 * 
 * @since 1.0
 */

class Buildplus_Widget_Files_List extends WP_Widget {

	public function __construct() {
		$widget_ops = array(
			'classname'   => 'widget_files_list',
			'description' => esc_html__( "A files list.", 'buildplus')
		);
		parent::__construct( 'buildplus_files_list', esc_html_x( 'SLZ: Files List', 'Files list widget', 'buildplus' ), $widget_ops );
	}

	function form( $instance ) {
		$default = array(
			'title'       => '',
			'attach_type' => '',
			'post_id'     => ''
		);
		$instance    = wp_parse_args( (array) $instance, $default );
		$title       = $instance['title'];
		$attach_type = $instance['attach_type'];
		$post_id     = $instance['post_id'];
		$arr_type    = array(
							'media'   => esc_html__('Media', 'buildplus'),
							'project' => esc_html__('Projects', 'buildplus'),
							'service' => esc_html__('Services', 'buildplus')
						);
		?>
		<p>
			<label for="<?php echo  esc_attr( $this->get_field_id('title') ); ?>"><?php esc_html_e('Title', 'buildplus');?></label>
			<input class="widefat" type="text" id="<?php echo esc_attr( $this->get_field_id('title') ); ?>" name="<?php echo esc_attr( $this->get_field_name('title') ); ?>" value="<?php echo esc_attr( $title ); ?>" />
		</p>
		<p>
			<label for="<?php echo  esc_attr( $this->get_field_id('attach_type') ); ?>"><?php esc_html_e( 'Choose attachment from', 'buildplus' );?></label>
			<select class="widefat" id="<?php echo esc_attr( $this->get_field_id('attach_type') ); ?>" name="<?php echo esc_attr( $this->get_field_name('attach_type') ); ?>" >
				<?php foreach( $arr_type  as $k => $v ){?>
					<option value="<?php echo esc_attr($k); ?>"<?php if( $attach_type == $k ) echo " selected"; ?>><?php echo esc_html($v); ?></option>
				<?php } ?>
			</select>
		</p>
		<p>
			<label for="<?php echo  esc_attr( $this->get_field_id('post_id') ); ?>"><?php esc_html_e('Post ID', 'buildplus');?></label>
			<input class="widefat" type="text" id="<?php echo esc_attr( $this->get_field_id('post_id') ); ?>" name="<?php echo esc_attr( $this->get_field_name('post_id') ); ?>" value="<?php echo esc_attr( $post_id ); ?>" />
		</p>
		<p class="decription"><?php esc_html_e('IDs separated by commas. Ex: 1, 2, 3', 'buildplus') ?></p>
		<?php
	}

	function update( $new_instance, $old_instance ) {
		$instance                = $old_instance;
		$instance['title']       = strip_tags( $new_instance['title'] );
		$instance['attach_type'] = $new_instance['attach_type'];
		$instance['post_id']     = trim( trim($new_instance['post_id']), ',' );
		return $instance;
	}

	function widget( $args, $instance ) {
		extract( $args );
		$default = array(
			'title'       => '',
			'attach_type' => '',
			'post_id'     => ''
		);
		$instance    = wp_parse_args( (array) $instance, $default );
		$title       = apply_filters( 'widget_title', $instance['title'] );
		$post_id     = array_filter( explode( ',', trim( trim( $instance['post_id'] ), ',' ) ), 'is_numeric' );
		$attach_type = $instance['attach_type'];
		$attachment_ids = array();
		if( $attach_type == 'media' ){
			if( !empty( $post_id ) ){
				$attachment_ids = $post_id;
			}
			else{
				$args = array( 'post_type' => 'attachment', 'post_status' => 'inherit' );
				$attachment_ids = Buildplus_Core_Com::get_post_title2id( $args );
			}
		}
		elseif( $attach_type == 'project' ){
			$atts = array();
			if( !empty( $post_id ) ){
				$atts['post_id'] = $post_id;
			}
			$model = new BuildPlus_Core_Project();
			$model->init( $atts );
			$attachment_ids = $model->get_attachment_ids();
		}
		else{ // service
			$atts = array();
			if( !empty( $post_id ) ){
				$atts['post_id'] = $post_id;
			}
			$model = new Buildplus_Core_Service();
			$model->init( $atts );
			$attachment_ids = $model->get_attachment_ids();
		}
		echo wp_kses_post($before_widget);
		echo '<div class="widget download-widget">';
			if( !empty( $title ) ) {
				echo wp_kses_post( $before_title );
				echo esc_html( $title );
				echo wp_kses_post( $after_title );
			}
			if( !empty( $attachment_ids ) ){
				echo '<div class="list-download">';
					foreach( $attachment_ids as $attach_id ){
						if( !empty( $attach_id ) ){
							$attach_url  = wp_get_attachment_url($attach_id);
							if( !empty( $attach_url ) ){
								$attach_ext  = pathinfo( $attach_url, PATHINFO_EXTENSION );
								$attach_icon = Buildplus_Core_Util::get_icon_for_extension( $attach_ext );
								$attach_name = basename( $attach_url );
								echo '<a href="'.esc_url( $attach_url ).'" class="btn-has-icon" target="_blank">'.wp_kses_post( $attach_icon ).'<span class="text">'.esc_html( $attach_name ).'</span></a>';
							}
						}
					}
				echo '</div>';
			}
		echo '</div>';
		echo wp_kses_post($after_widget);
	}
}