<?php
/**
 * Widget_Project class.
 * 
 * @since 1.0
 */

class Buildplus_Widget_Project extends WP_Widget {

	public function __construct() {
		$widget_ops = array( 'classname' => 'widget_buildplus_project', 'description' => esc_html__( "A list of projects", 'buildplus' ) );
		parent::__construct( 'buildplus_projects', esc_html_x( 'SLZ: Projects', 'Projects widget', 'buildplus' ), $widget_ops );
	}

	function form( $instance ) {
		$default = array(
			'style'         => '',
			'desc_lenght'   => '10',
			'title'   		=> esc_html__( "Projects", 'buildplus' ),
			'limit_post' 	=> '5',
			'offset_post' 	=> '',
			'sort_by' 		=> '',
			'category_slug' => '',
			'column'        => '',
		);
		$sort_arr       = Buildplus_Core_Params::get('sort-custom');
		$cat_arr        = Buildplus_Core_Com::get_tax_options2slug( 'buildplus_project_cat', array('empty'       => esc_html__( '--All Categories--', 'buildplus' ) ) );
		$instance 		= wp_parse_args( (array) $instance, $default );
		$title    		= esc_attr($instance['title']);
		$limit_post 	= esc_attr($instance['limit_post']);
		$offset_post 	= esc_attr($instance['offset_post']);
		$sort_by 		= esc_attr($instance['sort_by']);
		$category 		= esc_attr($instance['category_slug']);
		$style          = esc_attr($instance['style']);
		$desc_lenght    = esc_attr($instance['desc_lenght']);
		$column    		= esc_attr($instance['column']);
		?>
		<p>
			<label for="<?php echo  esc_attr( $this->get_field_id('style') ); ?>"><?php esc_html_e( 'Style', 'buildplus' );?></label>
			<select class="widefat" id="<?php echo esc_attr( $this->get_field_id('style') ); ?>" name="<?php echo esc_attr( $this->get_field_name('style') ); ?>" >
				<option value="01" <?php if( $style == '01' ) echo "selected"; ?>><?php esc_html_e( 'Style 01', 'buildplus' );?></option>
				<option value="02" <?php if( $style == '02' ) echo "selected"; ?>><?php esc_html_e( 'Style 02', 'buildplus' );?></option>
				<option value="03" <?php if( $style == '03' ) echo "selected"; ?>><?php esc_html_e( 'Style 03', 'buildplus' );?></option>
			</select>
		</p>
		<p>
			<label for="<?php echo  esc_attr( $this->get_field_id('title') ); ?>"><?php esc_html_e( 'Title', 'buildplus' );?></label>
			<input class="widefat" type="text" id="<?php echo esc_attr( $this->get_field_id('title') ); ?>" name="<?php echo esc_attr( $this->get_field_name('title') ); ?>" value="<?php echo esc_attr( $title ); ?>" />
		</p>
		<p>
			<label for="<?php echo  esc_attr( $this->get_field_id('limit_post') ); ?>"><?php esc_html_e( 'Number Post', 'buildplus' );?></label>
			<input class="widefat" type="text" id="<?php echo esc_attr( $this->get_field_id('limit_post') ); ?>" name="<?php echo esc_attr( $this->get_field_name('limit_post') ); ?>" value="<?php echo esc_attr( $limit_post ); ?>" />
		</p>
		<p>
			<label for="<?php echo  esc_attr( $this->get_field_id('offset_post') ); ?>"><?php esc_html_e( 'Offset post', 'buildplus' );?></label>
			<input class="widefat" type="text" id="<?php echo esc_attr( $this->get_field_id('offset_post') ); ?>" name="<?php echo esc_attr( $this->get_field_name('offset_post') ); ?>" value="<?php echo esc_attr( $offset_post ); ?>" />
		</p>
		<p>
			<label for="<?php echo  esc_attr( $this->get_field_id('column') ); ?>"><?php esc_html_e( 'Columns', 'buildplus' );?></label>
			<input class="widefat" type="text" id="<?php echo esc_attr( $this->get_field_id('column') ); ?>" name="<?php echo esc_attr( $this->get_field_name('column') ); ?>" value="<?php echo esc_attr( $column ); ?>" />
			<span class="decription"><?php esc_html_e( 'This option only apply for Style 02 and Style 03.', 'buildplus' );?></span>
		</p>
		<p>
			<label for="<?php echo  esc_attr( $this->get_field_id('desc_lenght') ); ?>"><?php esc_html_e( 'Description length', 'buildplus' );?></label>
			<input class="widefat" type="text" id="<?php echo esc_attr( $this->get_field_id('desc_lenght') ); ?>" name="<?php echo esc_attr( $this->get_field_name('desc_lenght') ); ?>" value="<?php echo esc_attr( $desc_lenght ); ?>" />
			<span class="decription"><?php esc_html_e( 'This option only apply for Style 02 and Style 03.', 'buildplus' );?></span>
		</p>
		<p>
			<label for="<?php echo  esc_attr( $this->get_field_id('sort_by') ); ?>"><?php esc_html_e( 'Sort By', 'buildplus' );?></label>
			<select class="widefat" id="<?php echo esc_attr( $this->get_field_id('sort_by') ); ?>" name="<?php echo esc_attr( $this->get_field_name('sort_by') ); ?>" >
				<?php foreach( $sort_arr  as $k => $v ){?>
					<option value="<?php echo esc_attr($v); ?>"<?php if( $sort_by == $v ) echo " selected"; ?>><?php echo esc_html($k); ?></option>
				<?php } ?>
			</select>
		</p>
		<p>
			<label for="<?php echo  esc_attr( $this->get_field_id('category_slug') ); ?>"><?php esc_html_e( 'Projects Categories', 'buildplus' );?></label>
			<select class="widefat" id="<?php echo esc_attr( $this->get_field_id('category_slug') ); ?>" name="<?php echo esc_attr( $this->get_field_name('category_slug') ); ?>" >
				<?php foreach( $cat_arr  as $k => $v ){?>
					<option value="<?php echo esc_attr($v); ?>"<?php if( $category == $v ) echo " selected"; ?>><?php echo esc_html($k); ?></option>
				<?php } ?>
			</select>
		</p>
		<?php
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$params = array(
			'style',
			'title',
			'limit_post',
			'offset_post',
			'sort_by',
			'category_slug',
			'desc_lenght',
			'column'
		);
		foreach( $params as $item ) {
			$instance[$item] = strip_tags( $new_instance[$item] );
		}
		return $instance;
	}

	function widget( $args, $instance ) {
		extract( $args );
		$default  = array(
			'style'           => '',
			'title'           => '',
			'limit_post'      => '',
			'offset_post'     => '',
			'sort_by'         => '',
			'category_slug'   => '',
			'desc_lenght'     => '',
			'column'          => '',
		);
		$instance = wp_parse_args( (array) $instance, $default ); 
		$instance['column'] = absint($instance['column']);
		if( empty($instance['column']) ) {
			$instance['column'] = 1;
		}
		extract( $instance );
		if( $style != '01' ){
			$instance['show_desc'] = 'yes';
			$instance['desc_type'] = 'desc_proj';
		}
		$model = new Buildplus_Core_Project();
		$model->init( $instance );
		$block_cls = $model->attributes['uniq_id'];
		echo wp_kses_post( $before_widget );?>
			<div class="widget categories-widget project-widget">
			<?php
				if( !empty( $title ) ) {
					echo wp_kses_post( $before_title );
					echo esc_html( $title );
					echo wp_kses_post( $after_title );
				}
				if( $model->post_count ):
			?>
				<div class="categories-inner <?php echo esc_attr( $block_cls ); ?>">
					<?php
						switch($style){
							case '02':
								$html_format = '
									<div class="item project_%5$s %7$s inline_block">
										<div class="block-2">
											%1$s
											<div class="block-content">
												%6$s
												<a href="%4$s" class="title">%2$s</a>
												%3$s
												<a href="%4$s" class="readmore"><span class="text">'.esc_html__( 'read more', 'buildplus' ).'</span><i class="icons fa fa-angle-double-right"></i></a>
											</div>
										</div>
									</div>
								';
								$html_render = array(
									'html_format' 		=> $html_format,
									'excerpt_format' 	=> '<div class="description"><div class="text">%1$s</div></div>',
									'thumb_class' 		=> 'img-full',
									'image_format'		=> '<div class="block-image">%1$s<a href="%2$s" class="link"></a></div>'
								);
								echo '<div class="list-block column-' . $column .'">';
								$model->render_project_list_sc( $html_render ); 
								echo '</div>';
								break;
							case '03':
								$html_format = '
									<div class="item project_%5$s %7$s inline_block">
										<div class="block-1">
											%1$s
											<div class="block-content">
												<a href="%4$s" class="title">%2$s</a>
												%3$s
												<a href="%4$s" class="readmore"><span class="text">'.esc_html__( 'read more', 'buildplus' ).'</span><i class="icons fa fa-angle-double-right"></i></a>
											</div>
										</div>
									</div>
								';
								$html_render = array(
									'html_format' 		=> $html_format,
									'excerpt_format' 	=> '<div class="description"><div class="text">%1$s</div></div>',
									'thumb_class' 		=> 'img-full',
									'image_format'		=> '<div class="block-image">%1$s<a href="%2$s" class="link"></a></div>'
								);
								echo '<div class="list-block column-' . $column .'">';
								$model->render_project_list_sc( $html_render ); 
								echo '</div>';
								break;
							default:
								
								$html_format = '<a href="%2$s" class="link"><span>%1$s</span><i class="icons fa fa-angle-right"></i></a>';
								$html_render = array('html_format' => $html_format);
								$model->render_widget( $html_render );
						}
					?>
				</div>
				<?php endif; // end post_count?>
			</div><?php 
		echo wp_kses_post( $after_widget );
	}
}
