<?php
/**
 * Dynamic css from theme options - Output will be included into end of head tag
 *
 * @author Swlabs
 * @package BuildPlus
 * @since 1.0
 */
function buildplus_dynamic_css() {

	// page options
	do_action('buildplus_page_options');
	$content = "";
	$content_desktop = "";
	// page padding ( top, bottom ) 
	$content_ptop    = Buildplus::get_option('slz-content-padding-top');
	$content_pbottom = Buildplus::get_option('slz-content-padding-bottom');
	$content_pbottom = str_replace('px', '', $content_pbottom);
	$content_ptop = str_replace('px', '', $content_ptop);
	if( is_numeric( $content_ptop ) ) {
		$content_ptop = 'padding-top:'.$content_ptop.'px;';
	} else {
		$content_ptop = '';
	}
	if( is_numeric( $content_pbottom ) ) {
		$content_pbottom = 'padding-bottom:'.$content_pbottom.'px;';
	} else {
		$content_pbottom = '';
	}
	
	$content .= '#page-wrapper .page-detail,#page-wrapper.project-single{'.esc_attr($content_ptop).esc_attr($content_pbottom).'}';

	/*General*/
	$loading_page_color = Buildplus::get_option('slz-loading-page-bg-color');
	$boxed_layout  	= Buildplus::get_option('slz-layout');
	$boxed_bg      	= Buildplus::get_option('slz-layout-boxed-bg');
	$back_to_top   	= Buildplus::get_option('slz-backtotop');
	$btt_color_type = Buildplus::get_option('slz-backtotop-color-type');
	$btt_color     	= Buildplus::get_option('slz-backtotop-color');

	//loading page
	if(!empty($loading_page_color)){
		$content .='#loading-page{background-color:'.esc_attr($loading_page_color).'}';
		$content .='.machine .machine-roof,.machine .machine-main .machine-back:before,
		.machine .machine-main .machine-body:after{background:'.esc_attr($loading_page_color).'}';
		$content .='.machine .machine-main .machine-front{border-top: 2px solid '.esc_attr($loading_page_color).';}';
		$content .='.machine .machine-main .machine-front:after{border: 2px solid '.esc_attr($loading_page_color).';}';
		
		
	}
	// back to top button
	if( $btt_color && $btt_color_type == '1' ){
		$content .= '#back-top.slz-back-to-top a.show-btn{color:'.esc_attr($btt_color).';border-color: '.esc_attr($btt_color).';}';
		$content .= '#back-top.slz-back-to-top a.show-btn:hover{background-color:'.esc_attr($btt_color).';color:#ffffff;}';
	}
	// body background
	if($boxed_layout == '2'){
		if ( $boxed_bg ) {
			$bg_image = '';
			if( !empty($boxed_bg['background-image']) ) {
				$bg_image = 'background-image: url("'.esc_url($boxed_bg['background-image']).'");';
			}
			if ( !empty($boxed_bg['background-color']) || $bg_image ) {
				$content .= 'body {background-color: ' .esc_attr($boxed_bg['background-color']). ';'.$bg_image.'background-repeat: ' .esc_attr($boxed_bg['background-repeat']). ';background-attachment: ' .esc_attr($boxed_bg['background-attachment']). ';background-position:'.esc_attr($boxed_bg['background-position']).';background-size:'.esc_attr($boxed_bg['background-size']).';}';
			}
		}
	}
	
	/*Header top*/
	$tb_icon_color   = Buildplus::get_option('slz-topbar-icon-color');
	$tb_text_color   = Buildplus::get_option('slz-topbar-text-color');

	if( !empty( $tb_icon_color ) ){
		$content .= 'header .header-wrapper .topbar-list .topbar-icons,.header-wrapper.header-cleaning .topbar-icons,header .header-topbar .item.social a,header .header-cleaning .header-topbar .item.social a,header .header-plumbing .header-topbar .item.social a{color:'.$tb_icon_color.'}';
	}
	if( !empty( $tb_text_color ) ){
		$content .= 'header .header-wrapper .topbar-list .topbar-text,header .header-wrapper .topbar-list .topbar-description{color:'.$tb_text_color.'}';
	}
	
	/* Menu */
	$menu_text   = Buildplus::get_option('slz-menu-item-text');
	$menu_custom = Buildplus::get_option('slz-menu-custom');
	$line_menu_color_type  = Buildplus::get_option('slz-menu-line-color-type');
	$line_menu_color  = Buildplus::get_option('slz-menu-line-color');

	// main menu
	if(!empty($line_menu_color) && $line_menu_color_type == '1' ){
		$content .= 'header .nav-menu > li > a:before{background-color:'.esc_attr($line_menu_color).'}';
		$content .= 'header .mega-menu,header .menu-wrapper > li.dropdown:hover > .sub-menu > li:nth-child(1),header .header-wrapper.header-cleaning .header-main,header .header-wrapper.header-cleaning .search-form{border-color:'.esc_attr($line_menu_color).'}';
	}
	if($menu_custom == '1'){
		if(!empty($menu_text)){
			$content .= 'header .nav-menu > li > a {color:'.esc_attr($menu_text['regular']).'}';

			$content .= 'header .nav-menu > li:hover > a{color:'.esc_attr($menu_text['hover']).'}';

			$content .= 'header .nav-menu > li.active > a{color:'.esc_attr($menu_text['active']).'}';
		}
	}
	
	// mega menu
	$mega_custom            = Buildplus::get_option('slz-megamenu-custom');
	$megamenu_item_border   = Buildplus::get_option('slz-megamenu-item-border');
	$megamenu_color    		= Buildplus::get_option('slz-megamenu-color');
	$megamenu_padding  		= Buildplus::get_option('slz-megamenu-padding');

	if($mega_custom){
		if(!empty($megamenu_padding)){
			$content .='.mega-menu .mega-menu-wrapper .mega-menu-column .link{'
			.'padding-right:'.esc_attr($megamenu_padding['padding-right'])
			.';padding-left:'.esc_attr($megamenu_padding['padding-left']).';'
			.'padding-top:'.esc_attr($megamenu_padding['padding-top'])
			.';padding-bottom:'.esc_attr($megamenu_padding['padding-bottom']).';}';
		}

		if($megamenu_color){
			$content .='.mega-menu .mega-menu-wrapper .mega-menu-column .link{'
			.'color:'.esc_attr($megamenu_color['regular']).';}';

			$content .='.mega-menu .mega-menu-wrapper .mega-menu-column li:hover .link{'
			.'color:'.esc_attr($megamenu_color['hover']).';}';
		}
	
		if(!empty($megamenu_item_border)){
			$content.= '.mega-menu .mega-menu-wrapper .mega-menu-column .list-link li{border-bottom: '.esc_attr($megamenu_item_border['border-bottom']).' '.esc_attr($megamenu_item_border['border-style']).' '.esc_attr($megamenu_item_border['border-color']).'}';
			$content.= '.mega-menu .mega-menu-wrapper .mega-menu-column .title{border-bottom: '.esc_attr($megamenu_item_border['border-bottom']).' '.esc_attr($megamenu_item_border['border-style']).' '.esc_attr($megamenu_item_border['border-color']).'}';
			
		}
		
	}
	
	//drop down
	$custom_dropdown   = Buildplus::get_option('slz-dropdown-custom');
	$submenu_border    = Buildplus::get_option('slz-submenu-border');
	$submenu_color     = Buildplus::get_option('slz-submenu-color');
	$submenu_padding   = Buildplus::get_option('slz-submenu-padding');
	$submenu_bg_hover  = Buildplus::get_option('slz-submenu-bg');

	if ($custom_dropdown == '1'){
		
		if(!empty($submenu_color['regular'])){
			$content .= 'header .sub-menu  li a{'
				.'color:'.esc_attr($submenu_color['regular']).';}';
		}
		if(!empty($submenu_color['hover'])){
			$content .= 'header .sub-menu  li:hover  a{color:'.esc_attr($submenu_color['hover']).'}';
		}
		if($submenu_padding){
			$content .= 'header .sub-menu > li > a{'
				.'padding-right:'.esc_attr($submenu_padding['padding-right'])
				.';padding-left:'.esc_attr($submenu_padding['padding-left']).';'
				.'padding-top:'.esc_attr($submenu_padding['padding-top'])
				.';padding-bottom:'.esc_attr($submenu_padding['padding-bottom']).';}';
		}

		if(!empty($submenu_bg_hover)){
			if(isset($submenu_bg_hover['alpha'])){
				if(($submenu_bg_hover['alpha']) != '1'){
				$content .= 'header .sub-menu > li:hover{background-color:'.esc_attr($submenu_bg_hover['rgba']).'}';
				}else{
					$content .= 'header .sub-menu > li:hover{background-color:'.esc_attr($submenu_bg_hover['color']).'}';
				}
			}
		}
	}
	
	/* Page Title */
	$page_title_show   = Buildplus::get_option('slz-page-title-show');
	$page_title_bg	   = Buildplus::get_option('slz-page-title-bg');
	$page_title_align  = Buildplus::get_option('slz-pagetitle-align');
	$bc_typo           = Buildplus::get_option('slz-breadcrumb-path');
	$bc_typo2          = Buildplus::get_option('slz-breadcrumb-path2');
	$title_typo        = Buildplus::get_option('slz-pagetitle-title');
	$bc_border_color   = Buildplus::get_option('slz-breadcrumb-border-color');
	$ptt_line_color    = Buildplus::get_option('slz-pagetitle-line-color');
	$ptt_height        = Buildplus::get_option('slz-page-title-height');
	
	if ( $page_title_show == '1' ) {
		if(!empty($ptt_height['height'])){
			$content_desktop .= '.banner-pages .container.container-wrapper{height:'.esc_attr($ptt_height['height']).';}';
		}
		if( $page_title_bg ) {
			$bg_image = '';
			if( $page_title_bg['background-image'] ) {
				$bg_image = 'background-image: url("' .esc_url($page_title_bg['background-image']). '");';
			}
			$content .= '.banner-pages{background-color: ' .esc_attr($page_title_bg['background-color']). ';' . $bg_image . 'background-repeat: ' .esc_attr($page_title_bg['background-repeat']). ';background-attachment: ' .esc_attr($page_title_bg['background-attachment']). ';background-position:'.esc_attr($page_title_bg['background-position']).';background-size:'.esc_attr($page_title_bg['background-size']).';}';

			if(!empty($page_title_align )){
				$content .= '.banner-pages .title-wrapper{float:'.esc_attr($page_title_align).';}';
			}
			if(!empty($ptt_line_color)){
				$content .= '.banner-pages .banner-wrapper{border-color:'.esc_attr($ptt_line_color).';}';
				$content .= '.banner-pages .title:before{background-color:'.esc_attr($ptt_line_color).';}';
			}
			
		}
		// title
		if(!empty($title_typo)){
			if(!empty($title_typo['color'])){
				$content .= '.banner-pages .title{color:'.esc_attr($title_typo['color']).';}';
			}
			if(!empty($title_typo['font-weight'])){
				$content .= '.banner-pages .title{font-weight:'.esc_attr($title_typo['font-weight']).';}';
			}
			if(!empty($title_typo['text-transform'])){
				$content .= '.banner-pages .title{text-transform:'.esc_attr($title_typo['text-transform']).';}';
			}
			if(!empty($title_typo['font-size'])){
				$content_desktop .= '.banner-pages .title{font-size:'.esc_attr($title_typo['font-size']).';}';
			}
			
		}
		// brecrumb
		if(!empty($bc_typo)){
			if(!empty($bc_typo['color'])){
				$content .= '.banner-pages .breadcrumb-item .breadcrumb-link{color:'.esc_attr($bc_typo['color']).';}';
				$content .= '.banner-pages .breadcrumb-wrapper .breadcrumb > li + li:before{color:'.esc_attr($bc_typo['color']).';}';
			}
			if(!empty($bc_typo['font-weight'])){
				$content .= '.banner-pages .breadcrumb-item .breadcrumb-link{font-weight:'.esc_attr($bc_typo['font-weight']).';}';
			}
			if(!empty($bc_typo['text-transform'])){
				$content .= '.banner-pages .breadcrumb-item .breadcrumb-link{text-transform:'.esc_attr($bc_typo['text-transform']).';}';
			}
			if(!empty($bc_typo['font-size'])){
				$content_desktop .= '.banner-pages .breadcrumb-item .breadcrumb-link{font-size:'.$bc_typo['font-size'].';}';
			}
			
		}
		if(!empty($bc_typo2)){
			if(!empty($bc_typo2['color'])){
				$content .= '.banner-pages .breadcrumb-item .breadcrumb-active{color:'.esc_attr($bc_typo2['color']).';}';
			}
			if(!empty($bc_typo2['font-weight'])){
				$content .= '.banner-pages .breadcrumb-item .breadcrumb-active{font-weight:'.esc_attr($bc_typo2['font-weight']).';}';
			}
			if(!empty($bc_typo2['text-transform'])){
				$content .= '.banner-pages .breadcrumb-item .breadcrumb-active{text-transform:'.esc_attr($bc_typo2['text-transform']).';}';
			}
			if(!empty($bc_typo2['font-size'])){
				$content_desktop .= '.banner-pages .breadcrumb-item .breadcrumb-active{font-size:'.esc_attr($bc_typo2['font-size']).';}';
			}
		}
		
	}

	// Subcribe
	$subcribe_bg     = Buildplus::get_option('slz-footer-subcribe-bg');
	if( $subcribe_bg  ) {
			$bg_image = '';
			if( $subcribe_bg['background-image'] ) {
				$bg_image = 'background-image: url("' .esc_url($subcribe_bg['background-image']). '");';
			}
			$content .= '.subcribe-wrapper .banner-1{background-color: ' .esc_attr($subcribe_bg['background-color']). ';' . $bg_image . 'background-repeat: ' .esc_attr($subcribe_bg['background-repeat']). ';background-attachment: ' .esc_attr($subcribe_bg['background-attachment']). ';background-position:'.esc_attr($subcribe_bg['background-position']).';background-size:'.esc_attr($subcribe_bg['background-size']).';}';
		}

	/* Footer general*/
	$footer_show     = Buildplus::get_option('slz-footer');
	$footer_style    = Buildplus::get_option('slz-footer-style');
	$footer_mask     = Buildplus::get_option('slz-footer-mask');

	
	/*footer main*/
	$footer_bg       = Buildplus::get_option('slz-footer-bg');
	$footer_light_bg = Buildplus::get_option('slz-footer-light-bg');

	if(!empty($footer_mask)){
		if(isset($footer_mask['alpha'])){
			if(($footer_mask['alpha']) != '1'){
				$content .='.wrapper-footer:before {background-color:'.esc_attr($footer_mask['rgba']).' ;}';
			}else{
				$content .='.wrapper-footer:before {background-color:'.esc_attr($footer_mask['color']).' ;}';
			}
		}	
	}
	if ( $footer_style == 'dark' ) {
		if(!empty($footer_bg)){
			$footer_bg_image = '';
			if( $footer_bg['background-image'] ) {
				$footer_bg_image = 'background-image: url("' .esc_url($footer_bg['background-image']). '");';
			}
			if ( !empty($footer_bg['background-color']) || $footer_bg_image ) {
				$content .= '.wrapper-footer{background-color: ' .esc_attr($footer_bg['background-color']). ';' . $footer_bg_image . 'background-repeat: ' .esc_attr($footer_bg['background-repeat']). ';background-attachment: ' .esc_attr($footer_bg['background-attachment']). ';background-position:'.esc_attr($footer_bg['background-position']).';background-size:'.esc_attr($footer_bg['background-size']).';}';
			}
		}
	}else{
		if(!empty($footer_light_bg)){
			$footer_light_bg_image = '';
			if( $footer_light_bg['background-image'] ) {
				$footer_light_bg_image = 'background-image: url("' .esc_url($footer_light_bg['background-image']). '");';
			}
			if ( !empty($footer_light_bg['background-color']) || $footer_light_bg_image) {
				$content .= '.wrapper-footer{background-color: ' .esc_attr($footer_light_bg['background-color']). ';' . $footer_light_bg_image . 'background-repeat: ' .esc_attr($footer_light_bg['background-repeat']). ';background-attachment: ' .esc_attr($footer_light_bg['background-attachment']). ';background-position:'.esc_attr($footer_light_bg['background-position']).';background-size:'.esc_attr($footer_light_bg['background-size']).';}';
			}
		}
		
	}

	/* Blog Display */
	$commentbox        = Buildplus::get_option('slz-commentbox');
	
	if ( $commentbox == '0' ) {
		$content .= '.blog-detail .blog-detail-wrapper .comments{display:none;}';
	}
	// coming soon template
	$cms_bg = Buildplus::get_option('slz-cms-bg');
	$cms_mask = Buildplus::get_option('slz-cms-mask-color');
	$cms_title_cl      = Buildplus::get_option('slz-cms-bd-color');
	$cms_border_cl      = Buildplus::get_option('slz-cms-title-color');
	
	if(!empty($cms_bg)){
		$content .= '.page-coming-soon{background-image:url('.esc_url($cms_bg).');}';
	}
	if(!empty($cms_mask)){
		$content .= '.page-coming-soon .main-content{background-color:'.esc_url($cms_mask).';}';
	}
	if(!empty($cms_title_cl)){
		$content .= '.page-coming-soon .title-wrapper .title{color:'.$cms_title_cl.';}';
	}
	if(!empty($cms_border_cl)){
		$content .= '.page-coming-soon .title-wrapper:before{background-color:'.$cms_border_cl.';}';
	}

	// /* Typography */
	$body_typo      = Buildplus::get_option('slz-typo-body');
	$para_typo      = Buildplus::get_option('slz-typo-p');
	$h1_typo        = Buildplus::get_option('slz-typo-h1');
	$h2_typo        = Buildplus::get_option('slz-typo-h2');
	$h3_typo        = Buildplus::get_option('slz-typo-h3');
	$h4_typo        = Buildplus::get_option('slz-typo-h4');
	$h5_typo        = Buildplus::get_option('slz-typo-h5');
	$h6_typo        = Buildplus::get_option('slz-typo-h6');
	$text_selection = Buildplus::get_option('slz-typo-selection');
	$link_color     = Buildplus::get_option('slz-link-color');

	$body_typo_css = '';
	if( ! empty($body_typo) ){
		if ( $body_typo['font-family'] !== '' ) {
			$body_typo_css .= 'font-family:'.esc_attr($body_typo['font-family']).';';
		}
		if ( $body_typo['color'] !== '' ) {
			$body_typo_css .= 'color:'.esc_attr($body_typo['color']).';';
		}
		if ( $body_typo['font-size'] !== '' ) {
			$body_typo_css .= 'font-size:'.esc_attr($body_typo['font-size']).';';
		}
		if ( $body_typo['font-weight'] !== '' ) {
			$body_typo_css .= 'font-weight:'.esc_attr($body_typo['font-weight']).';';
		}
		if ( $body_typo['font-style'] !== '' ) {
			$body_typo_css .= 'font-style:'.esc_attr($body_typo['font-style']).';';
		}
		if ( $body_typo['text-align'] !== '' ) {
			$body_typo_css .= 'text-align:'.esc_attr($body_typo['text-align']).';';
		}
		if ( $body_typo['line-height'] !== '' ) {
			$body_typo_css .= 'line-height:'.esc_attr($body_typo['line-height']).';';
		}
	}
	$para_typo_css = '';
	if(!empty($para_typo)){
		if ( $para_typo['font-family'] !== '' ) {
			$para_typo_css .= 'font-family:'.esc_attr($para_typo['font-family']).';';
		}
		if ( $para_typo['color'] !== '' ) {
			$para_typo_css .= 'color:'.esc_attr($para_typo['color']).';';
		}
		if ( $para_typo['font-size'] !== '' ) {
			$para_typo_css .= 'font-size:'.esc_attr($para_typo['font-size']).';';
		}
		if ( $para_typo['font-weight'] !== '' ) {
			$para_typo_css .= 'font-weight:'.esc_attr($para_typo['font-weight']).';';
		}
		if ( $para_typo['font-style'] !== '' ) {
			$para_typo_css .= 'font-style:'.esc_attr($para_typo['font-style']).';';
		}
		if ( $para_typo['text-align'] !== '' ) {
			$para_typo_css .= 'text-align:'.esc_attr($para_typo['text-align']).';';
		}
		if ( $para_typo['line-height'] !== '' ) {
			$para_typo_css .= 'line-height:'.esc_attr($para_typo['line-height']).';';
		}
	}
	$h1_typo_css = '';
	if(!empty($h1_typo)){
		if ( $h1_typo['font-family'] !== '' ) {
			$h1_typo_css .= 'font-family:'.esc_attr($h1_typo['font-family']).';';
		}
		if ( $h1_typo['color'] !== '' ) {
			$h1_typo_css .= 'color:'.esc_attr($h1_typo['color']).';';
		}
		if ( $h1_typo['font-size'] !== '' ) {
			$h1_typo_css .= 'font-size:'.esc_attr($h1_typo['font-size']).';';
		}
		if ( $h1_typo['font-weight'] !== '' ) {
			$h1_typo_css .= 'font-weight:'.esc_attr($h1_typo['font-weight']).';';
		}
		if ( $h1_typo['font-style'] !== '' ) {
			$h1_typo_css .= 'font-style:'.esc_attr($h1_typo['font-style']).';';
		}
		if ( $h1_typo['text-align'] !== '' ) {
			$h1_typo_css .= 'text-align:'.esc_attr($h1_typo['text-align']).';';
		}
		if ( $h1_typo['line-height'] !== '' ) {
			$h1_typo_css .= 'line-height:'.esc_attr($h1_typo['line-height']).';';
		}
	}
	$h2_typo_css = '';
	if(!empty($h2_typo)){
		if ( $h2_typo['font-family'] !== '' ) {
			$h2_typo_css .= 'font-family:'.esc_attr($h2_typo['font-family']).';';
		}
		if ( $h2_typo['color'] !== '' ) {
			$h2_typo_css .= 'color:'.esc_attr($h2_typo['color']).';';
		}
		if ( $h2_typo['font-size'] !== '' ) {
			$h2_typo_css .= 'font-size:'.esc_attr($h2_typo['font-size']).';';
		}
		if ( $h2_typo['font-weight'] !== '' ) {
			$h2_typo_css .= 'font-weight:'.esc_attr($h2_typo['font-weight']).';';
		}
		if ( $h2_typo['font-style'] !== '' ) {
			$h2_typo_css .= 'font-style:'.esc_attr($h2_typo['font-style']).';';
		}
		if ( $h2_typo['text-align'] !== '' ) {
			$h2_typo_css .= 'text-align:'.esc_attr($h2_typo['text-align']).';';
		}
		if ( $h2_typo['line-height'] !== '' ) {
			$h2_typo_css .= 'line-height:'.esc_attr($h2_typo['line-height']).';';
		}
	}
	$h3_typo_css = '';
	if(!empty($h3_typo)){
		if ( $h3_typo['font-family'] !== '' ) {
			$h3_typo_css .= 'font-family:'.esc_attr($h3_typo['font-family']).';';
		}
		if ( $h3_typo['color'] !== '' ) {
			$h3_typo_css .= 'color:'.esc_attr($h3_typo['color']).';';
		}
		if ( $h3_typo['font-size'] !== '' ) {
			$h3_typo_css .= 'font-size:'.esc_attr($h3_typo['font-size']).';';
		}
		if ( $h3_typo['font-weight'] !== '' ) {
			$h3_typo_css .= 'font-weight:'.esc_attr($h3_typo['font-weight']).';';
		}
		if ( $h3_typo['font-style'] !== '' ) {
			$h3_typo_css .= 'font-style:'.esc_attr($h3_typo['font-style']).';';
		}
		if ( $h3_typo['text-align'] !== '' ) {
			$h3_typo_css .= 'text-align:'.esc_attr($h3_typo['text-align']).';';
		}
		if ( $h3_typo['line-height'] !== '' ) {
			$h3_typo_css .= 'line-height:'.esc_attr($h3_typo['line-height']).';';
		}
	}
	$h4_typo_css = '';
	if(!empty($h4_typo)){
		if ( $h4_typo['font-family'] !== '' ) {
			$h4_typo_css .= 'font-family:'.esc_attr($h4_typo['font-family']).';';
		}
		if ( $h4_typo['color'] !== '' ) {
			$h4_typo_css .= 'color:'.esc_attr($h4_typo['color']).';';
		}
		if ( $h4_typo['font-size'] !== '' ) {
			$h4_typo_css .= 'font-size:'.esc_attr($h4_typo['font-size']).';';
		}
		if ( $h4_typo['font-weight'] !== '' ) {
			$h4_typo_css .= 'font-weight:'.esc_attr($h4_typo['font-weight']).';';
		}
		if ( $h4_typo['font-style'] !== '' ) {
			$h4_typo_css .= 'font-style:'.esc_attr($h4_typo['font-style']).';';
		}
		if ( $h4_typo['text-align'] !== '' ) {
			$h4_typo_css .= 'text-align:'.esc_attr($h4_typo['text-align']).';';
		}
		if ( $h4_typo['line-height'] !== '' ) {
			$h4_typo_css .= 'line-height:'.esc_attr($h4_typo['line-height']).';';
		}
	}
	$h5_typo_css = '';
	if(!empty($h5_typo)){
		if ( $h5_typo['font-family'] !== '' ) {
			$h5_typo_css .= 'font-family:'.esc_attr($h5_typo['font-family']).';';
		}
		if ( $h5_typo['color'] !== '' ) {
			$h5_typo_css .= 'color:'.esc_attr($h5_typo['color']).';';
		}
		if ( $h5_typo['font-size'] !== '' ) {
			$h5_typo_css .= 'font-size:'.esc_attr($h5_typo['font-size']).';';
		}
		if ( $h5_typo['font-weight'] !== '' ) {
			$h5_typo_css .= 'font-weight:'.esc_attr($h5_typo['font-weight']).';';
		}
		if ( $h5_typo['font-style'] !== '' ) {
			$h5_typo_css .= 'font-style:'.esc_attr($h5_typo['font-style']).';';
		}
		if ( $h5_typo['text-align'] !== '' ) {
			$h5_typo_css .= 'text-align:'.esc_attr($h5_typo['text-align']).';';
		}
		if ( $h5_typo['line-height'] !== '' ) {
			$h5_typo_css .= 'line-height:'.esc_attr($h5_typo['line-height']).';';
		}
	}
	$h6_typo_css = '';
	if(!empty($h6_typo)){
		if ( $h6_typo['font-family'] !== '' ) {
			$h6_typo_css .= 'font-family:'.esc_attr($h6_typo['font-family']).';';
		}
		if ( $h6_typo['color'] !== '' ) {
			$h6_typo_css .= 'color:'.esc_attr($h6_typo['color']).';';
		}
		if ( $h6_typo['font-size'] !== '' ) {
			$h6_typo_css .= 'font-size:'.esc_attr($h6_typo['font-size']).';';
		}
		if ( $h6_typo['font-weight'] !== '' ) {
			$h6_typo_css .= 'font-weight:'.esc_attr($h6_typo['font-weight']).';';
		}
		if ( $h6_typo['font-style'] !== '' ) {
			$h6_typo_css .= 'font-style:'.esc_attr($h6_typo['font-style']).';';
		}
		if ( $h6_typo['text-align'] !== '' ) {
			$h6_typo_css .= 'text-align:'.esc_attr($h6_typo['text-align']).';';
		}
		if ( $h6_typo['line-height'] !== '' ) {
			$h6_typo_css .= 'line-height:'.esc_attr($h6_typo['line-height']).';';
		}
	}
	
	if(!empty($body_typo_css)){
		$content .= 'body{'.$body_typo_css.'}';
	}
	if($para_typo_css){
		$content .= 'p{'.$para_typo_css.'}';
	}
	if($h1_typo_css){
		$content .= 'h1{'.$h1_typo_css.'}';
	}
	if($h2_typo_css){
		$content .= 'h2{'.$h2_typo_css.'}';
	}
	if($h3_typo_css){
		$content .= 'h3{'.$h3_typo_css.'}';
	}
	if($h4_typo_css){
		$content .= 'h4{'.$h4_typo_css.'}';
	}
	if($h5_typo_css){
		$content .= 'h5{'.$h5_typo_css.'}';
	}
	if($h6_typo_css){
		$content .= 'h6{'.$h6_typo_css.'}';
	}
	

	if ( !empty($link_color) ) {
		$content .= 'a{color:'.esc_attr($link_color['regular']).'}';
		$content .= 'a:hover{color:'.esc_attr($link_color['hover']).'}';
		$content .= 'a:active{color:'.esc_attr($link_color['active']).'}';
	}

	// /* End of dynamic CSS */
	echo "<!-- Start Dynamic Styling -->\n<style type=\"text/css\">\n@media screen {" . $content . "}</style> <!-- End Dynamic Styling -->\n";
	echo "<!-- Start Dynamic Styling only for desktop -->\n<style type=\"text/css\">\n@media screen and (min-width: 769px) {" . $content_desktop . "}</style> <!-- End Dynamic Styling only for desktop -->\n";

	/* Custom CSS */
	$custom_css = Buildplus::get_option('slz-custom-css');

	if ($custom_css != '') {
		echo "<!-- Custom Styling -->\n<style type=\"text/css\">\n" . esc_html( $custom_css ) . "</style>\n";
	}

	/* Custom JS */
	$custom_js = Buildplus::get_option('slz-custom-js');

	if ($custom_js != '') {
		echo "<!-- Custom JS -->\n<script type=\"text/javascript\">\n" . $custom_js . "</script>\n";
	}
	

}

add_action('wp_head', 'buildplus_dynamic_css');

/*
 * Extras Options Not use CSS
 */

/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array (Maybe) filtered body classes.
 */
if ( get_option('buildplus_options') ) {
	function buildplus_sticky_class( $classes ) {
		if ( Buildplus::get_option('slz-sticky') == '1') {
			$classes[] = 'sticky-enable';
		}
		return $classes;
	}
	add_filter( 'body_class', 'buildplus_sticky_class' );
}

/* Custom Styles to WordPress Visual Editor */
function buildplus_mce_buttons_2($buttons) {
	array_unshift($buttons, 'styleselect');
	return $buttons;
}
add_filter('mce_buttons_2', 'buildplus_mce_buttons_2');

// Callback function to filter the MCE settings
function buildplus_mce_before_init_insert_formats( $init_array ) {
	$init_array['style_formats'] = json_encode( Buildplus_Params::get('style_formats') );
	return $init_array;
}
// Attach callback to 'tiny_mce_before_init'
add_filter( 'tiny_mce_before_init', 'buildplus_mce_before_init_insert_formats' );

/* add editor style */
function buildplus_add_editor_styles() {
	add_editor_style( get_template_directory_uri() . '/assets/public/css/buildplus-custom-editor.css' );
	add_editor_style( get_template_directory_uri() . '/assets/public/libs/bootstrap/css/bootstrap.min.css' );
	add_editor_style( get_template_directory_uri() . '/assets/public/font/font-icon/font-awesome/css/font-awesome.min.css' );
}
add_action( 'init', 'buildplus_add_editor_styles' );

/* Custom comment_reply_link */
function buildplus_comment_reply($link, $args, $comment) {
	$reply_link_text = $args['reply_text'];
	$link = str_replace($reply_link_text, '<i class="fa fa-reply"></i>' . esc_html__('Reply', 'buildplus'), $link);
	$link = str_replace("class='comment-reply-link", "class='meta-info reply ", $link);
	return $link;
}
add_filter('comment_reply_link', 'buildplus_comment_reply', 10, 3);

// change default avatar
add_filter( 'get_avatar' , 'buildplus_custom_avatar' , get_current_user_id(), 5 );
function buildplus_custom_avatar( $avatar, $user_id, $size, $default, $alt ) {
	$avatar_url = '';
	$avatar_id = get_user_meta($user_id, 'profile_image_id', true);
	if( $avatar_id ) {
		$avatar_url = wp_get_attachment_url( $avatar_id );
	}
	else {
		$avatar_url = get_avatar_url( $user_id );
	}
	$avatar = "<img alt='{}' src='{$avatar_url}' class='avatar avatar-{$size} photo' height='{$size}' width='{$size}'/>";
	return $avatar;
}