<?php
// css to show/hide sidebar.
$buildplus_container_css = buildplus_get_container_css();
get_header();
?>
<div class="content-session content-team-member padding-top-100 padding-bottom-100">
	<div class="<?php echo esc_attr( $buildplus_container_css['container_css'] ); ?>">
		<div class="row">
			<div id="page-content" class="detail-contact-info main-detail <?php echo esc_attr( $buildplus_container_css['content_css'] ); ?>">
				<div <?php post_class(); ?> >
					<?php if ( have_posts() ) :
							while ( have_posts() ) : the_post();?>
								<!-- header -->
								<?php if( has_action('buildplus_core_team_about') ){
									do_action('buildplus_core_team_about');
								}?>
								<div class="row team-content paragraph">
									<!-- content -->
									<div class="detail-content entry-content">
										<?php
											the_content( sprintf( '<a href="%s" class="read-more">%s<i class="fa fa-angle-right"></i></a>',
													esc_url(get_permalink()),
													esc_html__( 'Read more', 'buildplus' )
											) );
											wp_link_pages( array( 'before' => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'buildplus' ) . '</span>', 'after' => '</div>', 'link_before' => '<span>', 'link_after' => '</span>' ) );
										?>
									</div>
								</div>
								<?php
							endwhile;
						else:
							get_template_part( 'inc/content', 'none' );
						endif;
					?>
				</div>
			</div>
			<?php if ( $buildplus_container_css['has_sidebar'] != 'none' ) :?>
				<div id='page-sidebar' class="sidebar <?php echo esc_attr( $buildplus_container_css['sidebar_css'] )?>">
					<?php buildplus_get_sidebar($buildplus_container_css['sidebar_id']);?>
				</div>
			<?php endif;?>
		</div>
	</div>
</div>
<?php get_footer(); ?>