<?php
/**
 * Template Name: SLZ Coming Soon Template
 * 
 * @author Swlabs
 * @package BuildPlus
 * @since 1.0
 */
get_header();
?>

<!-- Content section -->
<div class="page-wrapper page-coming-soon">
	<div class="container">
		<div class="content-wrapper">
			<div class="header-main">
				<?php if( $buildplus_logo = buildplus_comming_soon_options('slz-cms-logo') ){?>
					<div class="logo-wrapper">
						<a href="<?php echo esc_url(site_url()); ?>" class="logo"> <img src="<?php echo esc_url($buildplus_logo)?>" alt="" class="img-responsive"></a>
					</div>
				<?php } ?>
				<?php if( $buildplus_title = buildplus_comming_soon_options('slz-cms-title') ){?>
					<div class="title-wrapper">
						<h1 class="title"><a href="<?php echo esc_url(site_url()); ?>"><?php echo esc_attr($buildplus_title)?></a></h1>
					</div>
				<?php }?>
				<div class="clearfix"></div>
			</div>
			<?php while ( have_posts() ) : the_post(); ?>
			<div class="main-content padding-top-100 padding-bottom-100">
				<?php if( $buildplus_des = buildplus_comming_soon_options('slz-cms-des') ){?>
					<div class="content-left">
                   		<div class="description"><?php echo esc_textarea($buildplus_des);?></div>
                	</div>
				<?php }
                ?>
                <div class="content-right">
                	<?php
                	$date = buildplus_comming_soon_options('slz-cms-date');
                	if(!empty($date)){
                		echo do_shortcode('[slzcore_count_down_sc date="'.esc_attr($date).'"]');
                	}
                    if($cms_newsletter = buildplus_comming_soon_options('slz-cms-newsletter') == 1){
                    	echo do_shortcode('[slzcore_newsletter_widget_sc input_name_placeholder=""]');
                    }
                    ?>
                </div>
            </div>
			<?php endwhile; // End of the loop. ?>
		</div>
	</div>
</div>
<!-- #section -->
<?php get_footer('none'); ?>