<?php
$style = array(
	esc_html__('Style 01', 'slz-core') => '1',
	esc_html__('Style 02', 'slz-core') => '2',
	esc_html__('Style 03', 'slz-core') => '3',
	esc_html__('Style 04', 'slz-core') => '4',
);
$columns = Buildplus_Core_Params::get('block_column');
$icon_type      = Buildplus_Core_Params::get('icon_type');
$icon_flat      = Buildplus_Core_Params::get('font_flaticon');
$admin_icon_url = '<a href="'.esc_url(admin_url( 'admin.php?page='.BUILDPLUS_CORE_THEME_PREFIX.'_icon' )).'" target="_blank">'.esc_html__('Buildplus Icons','slz-core').'</a>';
$icon_link = sprintf(esc_html__( 'Please go on %1$s to reference about icons of our theme.', 'slz-core' ), $admin_icon_url);
$params = array(
	array(
		'type'            => 'dropdown',
		'heading'         => esc_html__( 'Style', 'slz-core' ),
		'param_name'      => 'style',
		'value'           => $style,
		'description'     => esc_html__( 'Choose style to display.', 'slz-core' )
	),
	array(
		'type'            => 'dropdown',
		'heading'         => esc_html__( 'Columns', 'slz-core' ),
		'param_name'      => 'columns',
		'value'           => $columns,
		'description'     => esc_html__( 'Set the number of columns per row.', 'slz-core' )
	),
	array(
		'type'            => 'checkbox',
		'heading'         => esc_html__( 'Show Slider ?', 'slz-core' ),
		'param_name'      => 'show_slider',
		'value'           => array( esc_html__( 'Yes', 'slz-core' ) => 'yes' ),
		'description'     => esc_html__( 'Check it to show slider.', 'slz-core' ),
	),
	array(
		'type'            => 'checkbox',
		'heading'         => esc_html__( 'Disable Box Shadow?', 'slz-core' ),
		'param_name'      => 'disable_box_shadow',
		'value'           => array( esc_html__( 'Yes', 'slz-core' ) => 'yes' ),
		'dependency'      => array(
			'element'     => 'style',
			'value'       => array('1', '')),
		'description'     => esc_html__( 'Check it to disable box shadow when hover on each item.', 'slz-core' ),
	),
	array(
		'type'           => 'attach_image',
		'heading'        => esc_html__( 'Background Image', 'slz-core' ),
		'param_name'     => 'bg_image',
		'dependency'      => array(
			'element'     => 'style',
			'value'       => array('2')),
		'description'    => esc_html__( 'Choose background image to block.', 'slz-core' ),
	),
	array(
		'type'            => 'param_group',
		'heading'         => esc_html__( 'Add Item', 'slz-core' ),
		'param_name'      => 'group_list',
		'params'          => array(
			array(
				'type'            => 'textfield',
				'holder'          => 'div',
				'admin_label'     => true,
				'heading'         => esc_html__( 'Title', 'slz-core' ),
				'param_name'      => 'title',
				'value'           => '',
				'description'     => esc_html__( 'Enter title.', 'slz-core' )
			),
			array(
				'type'        => 'textarea',
				'heading'     => esc_html__( 'Description', 'slz-core' ),
				'param_name'  => 'description',
				'value'       => '',
				'description' => esc_html__( 'Enter description of item', 'slz-core' )
			),
			array(
				'type'            => 'dropdown',
				'heading'         => esc_html__( 'Choose Type of Icon', 'slz-core' ),
				'param_name'      => 'icon_type',
				'value'           => $icon_type,
				'description'     => esc_html__( 'Choose kind of icon to display.', 'slz-core' )
			),
			array(
				'type'            => 'iconpicker',
				'heading'         => esc_html__( 'Choose Icon', 'slz-core' ),
				'param_name'      => 'icon_fw',
				'dependency'      => array(
					'element'     => 'icon_type',
					'value'       => array('02')),
				'description'     => esc_html__( 'Choose icon to display in box.', 'slz-core' )
			),
			array(
				'type'            => 'dropdown',
				'heading'         => esc_html__( 'Choose Icon', 'slz-core' ),
				'param_name'      => 'icon_flat',
				'value'           => $icon_flat,
				'dependency'      => array(
					'element'     => 'icon_type',
					'value'       => array('')),
				'description'     => $icon_link,
			),
			array(
				'type'        => 'vc_link',
				'heading'     => esc_html__( 'URL (Link)', 'slz-core' ),
				'param_name'  => 'url',
				'value'       => '',
				'description' => esc_html__( 'Add link for block.', 'slz-core' ),
			),
		),
		'value'       => '',
		'group'           => esc_html__( 'Setting Data', 'slz-core')
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Icon Color', 'slz-core' ),
		'param_name'      => 'icon_color',
		'value'           => '',
		'description'     => esc_html__( 'Select color for icon.', 'slz-core' ),
		'group'           => esc_html__( 'Custom Color', 'slz-core')
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Icon Hover Color', 'slz-core' ),
		'param_name'      => 'icon_hv_color',
		'value'           => '',
		'dependency'      => array(
			'element'     => 'style',
			'value'       => array('1')),
		'description'     => esc_html__( 'Select hover color for icon.', 'slz-core' ),
		'group'           => esc_html__( 'Custom Color', 'slz-core')
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Icon Background Color', 'slz-core' ),
		'param_name'      => 'icon_bg_color',
		'value'           => '',
		'dependency'      => array(
			'element'     => 'style',
			'value'       => array('1')),
		'description'     => esc_html__( 'Select background color for icon.', 'slz-core' ),
		'group'           => esc_html__( 'Custom Color', 'slz-core')
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Icon Background Hover Color', 'slz-core' ),
		'param_name'      => 'icon_bg_hv_color',
		'value'           => '',
		'dependency'      => array(
			'element'     => 'style',
			'value'       => array('1')),
		'description'     => esc_html__( 'Select background hover color for icon.', 'slz-core' ),
		'group'           => esc_html__( 'Custom Color', 'slz-core')
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Icon Border Color', 'slz-core' ),
		'param_name'      => 'icon_border_color',
		'value'           => '',
		'dependency'      => array(
			'element'     => 'style',
			'value'       => array('2', '3')),
		'description'     => esc_html__( 'Select border color for icon.', 'slz-core' ),
		'group'           => esc_html__( 'Custom Color', 'slz-core')
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Title Color', 'slz-core' ),
		'param_name'      => 'title_color',
		'value'           => '',
		'description'     => esc_html__( 'Select color for title.', 'slz-core' ),
		'group'           => esc_html__( 'Custom Color', 'slz-core')
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Title Hover Color', 'slz-core' ),
		'param_name'      => 'title_hv_color',
		'value'           => '',
		'dependency'      => array(
			'element'     => 'style',
			'value'       => array('1')),
		'description'     => esc_html__( 'Select hover color for title.', 'slz-core' ),
		'group'           => esc_html__( 'Custom Color', 'slz-core')
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Description Color', 'slz-core' ),
		'param_name'      => 'des_color',
		'value'           => '',
		'description'     => esc_html__( 'Select color for description.', 'slz-core' ),
		'group'           => esc_html__( 'Custom Color', 'slz-core')
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Item Background Color', 'slz-core' ),
		'param_name'      => 'item_bg_color',
		'value'           => '',
		'dependency'      => array(
			'element'     => 'style',
			'value'       => array('4')),
		'description'     => esc_html__( 'Select background color for block.', 'slz-core' ),
		'group'           => esc_html__( 'Custom Color', 'slz-core')
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Item Background Hover Color', 'slz-core' ),
		'param_name'      => 'item_bg_hv_color',
		'value'           => '',
		'description'     => esc_html__( 'Select background color for block when hover.', 'slz-core' ),
		'dependency'      => array(
			'element'     => 'style',
			'value'       => array('4')),
		'group'           => esc_html__( 'Custom Color', 'slz-core')
	),
	array(
		'type'            => 'textfield',
		'heading'         => esc_html__( 'Extra Class', 'slz-core' ),
		'param_name'      => 'extra_class',
		'value'           => '',
		'description'     => esc_html__( 'Enter extra class name.', 'slz-core' )
	)
);

vc_map(
	array(
		'name'        => esc_html__( 'SLZ Icon Box', 'slz-core' ),
		'base'        => 'slzcore_icon_box_sc',
		'class'       => 'slzcore-sc',
		'category'    => BUILDPLUS_CORE_SC_CATEGORY,
		'icon'        => 'icon-slzcore_icon_box_sc',
		'description' => esc_html__( 'Add icon box with custom options.', 'slz-core' ),
		'params'      => $params
	)
);
