<?php
$yesno = array(
	esc_html__( 'Yes', 'slz-core' ) => 'yes',
	esc_html__( 'No', 'slz-core' )  => 'no',
);
$params = array(
	array(
		'type'          => 'textfield',
		'heading'       => esc_html__( 'Title', 'slz-core' ),
		'value'			=> '',
		'param_name'    => 'title',
		'description'   => esc_html__( 'Enter block title', 'slz-core' ),
	),
	array(
		'type'          => 'textarea',
		'heading'       => esc_html__( 'Description', 'slz-core' ),
		'value'			=> '',
		'param_name'    => 'description',
		'description'   => esc_html__( 'Enter block description', 'slz-core' ),
	),
	array(
		'type'        	=> 'dropdown',
		'heading'     	=> esc_html__( 'Show Input Name', 'slz-core' ),
		'admin_label'	=> true,
		'param_name'  	=> 'show_name',
		'value'       	=> $yesno,
		'std'           => 'yes',
		'description' 	=> esc_html__( 'Choose show or hide input name.', 'slz-core' )
	),
	array(
		'type'          => 'textfield',
		'heading'       => esc_html__( 'Name Input Place Holder', 'slz-core' ),
		'value'			=> esc_html( 'FullName', 'slz-core' ),
		'param_name'    => 'input_name_placeholder',
		'description'   => esc_html__( 'Enter place holder for input', 'slz-core' ),
		'dependency'     => array(
			'element'  => 'show_name',
			'value'    => array( 'yes', '' ),
		),
	),
	array(
		'type'          => 'textfield',
		'heading'       => esc_html__( 'Email Input Place Holder', 'slz-core' ),
		'value'			=> esc_html( 'Email Address', 'slz-core' ),
		'param_name'    => 'input_email_placeholder',
		'description'   => esc_html__( 'Enter place holder for input', 'slz-core' ),
	),
	array(
		'type'          => 'textfield',
		'heading'       => esc_html__( 'Text Button Submit', 'slz-core' ),
		'value'			=> esc_html( 'Get Notified', 'slz-core' ),
		'param_name'    => 'button_text',
		'description'   => esc_html__( 'Enter text for button submit.', 'slz-core' ),
	),
	array(
		'type'          => 'textfield',
		'heading'       => esc_html__( 'Extra Class', 'slz-core' ),
		'param_name'    => 'extra_class',
		'description'   => esc_html__( 'Enter extra class name.', 'slz-core' ),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Input Text Color', 'slz-core' ),
		'param_name'      => 'color_input',
		'description'     => esc_html__( 'Choose color for input text.', 'slz-core' ),
		'group'           => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Input Border Color', 'slz-core' ),
		'param_name'      => 'color_input_border',
		'description'     => esc_html__( 'Choose color for input border.', 'slz-core' ),
		'group'           => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Input Border Color Focus', 'slz-core' ),
		'param_name'      => 'color_input_border_fc',
		'description'     => esc_html__( 'Choose color for input border when focus.', 'slz-core' ),
		'group'           => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Button Text Color', 'slz-core' ),
		'param_name'      => 'color_button',
		'description'     => esc_html__( 'Choose color for button.', 'slz-core' ),
		'group'           => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Button Text Color Hover', 'slz-core' ),
		'param_name'      => 'color_button_hv',
		'description'     => esc_html__( 'Choose color for button when hover.', 'slz-core' ),
		'group'           => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Button Background Color', 'slz-core' ),
		'param_name'      => 'color_button_bg',
		'description'     => esc_html__( 'Choose background color for button.', 'slz-core' ),
		'group'           => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Button Background Color Hover', 'slz-core' ),
		'param_name'      => 'color_button_bg_hv',
		'description'     => esc_html__( 'Choose background color for button when hover.', 'slz-core' ),
		'group'           => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Button Border Color', 'slz-core' ),
		'param_name'      => 'color_button_border',
		'description'     => esc_html__( 'Choose border color for button.', 'slz-core' ),
		'group'           => esc_html__('Custom', 'slz-core'),
	),
	array(
		'type'            => 'colorpicker',
		'heading'         => esc_html__( 'Button Border Color Hover', 'slz-core' ),
		'param_name'      => 'color_button_border_hv',
		'description'     => esc_html__( 'Choose border color for button when hover.', 'slz-core' ),
		'group'           => esc_html__('Custom', 'slz-core'),
	),
);
vc_map(array(
	'name'               => esc_html__( 'SLZ Newsletter', 'slz-core' ),
	'base'               => 'slzcore_newsletter_widget_sc',
	'class'              => 'slzcore-sc',
	'icon'               => 'icon-slzcore',
	'category'           => BUILDPLUS_CORE_SC_CATEGORY,
	'description'        => esc_html__( 'Newsletter', 'slz-core' ),
	'params'             => $params
));