<?php
Buildplus_Core::load_class( 'models.Pricing_Model' );
class Buildplus_Core_Pricing_Table extends Buildplus_Core_Pricing_Model {
	
	private $active_column;
	public $uniq_id;
	public $post_class;
	
	public function __construct() {
		$this->post_type = 'buildplus_pricing';
	}
	public function shortcode_atts( $atts = array() ){
		$default = array(
			'pricing_slug'      => '',
			'btn_content'       => esc_html__( 'Get Start', 'slz-core'),
			'contact_form'      => '',
			'extra_class'       => '',
			'action_link'       => '',
			'custom_link'       => '',
			'title_color'       => '',
			'subtitle_color'    => '',
			'icon_color'        => '',
			'feature_color'     => '',
			'price_color'       => '',
			'button_transparent'  => '',
			'button_color'        => '',
			'button_border_color' => '',
			'button_hover_color'  => '',
			'currency_sign'       => '$',
			'currency_sign_pos'   => '',
			'block_color'         => '',
		);
		$data = Buildplus_Core::set_shortcode_defaults( $default, $atts);
		return $data;
	}

	public function init( $atts = array(), $is_single = true ) {
		$defaults = array(
			'layout'       => '',
			'pricing_slug' => '',
			'btn_link'     => '#',
			'btn_content'  => '',
			'frm_order'    => '',
			'extra_class'  => '',
			'columns'      => '',
			'responsive_class'    => '',
			'title_color'         => '',
			'subtitle_color'    => '',
			'icon_color'        => '',
			'feature_color'     => '',
			'price_color'         => '',
			'button_transparent'  => '',
			'button_color'        => '',
			'button_border_color' => '',
			'button_hover_color'  => '',
			'currency_sign'       => '$',
			'currency_sign_pos'   => '',
			'block_color'         => '',
		);
		$atts = array_merge( $defaults, $atts );
		$this->pricing_atts = $atts;
		$query_args = array();
		if( ! empty( $atts['pricing_slug'] ) ) {
			$query_args['name'] = $atts['pricing_slug'];
		}
		if( $is_single ) {
			$query_args['posts_per_page'] = 1;
		}
		$this->get_pricing_posts( $query_args );
		
		if( $this->pricing_posts && $is_single ) {
			$this->cur_post = $this->pricing_posts[0];
			$this->cur_post_id = $this->cur_post->ID;
			$this->pricing_table = get_post_meta( $this->cur_post_id, $this->post_type . '_meta_table', true );
			$this->max_feature_item = get_post_meta( $this->cur_post_id, $this->post_type . '_feature_count', true );
			$this->pricing_atts['columns'] = count( $this->pricing_table );
			$this->get_responsive_class();
		}
		$this->active_column = false;
		$this->uniq_id = 'pricing-' . Buildplus_Core::make_id();
		$this->post_class = $this->get_post_class( $this->uniq_id );
	}
	public function get_responsive_class() {
		//col-md-3 col-sm-6 col-xs-6
		$class = '';
		$column = $this->pricing_atts['columns'];
		if( isset($atts['res_class']) ) {
			$class = $atts['res_class'];
		}
		$def = array(
			'1' => 'col-md-12',
			'2' => 'col-md-6 col-sm-6 col-xs-6',
			'3' => 'col-md-4 col-sm-6 col-xs-6',
			'4' => 'col-md-3 col-sm-6 col-xs-6',
		);;
		
		if( $column && isset($def[$column])) {
			$this->pricing_atts['responsive_class'] = $def[$column];
		} else {
			$this->pricing_atts['responsive_class'] = $def['1'];
		}
	}
	public function get_block_class() {
		$class = '';
		$column = absint($this->pricing_atts['columns']);
		if( $column > 0 ) {
			$class = 'column-' . $column;
		}
		return $class;
	}
	/**
	 * Render html.
	 *
	 * @param array $html_options      Format: 1$ - title, 2$ - price, 3$ - subtitle, 4$ - feature list, 5$ - button,
	 *                                         6$ - main active, 7$ - responsive_class, 8$ - json data
	 */
	public function render_sc( $html_options = array() ) {
		$pricing_cols = array();
		$custom_css = '';
		$count = 1;
		$this->html_options = $this->set_html_options($html_options);
		if( $this->pricing_table ) {
			foreach( $this->pricing_table as $col ) {
				$meta = $this->get_meta_column( $col );
				$active = Buildplus_Core::get_value( $meta, 'active_column' );
				$active_class = '';
				if( ! empty( $active ) && isset( $html_options['active_class'] ) ) {
					$this->active_column = true;
					$active_class = $html_options['active_class'];
				}
				$pricing_class = 'pricing-' . str_pad($count, 2, '0', STR_PAD_LEFT );
				$active_class .= ' '.$pricing_class;
				printf( $html_options['html_format'],
						$this->get_title( $meta ),
						$this->get_price( $meta ),
						$this->get_subtitle( $meta ),
						$this->get_icon( $meta ),
						$this->get_feature_list( $meta ),
						$this->get_button( $meta ),
						$active_class,
						$this->get_meta_data( $meta )
						);
				$count++;
				$pricing_class = $this->uniq_id . ' .' . $pricing_class;
				$custom_css[] = $this->parse_custom_css_by_item( $pricing_class, $meta );
			}
		}
		$block_css = $this->parse_custom_css();
		if( $custom_css ) {
			$custom_css = implode('', $custom_css);
		}
		if( $block_css ) {
			$custom_css = $custom_css . $block_css;
		}
		if( $custom_css ) {
			apply_filters( BUILDPLUS_CORE_ADD_INLINE_CSS, $custom_css );
		}
	}

	public function get_meta_data( $meta = array() ){
		$output = '';
		$format = '<a href="" data-meta="%s" class="hide pricing_meta_data"></a>';
		$contact_form = $this->pricing_atts['contact_form'];
		if( BUILDPLUS_CORE_WPCF7_ACTIVE && !empty( $contact_form ) ) {
			$shortcode = do_shortcode('[contact-form-7 id="'.$contact_form.'" title=""]');
			$output .= sprintf('<div class="pricing-contact-form-hidden hide"><h3 class="underline">%1$s</h3>%2$s</div>',
					esc_html__('CONTACT US', 'slz-core'),
					$shortcode
				);
		}
		$output .= sprintf( $format, esc_attr(json_encode( $meta )) );
		return $output;
	}

	private function parse_custom_css_by_item ( $pricing_class, $meta ) {
		$color = Buildplus_Core::get_value( $meta, 'header_color' );
		$css = '';
		if( $color ) {
			$css .= ".{$pricing_class} .main-plan .pricing-icon{color:%s}\n";
		}
		if( $css ) {
			$css = sprintf( $css, esc_attr($color) );
		}
		return $css;
	}
	private function parse_custom_css () {
		$css = '';
		extract($this->pricing_atts);
		if( !empty($title_color) ) {
			$css .= '.%1$s .package-content .title{color:%2$s}'."\n";
		}
		if( !empty($icon_color) ) {
			$css .= '.%1$s .package-content .pricing-icon{color:%3$s}'."\n";
		}
		if( !empty($button_transparent) ) {
			$css .= '.%1$s .package-content .btn{ background-color: transparent;}'."\n";
		} else if( !empty($button_color)) {
			$css .= '.%1$s .package-content .btn{ background-color: %4$s;}'."\n";
		}
		if( !empty($button_border_color) ) {
			$css .= '.%1$s .package-content .btn{ border-color: %5$s;}'."\n";
		}
		if( !empty($button_hover_color) ) {
			$css .= '.%1$s .package-content:hover .btn{ background-color: %6$s;border-color: %6$s;border-bottom-color: %6$s;}'."\n";
			$css .= '.%1$s .package-content:hover { border-color: %6$s;border-bottom-color: %6$s;}'."\n";
		}
		if( !empty($price_color) ) {
			$css .= '.%1$s .package-content .price{color:%7$s}'."\n";
		}
		if( !empty($block_color) ) {
			$css .= '.%1$s '. sprintf('.package-content {background-color:%s}', esc_attr($block_color) ) . "\n";
		}
		if( !empty($subtitle_color) ) {
			$css .= '.%1$s '. sprintf('.package-content .sub-title {color:%s}', esc_attr($subtitle_color) ) . "\n";
		}
		if( !empty($feature_color) ) {
			$css .= '.%1$s '. sprintf('.package-content .description {color:%s}', esc_attr($feature_color) ) . "\n";
		}
		if( $css ) {
			$css = sprintf( $css,
					esc_attr($this->uniq_id),
					esc_attr($title_color),
					esc_attr($icon_color),
					esc_attr($button_color),
					esc_attr($button_border_color),
					esc_attr($button_hover_color),
					esc_attr($price_color)
			);
		}
		return $css;
	}
	public function set_html_options( $html_options = array() ) {
		$defaults = array(
			'title_before'   => '<div class="title">',
			'title_after'    => '</div>',
			'subtitle_before' => '<div class="sub-title">',
			'subtitle_after' => '</div>',
			'price_format'   => '<div class="price">%1$s<span class="per">%2$s</span></div>',
			'sign_format'    => '<sup class="unit">%1$s</sup>',
			'icon_format'    => '<i class="pricing-icon %1$s"></i>',
			'feature_format' => '<p>%1$s</p>',
			'feature_sep'    => '',
			'button_format'  => '<a href="%1$s" class="btn">%2$s</a>',
			'container'      => '%1$s',
		);
		$html_options = array_merge( $defaults, $html_options );
		return $html_options;
	}
}