<?php
$model = new BuildPlus_Core_Project();
$model->init( $atts );
$uniq_id = $model->attributes['uniq_id'];
$block_cls = $model->attributes['extra_class'] . ' ' . $uniq_id;
$style = !empty($model->attributes['style']) ? $model->attributes['style'] : 'grid';
$column = !empty($model->attributes['column']) ? $model->attributes['column'] : '2';

$classRowBegin = $classRowEnd = '';
$classInlineBlock = 'inline_block';
$slick_json = $model->get_atts_option_slick_slide();

if ( $style == 'slide' ) {
	$classRowBegin = '<div class="project_slide_slick slide-block" data-slick-json="'.esc_attr($slick_json).'">';
	$classRowEnd = '</div>';
	$classInlineBlock = '';
}

if ( !empty($model->attributes['show_thumbnail']) && $model->attributes['show_thumbnail'] != 'yes') {
	$classWidth100 = 'width-100';
}

// 1$ - image, 2$ - title, 3$ - description, 4$ - permalink, 5$ - post_id, 6$ - process, 7$ - responsive class
$html_format = '
	<div class="item project_%5$s '.$classInlineBlock.'">
		<div class="block-2">
			%1$s
			<div class="block-content">
				%6$s
				<a href="%4$s" class="title">%2$s</a>
				%3$s
				<a href="%4$s" class="readmore-icons"><i class="icons fa fa-plus"></i></a>
			</div>
		</div>
	</div>
';
$html_render = array(
	'html_format' 		=> $html_format,
	'excerpt_format' 	=> '<div class="description"><div class="text">%1$s</div></div>',
	'thumb_class' 		=> 'img-full',
	'image_format'		=> '<div class="block-image">%1$s<a href="%2$s" class="link"></a></div>'
);
?>
<div class="slz-shortcode sc_project_list <?php echo esc_attr( $block_cls ); ?>" data-item="<?php echo esc_attr($uniq_id); ?>">
	<div class="list-block column-<?php echo esc_attr( $column ); ?>">		
		<?php
		echo ($classRowBegin);
		$model->render_project_list_sc( $html_render ); 
		echo ($classRowEnd);?>
	</div>
</div>