<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\User;
use Illuminate\Support\Facades\Hash;



class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        return view('home');
    }
    public function users()
    {
        $users =User::get();
        return view('users.index',compact('users'));
    }
    public function create()
    {
        return view('users.create');
    }
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'business_name' => 'required',
            'email' => 'required|unique:users',
            'password' => 'required',
        ]);
        
        $data=$request->all();
        $data['password']=Hash::make($request->password);
        $data['valid_upto']=date('Y-m-d', strtotime('+7 days'));
        User::create($data);

        return redirect('users')->with('success','User Created Successfully.');
    }
      public function view(Request $request)
    {
        $user=User::find($request->id);
        return view('users.view',compact('user'));
    }
      public function edit(Request $request)
    {
        $user=User::find($request->id);
        return view('users.edit',compact('user'));
    }
      public function update(Request $request,$id)
    {
        $validate= $request->validate([
            'name' => 'required',
            'business_name' => 'required',
            'email' => 'required|unique:users,email,'.$id,
            'password' => 'nullable', 
        ]);
        $data=$validate;
        $data['valid_upto']=$request->valid_upto;
        if ($data['password'] != null) {
            $data['password'] = Hash::make($data['password']);
        } else {
            unset($data['password']);
        }
        $user=User::find($id);
        $user->update($data);


         return redirect('users')->with('success','User Updated Successfully.');
    }
       public function destroy (Request $request,$id)
    {
        $user = User::findOrFail($id);
        //$user->status = 0;
        $user->delete();
        return redirect('users')->with('success','User Deleted.');
    }
}
