@extends('layouts.admin')

@section('content')
    <div class="col-md-12">
        <div class="row">
            <div class="col-sm-8 offset-sm-2">

                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                    <br />
                @endif
                <div class="card shadow col-md-12 p-3">
                    <form method="post">
                        @method('PATCH')
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="name"> Name:</label>
                                    {{ $user->name }}
                                </div>
                                <div class="form-group">
                                    <label for="email"> Email:</label>
                                    {{ $user->email }}
                                </div>
                                <div class="form-group">
                                    <label for="email"> Business Name:</label>
                                    {{ $user->business_name }}
                                </div>
                                <div class="form-group">
                                    <label for="email"> Valid Upto:</label>
                                    @if($user->id === 1)
                                    Unlimited
                                    @else
                                    {{ ($user->valid_upto!='')?date('d M Y',strtotime($user->valid_upto)):'' }}
                                    @endif
                                </div>
                                <div class="form-group">
                                    <label for="email"> Status:</label>
                                    @if(strtotime($user->valid_upto) > strtotime("now"))
                                        {{"Active"}}
                                    @else
                                        {{ "Expired" }}
                                    @endif
                                    
                                </div>
                                 <a href="{{route('users')}}" class="btn btn-info m-1" >Back</a>
                            </div>
                            
                        </div>
                       </form>
                </div>
            </div>
        </div>
    </div>

@endsection