@extends('layouts.admin')
@section('content')
  
    <div class="col-md-12">
        <div class="row">
            <div class="col-sm-12">
                @if (session()->get('success'))
                    <div class="alert alert-success">
                        <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                        {{ session()->get('success') }}
                    </div>
                @endif
            </div>
            <div class="card shadow mb-4 col-md-12">
                <div class="card-header">
                    <a style="margin: 19px;" href="{{ route('users-create') }}" class="btn btn-primary">Add New User</a>
                </div>
                <div class="card-body">
                    <table class="table table-striped" id="example">
                        <thead>
                            <tr>
                                <td>ID</td>
                                <td>Business Name</td>
                                <td>User Name</td>
                                 <td>Email</td>
                                 <td>Valid Upto</td>
                                 <td>Action</td>
                           </tr>
                        </thead>
                        <tbody>
                            @foreach ($users as $User)
                                <tr class="clickable-row" data-href="{{ route('users-edit', $User->id) }}">
                                    <td>{{ $loop->index+1 }}</td>
                                    <td>{{ $User->business_name }}</td>
                                    <td>{{ $User->name }}</td>
                                    <td>{{ $User->email }}</td>
                                    <?php
                                    if(strtotime($User->valid_upto)>strtotime('now')){
                                    $created = \Carbon\Carbon::parse($User->valid_upto);
                                    $now = \Carbon\Carbon::now();
                                    $diff=$created->diffInDays($now);
                                    $text= $diff. " days more";
                                    $text= date('d M Y',strtotime($User->valid_upto))."( ".$text." )";
                                    }else{
                                        $text="Expired";
                                        $text= date('d M Y',strtotime($User->valid_upto))."( ".$text." )";
                                    }
                                    if($User->id === 1){
                                        $text="Unlimited";
                                    }
                                    ?>
                                    <td>{{$text}}</td>
                                    <td>
                                        <div class="flex">
                                            <a href="{{ route('users-view', $User->id) }}"
                                                class="btn btn-success m-1">View</a>
                                            <a href="{{ route('users-edit', $User->id) }}"
                                                class="btn btn-primary m-1">Edit</a>
                                            @if ($User->id !== 1)
                                            <form action="{{ route('users-destroy', $User->id) }}" class="m-1 d-inline-block"
                                                method="post">
                                                @csrf
                                                @method('DELETE')
                                                <button class="btn btn-danger" type="submit">Delete</button>
                                            </form>
                                            @endif
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                <div>
                </div>
            </div>
            </div>
            </div>
@endsection
