jQuery(document).ready(function($) {
	"use strict";
	
	$('.slz-dragdealer-wrapper').each(function() {
		var id = $(this).data('id');
		var block_id = '#' + id;
		var input = $(block_id).find('.' + id + '-input');
		var input_val = input.val();
		var block_w = $(block_id).width();
		var handle_w = $(block_id).find('.handle').width();
		var dragdealer = new Dragdealer(id, {
			animationCallback: function(x, y) {
				var percent = Math.round(x * 100);
				if ($(block_id).hasClass('loaded') != true && typeof input_val !== 'undefined' && input_val > 0) {
					percent = input_val;
					$(block_id).find('.handle').css('transform', 'translateX('+ (((block_w-handle_w)/100)*percent) +'px)');
					$(block_id).addClass('loaded');
				}				
				$(block_id).find('.value').text(percent);
				$(block_id).find('.' + id + '-input').val(percent);
			}
		});
	});

});