<?php
	$prefix = 'buildplus_service_';
	$sh_icons = Buildplus_Core_Params::get('font_flaticon');
	$awesome_icons = Buildplus_Core_Params::get('font_awesome');
	$icons = array_merge( $sh_icons, $awesome_icons );
	$admin_icon_url = '<a href="' . esc_url(admin_url( 'admin.php?page='.BUILDPLUS_CORE_THEME_PREFIX.'_icon' )).'" target="_blank">'.esc_html('Icons','slz-core').'</a>';
?>
<!-- Icons -->
<div class="slz-custom-meta" >
	<div class="slz-meta-row" >
		<div class="slz-desc">
			<span><?php esc_html_e( 'Icons', 'slz-core' );?></span>
			<p><?php esc_html_e( 'Please go on "BuildPlus->', 'slz-core' ).printf( "%s", $admin_icon_url ). esc_html_e( ' to referentce about icons of our theme.', 'slz-core' );?></p>
		</div>
		<div class="slz-field">
			<?php echo ( $this->drop_down_list( $prefix . 'meta['.$prefix.'icon]',
														$this->get_field( $data_meta, 'icon' ),
														$icons,
														array('class'=>'slz-select2') ) );?>
		</div>
	</div>
</div>

<!-- Short description -->
<div class="slz-custom-meta" >
	<div class="slz-meta-row" >
		<div class="slz-desc">
			<span><?php esc_html_e( 'Short Description', 'slz-core' );?></span>
		</div>
		<div class="slz-field">
			<?php echo ( $this->text_area( $prefix .'meta['.$prefix.'description]',
														$this->get_field( $data_meta, 'description' ),
														array('class'=>'slz-block','rows' => '6') ) );?>
		</div>
	</div>
</div>

<!-- Gallery -->
<div class="slz-custom-meta" >
	<div class="slz-meta-row" >
		<div class="slz-desc">
			<span><?php esc_html_e( 'Gallery Images', 'slz-core' );?></span>
			<p><?php esc_html_e( 'Images should have minimum size: 800x430. Bigger size images will be cropped automatically.', 'slz-core' );?></p>
		</div>
		<div class="slz-field">
			<?php ( $this->gallery( $prefix .'meta['.$prefix.'gallery_images]', $this->get_field( $data_meta, 'gallery_images' ) ) );?>
		</div>
	</div>
</div>

<!-- Attachments -->
<div class="slz-custom-meta" >
	<div class="slz-meta-row last" >
		<div class="slz-desc">
			<span><?php esc_html_e( 'Attachments', 'slz-core' );?></span>
			<p><?php esc_html_e( 'Attach PDF files, Map images OR other documents related to the service.', 'slz-core' );?></p>
		</div>
		<div class="slz-field">
			<?php ( $this->upload_attachment( $prefix .'meta['.$prefix.'attachment_ids]', $this->get_field( $data_meta, 'attachment_ids' ) ) );?>
		</div>
	</div>
</div>