<?php
class Buildplus_Core_Contact_Map {
	public $attributes;
	public $uniq;
	public $html_format;
	public $block_class;
	
	public function __construct() {
		$this->meta_attributes();
		$this->uniq = 'contact-' . Buildplus_Core::make_id();
	}
	
	public function meta_attributes() {
		$default = array(
			'contact_form'	 => '',
			'ctf_btn_bg_cl'  => '',
			'ctf_btn_cl'     => '',
			'ctf_bg_cl'      => '',
			'ctf_text_cl'    => '',
			'ctf_title'      => '',
			'ctf_title_cl'   =>'',
			'ctf_border_cl'  =>'',
			'address' 		 => '',
			'zoom'           => '',
			'extra_class'    => '',
			'group_list'     => '',
			'group_values'   => '',
			'map_marker'     => '',
		);
		$this->attributes = $default;
	}
	public function init( &$atts, $content = null ) {
		$atts = Buildplus_Core::set_shortcode_defaults( $this->attributes, $atts);
		if( function_exists( 'wpb_js_remove_wpautop' ) ) {
			$content = wpb_js_remove_wpautop( $content, true );
		}
		$atts['content'] = $content;
		if( !empty( $atts['group_list'] ) ){
			$item_content = vc_param_group_parse_atts( $atts['group_list'] );
			$atts['group_values'] = $item_content;
		}
		$this->attributes = $atts;
		$this->add_custom_css();
	}
	
	public function get_mapker(){
		$marker  = wp_get_attachment_image_src( $this->attributes['map_marker'], "thumbnail" );
		if( $marker ) {
			$marker = $marker[0] ;
		}else{
			$marker = BUILDPLUS_CORE_ASSET_URI.'/images/map_marker_default.png';
		}
		return $marker;
	}
	public function get_address(){
		$json_data = array();
		if( $this->attributes['group_values'] ) {
			foreach( $this->attributes['group_values'] as $info) {
				if( $info ) {
					$info['address'] = !isset($info['address'])?'':$info['address'];
					$json_data[] = $info['address'];
				}
			}
			$json_data = json_encode($json_data);	
		}
		
		return $json_data;
	}
	public function get_title_ctf(){
		$output = '';
		if( !empty($this->attributes['ctf_title']) ) {
			$format = $this->html_format['title_ctf'];
			if( $format ) {
				//1: title
				$output = sprintf( $format, esc_attr( $this->attributes['ctf_title'] ) );
			}
		}
		return $output;
	}
	public function get_zoom(){
		$this->attributes['zoom']  = !empty($this->attributes['zoom'])?$this->attributes['zoom']:9;
		return $this->attributes['zoom'] ;
	}
	public function get_contact_form(){
		$output = '';
		if ( !empty( $this->attributes['contact_form'] ) && BUILDPLUS_CORE_WPCF7_ACTIVE ) { 
			$output = do_shortcode('[contact-form-7 id="'.$this->attributes['contact_form'].'" html_class="sc-contact-ctf main-form"]');
		} 
		return $output;
	}
	
	
	public function setting_html( &$options = array() ){
		$default = array(
			'title_ctf'    => '<div class="contact-title">%1$s</div>',
		);
		$this->html_format = array_merge( $default, $options);
	}

	/*-------------------- >> Css Functions << --------------------*/
	public function add_custom_css() {
		$custom_css = '';
		if( $this->attributes['ctf_bg_cl'] ) {
			$custom_css .= '.%1$s .contact-form {background-color: %2$s}'."\n";
		}
		if( $this->attributes['ctf_text_cl'] ) {
			$custom_css .= '.%1$s .contact-form .contact-title{color: %3$s}'."\n";
			$custom_css .= 
			   '.%1$s .contact-form .main-form .form-control::-webkit-input-placeholder
				{color: %4$s;}'."\n";
			$custom_css .= 
			   '.%1$s .contact-form .main-form .form-control:-moz-placeholder{color: %4$s;}'."\n";
			$custom_css .= 
			   '.%1$s .contact-form .main-form .form-control::-moz-placeholder{color: %4$s;}'."\n";
			$custom_css .= 
			   '.%1$s .contact-form .main-form form-control:-ms-input-placeholder {color: %4$s;}'."\n";

			
		}
		if( $this->attributes['ctf_border_cl'] ) {
			$custom_css .= '.%1$s .contact-form .main-form .form-control{border-color: %5$s}'."\n";
		}
		if( $this->attributes['ctf_btn_cl'] ) {
			$custom_css .= '.%1$s .contact-form .btn.white-color{color: %6$s}'."\n";
		}
		if( $this->attributes['ctf_btn_bg_cl'] ) {
			$custom_css .= '.%1$s .contact-form .btn.white-color{background-color: %7$s}'."\n";
			$custom_css .= '.%1$s .contact-form .btn.white-color{border-color: %7$s}'."\n";
			$custom_css .= '.%1$s .contact-form .btn.white-color:hover{background-color:transparent; border-color:%7$s;color:%7$s}'."\n";
		}
		$block_cls = $this->uniq;
		if ( !empty( $custom_css ) ) {
			$custom_css = sprintf($custom_css,
				esc_attr($block_cls),
				$this->attributes['ctf_bg_cl'],
				$this->attributes['ctf_title_cl'],
				$this->attributes['ctf_text_cl'],
				$this->attributes['ctf_border_cl'],
				$this->attributes['ctf_btn_cl'],
				$this->attributes['ctf_btn_bg_cl']
			);
			do_action( BUILDPLUS_CORE_ADD_INLINE_CSS, $custom_css );
		}
		
	}

	/*-------------------- >> Render Html << -------------------------*/
	public function render_sc( $html_options ) {
		$this->setting_html( $html_options );
		printf($this->html_format['html_format'],
			$this->get_title_ctf(),
			$this->get_contact_form()
		);

	}
}