<?php
class Buildplus_Core_Contact {
	public $attributes;
	public $uniq;
	public $html_format;
	public $block_class;
	
	public function __construct() {
		$this->meta_attributes();
		$this->uniq = 'contact-' . Buildplus_Core::make_id();
	}
	
	public function meta_attributes() {
		$default = array(
			'style'                => '1',
			'title'                => '',
			'group_list'           => '',
			'group_values'         => '',
			'extra_class'          => '',
			'bg_image'             => '',
			'margin_bt'            => '',

			//custom color
			'icon_color'           => '',
			'icon_bd_color'        => '',
		);
		$this->attributes = $default;
	}
	public function init( &$atts, $content = null ) {
		$atts = Buildplus_Core::set_shortcode_defaults( $this->attributes, $atts);
		if( function_exists( 'wpb_js_remove_wpautop' ) ) {
			$content = wpb_js_remove_wpautop( $content, true );
		}
		$atts['content'] = $content;
		if( !empty( $atts['group_list'] ) ){
			$item_content = vc_param_group_parse_atts( $atts['group_list'] );
			$atts['group_values'] = $item_content;
		}
		$this->attributes = $atts;
		$this->parse_block_class();
	}
	/*-------------------- >> General Functions << --------------------*/
	public function get_icon( $param) {
		$output = '';
		$param_def = array(
			'icon_type'     => '',
			'icon_fw'       => '',
			'icon_flat'     => '',
		);
		$param = array_merge($param_def, $param);
		if( $param['icon_type'] == '02' && !empty( $param['icon_fw'] ) ){
			$param['icon'] = $param['icon_fw'];
		}
		if( $param['icon_type'] != '02' && !empty( $param['icon_flat'] ) ){
			$param['icon'] = $param['icon_flat'];
		}
		
		if( !empty($param['icon']) ) {
			$format = $this->html_format['icon_format'];
			if( $format ) {
				//1: icon
				$output = sprintf( $format, esc_attr($param['icon']) );
			}
		}
		return $output;
	}
	public function get_info($value){
		$output = '';
		if(!empty($value)){
			$format = $this->html_format['info_format'];
			$output = sprintf( $format, wp_kses_post(nl2br($value)));
		}
		return $output;
	}
	
	public function parse_block_class(){
		$class = '';
		switch( $this->attributes['style'] ) {
			case '1':
				$class = 'sc-contact-style-1';
				break;
			case '2':
				$class = 'sc-contact-style-2';
				break;
			default:
				
		}
		$this->block_class = $class;
	}

	public function setting_html( &$options = array() ){
		$default = array(
			'icon_format'    => '<div class="wrapper-icons"><i class="icons fa %1$s"></i></div>',
			'info_format'=>'  <div class="wrapper-info"><div class="text">%1$s</div></div>',
		);
		$this->html_format = array_merge( $default, $options);
	}

	/*-------------------- >> Css Functions << --------------------*/
	public function add_custom_css() {
		$custom_css = '';
		
		if( $this->attributes['bg_image'] ) {
			$att_images = wp_get_attachment_url($this->attributes['bg_image']);
			$custom_css .= '.%1$s.sc-contact {background-image: url("'.esc_url($att_images).'");}'."\n";
		}
		if( $this->attributes['icon_color'] ) {
			$custom_css .= '.%1$s.sc-contact .wrapper-icons .icons:before{color: %2$s}'."\n";
		}
		if( $this->attributes['icon_bd_color'] ) {
			$custom_css .= '.%1$s.sc-contact .contact-info-box .wrapper-icons{border-color: %3$s}'."\n";
		}
		if( $this->attributes['margin_bt'] ) {
			$custom_css .= '.%1$s.sc-contact{margin-bottom: %4$spx}'."\n";
		}
		$block_cls = $this->uniq;
		if ( !empty( $custom_css ) ) {
			$custom_css = sprintf($custom_css,
				esc_attr($block_cls),
				$this->attributes['icon_color'],
				$this->attributes['icon_bd_color'] ,
				$this->attributes['margin_bt'] 
			);
			do_action( BUILDPLUS_CORE_ADD_INLINE_CSS, $custom_css );
		}
	}

	/*-------------------- >> Render Html << -------------------------*/
	public function render_sc( $html_options ) {
		$this->setting_html( $html_options );
		if( $this->attributes['group_values'] ) {
			foreach( $this->attributes['group_values'] as $item ) {
				if( $item ) {
					if( !empty( $item['icon'] ) || !empty( $item['info_title'] ) ) {
						printf($this->html_format['html_format'],
								$this->get_icon($item),
								$this->get_info($item['info_title'])
						);
					}
				}
			}
			$this->add_custom_css();
		}
	}
}