<?php
class Buildplus_Core_Gallery extends Buildplus_Core_Custom_Post_Model {

	private $post_type = 'buildplus_gallery';
	private $post_taxonomy = 'buildplus_gallery_cat';
	private $html_format;

	public function __construct() {
		$this->meta_attributes();
		$this->set_meta_attributes();
		$this->post_meta_prefix = $this->post_type . '_';
		$this->taxonomy_cat = $this->post_taxonomy;
	}

	public function meta_attributes() {
		$meta_atts = array(
			'gallery_images'      => esc_html__('Gallery Images', 'slz-core'),
		);
		$this->post_meta_atts = $meta_atts;
	}

	public function set_meta_attributes() {
		$meta_arr = array();
		$meta_label_arr = array();
		foreach( $this->post_meta_atts as $att => $name ){
			$key = $att;
			$meta_arr[$key] = '';
			$meta_label_arr[$key] = $name;
		}
		$this->post_meta_def = $meta_arr;
		$this->post_meta = $meta_arr;
		$this->post_meta_label = $meta_label_arr;
	}

	public function reset(){
		wp_reset_postdata();
	}

	public function init( $atts = array(), $query_args = array() ) {
		// set attributes
		$default_atts = array(
			'layout'				=> 'gallery',
			'limit_post'			=> '-1',
			'offset_post'			=> '',
			'sort_by'				=> '',
			'pagination'			=> 'load_more',
			'column'				=> '',
		);
		$atts = array_merge( $default_atts, $atts );
		if ( !empty($atts['posttype']) ) {
			if ( $atts['posttype'] == 'project') {
				$this->post_type = 'buildplus_project';
				$this->taxonomy_cat = $this->post_type . '_cat';
				$this->post_meta_prefix = $this->post_type . '_';
			}
		}
		if( isset( $atts['featured_filter'] ) && !empty( $atts['featured_filter'] ) ) {
			$atts['meta_key'] = array(
				'buildplus_project_is_featured' => '1'
			);
		}
		$this->attributes = $atts;

		// query
		$default_args = array(
			'post_type' => $this->post_type,
		);

		$query_args = array_merge( $default_args, $query_args );
		// setting
		$this->setting( $query_args);
	}

	public function setting( $query_args ){
		if( !isset( $this->attributes['uniq_id'] ) ) {
			$this->attributes['uniq_id'] = $this->post_type . '-' .Buildplus_Core::make_id();
		}
		// query
		if( !isset($this->attributes['no_setting_query'])) {
			$this->query = $this->get_query( $query_args, $this->attributes );
			$this->post_count = 0;
			if( $this->query->have_posts() ) {
				$this->post_count = $this->query->post_count;
			}
			$custom_css = $this->add_custom_css();
			if( $custom_css ) {
				do_action( BUILDPLUS_CORE_ADD_INLINE_CSS, $custom_css );
			}
		}

		$this->get_thumb_size();
		// $this->set_responsive_class(); //not use
	}

	public function set_responsive_class( $atts = array() ) {
		$class = '';
		$column = $this->attributes['column'];
		$def = array(
			'1' => 'col-xs-12 gallery-1col',
			'2' => 'col-sm-6 col-xs-6 gallery-2col',
			'3' => 'col-md-4 col-sm-6 col-xs-6 gallery-3col',
			'4' => 'col-lg-3 col-md-4 col-sm-6 col-xs-6 gallery-4col',
		);
		
		if( $column && isset($def[$column])) {
			return $this->attributes['responsive-class'] = $def[$column];
		} else {
			return $this->attributes['responsive-class'] = $def['4'];
		}
	}

	public function add_custom_css() {
		$custom_css = '';
		if( !empty($this->attributes['color_filter_title']) ) {
			$custom_css .= sprintf('.%1$s .tablist li .link { color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_filter_title']
							);
		}
		if( !empty($this->attributes['color_filter_title_at']) ) {
			$custom_css .= sprintf('.%1$s .tablist li.active .link { color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_filter_title_at']
							);
		}
		if( !empty($this->attributes['color_filter_line']) ) {
			$custom_css .= sprintf('.%1$s .tablist li .link:before { background-color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_filter_line']
							);
		}
		if( !empty($this->attributes['color_filter_line_at']) ) {
			$custom_css .= sprintf('.%1$s .tablist li .link:before { background-color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_filter_line_at']
							);
		}
		if( !empty($this->attributes['color_button_title']) ) {
			$custom_css .= sprintf('.%1$s .btn-loadmore { color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_button_title']
							);
		}
		if( !empty($this->attributes['color_button_title_hv']) ) {
			$custom_css .= sprintf('.%1$s .btn-loadmore:hover { color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_button_title_hv']
							);
		}
		if( !empty($this->attributes['color_button_bg']) ) {
			$custom_css .= sprintf('.%1$s .btn-loadmore { background-color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_button_bg']
							);
		}
		if( !empty($this->attributes['color_button_bg_hv']) ) {
			$custom_css .= sprintf('.%1$s .btn-loadmore:before { background-color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_button_bg_hv']
							);
		}
		if( !empty($this->attributes['color_button_border']) ) {
			$custom_css .= sprintf('.%1$s .btn-loadmore { border-color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_button_border']
							);
		}
		if( !empty($this->attributes['color_button_border_hv']) ) {
			$custom_css .= sprintf('.%1$s .btn-loadmore:hover { border-color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_button_border_hv']
							);
		}
		if( !empty($this->attributes['color_item_bg']) ) {
			$custom_css .= sprintf('.%1$s .block-image-gallery .bg-hover { background-color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_item_bg']
							);
		}
		if( !empty($this->attributes['color_item_border']) ) {
			$custom_css .= sprintf('.%1$s .block-image-gallery:after { background-color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_item_border']
							);
		}
		if( !empty($this->attributes['color_item_button']) ) {
			$custom_css .= sprintf('.%1$s .block-image-gallery .readmore-icons { color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_item_button']
							);
		}
		if( !empty($this->attributes['color_item_button_bg']) ) {
			$custom_css .= sprintf('.%1$s .block-image-gallery .readmore-icons { background-color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_item_button_bg']
							);
		}
		if( !empty($this->attributes['color_item_title']) ) {
			$custom_css .= sprintf('.%1$s .block-image-gallery .content .title { color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_item_title']
							);
		}
		if( !empty($this->attributes['color_item_title_hv']) ) {
			$custom_css .= sprintf('.%1$s .block-image-gallery .content a.title:hover { color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_item_title_hv']
							);
		}
		if( !empty($this->attributes['color_item_title_line']) ) {
			$custom_css .= sprintf('.%1$s .block-image-gallery .content .title:before { background-color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_item_title_line']
							);
		}
		if( !empty($this->attributes['color_item_cat']) ) {
			$custom_css .= sprintf('.%1$s .block-image-gallery .content .link, .%1$s .block-image-gallery .content .link a { color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_item_cat']
							);
		}
		if( !empty($this->attributes['color_item_cat_hv']) ) {
			$custom_css .= sprintf('.%1$s .block-image-gallery .content .link a:hover { color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['color_item_cat_hv']
							);
		}
		if( !empty($this->attributes['arrows_color']) ) {
			$custom_css .= sprintf('.%1$s .gallery-image-grid.style-5 .gallery-images-nested .slick-next:before,.%1$s .gallery-image-grid.style-5 .gallery-images-nested .slick-prev:before { color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['arrows_color']
							);
		}
		if( !empty($this->attributes['arrows_bg_color']) ) {
			$custom_css .= sprintf('.%1$s .gallery-image-grid.style-5 .gallery-images-nested .slick-next,.%1$s .gallery-image-grid.style-5 .gallery-images-nested .slick-prev { background-color: %2$s;}',
								$this->attributes['uniq_id'], $this->attributes['arrows_bg_color']
							);
		}


		return $custom_css;
	}

	public function set_default_options( $html_options = array() ) {
		if ( !empty($this->attributes['posttype']) && $this->attributes['posttype'] == 'project' ) {
			$title_format = '<a href="%2$s" class="title">%1$s</a>';
		} else {
			$title_format = '<span class="title">%1$s</span>';
		}
		$title_format = 
		$defaults = array(
			'title_format'		=> $title_format,
		);
		$html_options = array_merge( $defaults, $html_options );
		return $html_options;
	}

	public function get_thumb_size() {
		if ( !empty($this->attributes['style']) && $this->attributes['style'] == 2 ) {
			$this->attributes['thumb-size'] = array(
				'large'          => 'post-thumbnail'
			);
		} else {
			$layout = $this->attributes['layout'];
			$params = Buildplus_Core_Params::get( 'block_image_size', $layout );
			$this->attributes['thumb-size'] = Buildplus_Core_Util::get_thumb_size( $params, $this->attributes );
		}

	}
	public function get_gallery_image($format,$html_options,$show){
		$galleryArr = array();
		$out = '';
		if(!$show){
			return;
		}else{
			$galleryArr = $this->post_meta['gallery_images'];
		}
		$galleryArr  = explode(',', $galleryArr);
		$galleryArr = array_filter($galleryArr);
		if( !empty($galleryArr) && is_array($galleryArr) ) {
			foreach ($galleryArr as $id) {
				$url = $this->get_feature_image_url('large','',$id);
				$images = '<img src="'.esc_url($url).'" class="'.esc_attr($html_options['thumb_class']).'" alt="">';
				$out .= sprintf($format,$images,$this->get_taxonomy_term_list( 'name', $this->taxonomy_cat),$this->get_title($html_options),$this->post_id,$url);
			}
		}
		return $out;
		
	}

	/****************/
	/*  RENDER HTML */
	/****************/

	/**
	 * Render html to shortcode
	 *
	 * 1$ - term taxonomy slug, 2$ - term name, 3$ - title, 4$ - feature_image, 5$ - feature_image_url fancybox, $6 - post_id, $7 - classMasonryArr, $8 - images metabox fancybox
	 */

	public function render_gallery_masonry_sc( $html_options = array() ) {
		$this->html_format = $this->set_default_options( $html_options );
		$count_post = 1;
		$count = 0;
		$output = '';
		$classMasonryArr = array();

		if ( !empty($this->attributes['style']) ) {
			if ( $this->attributes['style'] == 1 ) {
				$classMasonryArr = array(
					'1' => '',
					'2' => 'grid-item-height-2',
					'3' => '',
					'4' => '',
					'5' => '',
					'6' => '',
					'7' => 'grid-item-height-2',
					'8' => 'grid-item-height-2',
					'9' => '',
				);
			} elseif ( $this->attributes['style'] == 2 ) {
				$classMasonryArr = array(
					'1' => 'grid-item-height-2',
					'2' => '',
					'3' => '',
					'4' => '',
					'5' => 'grid-item-height-2',
					'6' => '',
				);
			} elseif ( $this->attributes['style'] == 3 ) {
				$classMasonryArr = array(
					'1' => '',
					'2' => '',
					'3' => 'grid-item-width-2',
					'4' => '',
					'5' => '',
					'6' => 'grid-item-width-2',
					'7' => '',
					'8' => '',
					'9' => '',
					'10' => '',
				);
			} elseif ( $this->attributes['style'] == 4 ) {
				$classMasonryArr = array(
					'1' => 'gallery-3col',
				);
				if ( !empty($this->attributes['column']) ) {
					$classMasonryArr = array(
						'1' => 'gallery-'.$this->attributes['column'].'col',
					);
				}
			}
			elseif ( $this->attributes['style'] == 5 ) {
				$classMasonryArr = array(
					'1' => '',
					'2' => 'grid-item-width-2',
					'3' => '',
					'4' => '',
					'5' => '',
				);
			}
		}
		if ( !empty($this->attributes['count_post']) && $this->attributes['paged'] != 1 ) {
			$count_post = $this->attributes['count_post'];
		}

		if( $this->query->have_posts() ) {
			while ( $this->query->have_posts() ) {
				$show_gallery = false;
				$class_slider = array(
					'1' => '',
					'2' => '');
				$count++;
				$this->query->the_post();
				$this->loop_index();
				$html_options = $this->html_format;

				$thumb_id = get_post_thumbnail_id( $this->post_id );
				$get_attached_file = get_attached_file($thumb_id);
				if ( !file_exists($get_attached_file) ) {
					continue;
				}
				if( $this->attributes['style'] == '5' && $count == 2){
					$class_slider = array(
						'1'=>'gallery-images-nested',
						'2'=>'block-1'
						);
					$show_gallery = true;
				}
				$output .= sprintf( $html_options['html_format'],
					$this->get_taxonomy_slug($this->taxonomy_cat),
					$this->get_taxonomy_term_list( 'name', $this->taxonomy_cat),
					$this->get_title( $html_options ),
					$this->get_featured_image( $html_options ),
					$this->get_feature_image_url('large'),
					$this->post_id,
					$classMasonryArr[$count_post],
					$this->get_meta_gallery_image_fancybox(),
					$class_slider[1],
					$class_slider[2],
					$this->get_gallery_image($html_options['slider_format'],$html_options,$show_gallery)
				);

				if ( $this->attributes['style'] == 4 ) {
					$count_post = 1;
				} else {
					if ( $count_post == count($classMasonryArr)) {
						$count_post = 0;
					}
					$count_post++;
				}
				$this->attributes['count_post'] = $count_post;
			}
			$this->reset();
		}
		return $output;
	}

	/**
	 * Render widget to shortcode
	 *
	 * 1$ - feature_image , 2$ - term taxonomy slug , 3$ - term name , 4$ - title, 5$ - feature_image_url , $6 - post_id, 
	 */

	public function render_widget( $html_options = array() ) {
		$this->html_format = $this->set_default_options( $html_options );
		$output = '';
		if( $this->query->have_posts() ) {
			while ( $this->query->have_posts() ) {
				$this->query->the_post();
				$this->loop_index();
				$html_options = $this->html_format;
				$output .= sprintf( $html_options['html_format'],
					$this->get_featured_image( $html_options ),
					$this->get_taxonomy_term_list( 'name', $this->taxonomy_cat ,1),
					$this->get_title( $html_options ),
					$this->get_feature_image_url('large'),
					$this->post_id
				);
			}
			$this->reset();
		}
		return $output;
	}
	public function render_gallery_tab( $html_options = array() ) {
		$this->html_format = $this->set_default_options( $html_options );
		
		$output = '';
		$group = $this->attributes['uniq_id'];
		if( isset($this->attributes['tab_key']) ) {
			$group .= '-' . $this->attributes['tab_key'] ;
		}
		if( $this->query->have_posts() ) {
			while ( $this->query->have_posts() ) {
				$this->query->the_post();
				$this->loop_index();
				$html_options = $this->html_format;
				$img_url = $this->get_feature_image_url('large');
				if ( empty($img_url) ) {
					continue;
				}
				$str_tax_slug = $this->get_taxonomy_slug($this->taxonomy_cat);
				$output .= sprintf( $html_options['html_format'],
						$str_tax_slug,
						$this->get_taxonomy_term_list( 'name', $this->taxonomy_cat),
						$this->get_title( $html_options ),
						$this->get_featured_image( $html_options ),
						$img_url,
						$this->post_id,
						$group,
						$this->get_meta_gallery_image_fancybox()
				);
			}
			$this->reset();
		}
		return $output;
	}

	public function render_filter_type( $atts = array() ) {
		$output = '';
		$taxonomy = $this->taxonomy_cat;
		$format = '<li class="tab %3$s" data-filter=".%1$s" data-slug="%1$s" data-category="%2$s"><div class="link">%2$s</div></li>';
		$args = array(
			'pad_counts ' 	=> 1,
			'slug' 			=> $atts['category_slug'],
		);
		$terms = get_terms( $taxonomy, $args );
		if ($terms && ! is_wp_error($terms)) {
			foreach( $terms as $key => $term ) {
				$classActive = '';
				if ( !empty($this->attributes['show_filter_all']) && $this->attributes['show_filter_all'] != 'yes' && $key == 0 ) {
					$classActive = 'active';
				}
				$atts['category_slug'] = $term->slug;
				$json_data = esc_attr( json_encode($atts) );
				$output .= sprintf( $format, esc_attr( $term->slug), esc_html( $term->name ), esc_attr( $classActive ) );
			}
		}
		return $output;
	}
	public function render_filter_tab( $atts = array(), $html_options ) {
		$output = $output_grid = '';
		$taxonomy = $this->taxonomy_cat;
		$format = '<li class="%5$s" role="presentation" ><a class="link" href="#tab-%3$s" role="tab" data-toggle="tab" aria-expanded="%4$s" data-slug="%1$s">%2$s</a></li>';
		$args = array(
			'pad_counts ' 	=> 1,
			'slug' 			=> $atts['category_slug'],
		);
		$terms = get_terms( $taxonomy, $args );
		$tab_id = '';
		$column = absint($atts['column']);
		if ($terms && ! is_wp_error($terms)) {
			foreach( $terms as $key => $term ) {
				$classActive = $classFadeActive = '';
				$expanded = 'false';
				if ( $key == 0 ) {
					$classActive = 'active';
					$expanded = 'true';
					$classFadeActive = 'in active';
				}
				$tab_id = $atts['uniq_id'] . '-' . $key;
				$json_data = esc_attr( json_encode($atts) );
				$output .= sprintf( $format,
						esc_attr( $term->slug),
						esc_html( $term->name ),
						esc_attr( $tab_id ),
						esc_attr( $expanded ),
						esc_attr( $classActive )
				);
				$atts['category_slug'] = $term->slug;
				$atts['tab_key'] = $key;
				$model = new Buildplus_Core_Gallery();
				unset($atts['no_setting_query']);
				$model->init( $atts );
				$grid = $model->render_gallery_tab( $html_options );
				$output_grid .= sprintf('<div id="tab-%2$s" class="tab-pane fade %3$s" role="tabpanel"><div class="list-image-gallery column-%4$s">%1$s</div></div>',
						$grid,
						esc_attr( $tab_id ),
						esc_attr( $classFadeActive ),
						esc_attr( $column )
						);
			}
		}
		return array( $output, $output_grid );
	}

	/**
	 * Render html to shortcode
	 *
	 * 1 - term name, 2 - title, 3 - feature_image, 4 - feature_image_url fancybox, 5 - post_id, 6 - images metabox fancybox
	 */
	public function render_gallery_slide_sc( $html_options = array() ) {
		$this->html_format = $this->set_default_options( $html_options );
		$count_post = 1;
		$classMasonryArr = array();


		if( $this->query->have_posts() ) {
			while ( $this->query->have_posts() ) {
				$this->query->the_post();
				$this->loop_index();
				$html_options = $this->html_format;

				$thumb_id = get_post_thumbnail_id( $this->post_id );
				$get_attached_file = get_attached_file($thumb_id);
				if ( !file_exists($get_attached_file) ) {
					continue;
				}
				
				printf( $html_options['html_format'],
					$this->get_taxonomy_term_list( 'name', $this->taxonomy_cat ),
					$this->get_title( $html_options ),
					$this->get_featured_image( $html_options ),
					$this->get_feature_image_url('large'),
					$this->post_id,
					$this->get_meta_gallery_image_fancybox()
				);
			}
			$this->reset();
		}
	}

	public function get_taxonomy_term_list( $key = '', $taxonomy = '', $number='' ) {
		$output = $comma = '';
		if ( !empty($this->attributes['posttype']) && $this->attributes['posttype'] == 'project' ) {
			$format = '%3$s<a href="%2$s">%1$s</a>';
		} else {
			$format = '%3$s%1$s';
		}
		if ( empty($key) ) {
			return '';
		}
		$taxonomy_cat = $this->taxonomy_cat;
		if ( isset($taxonomy) ) {
			$taxonomy_cat = $taxonomy;
		}		
		$terms = get_the_terms( $this->post_id, $taxonomy_cat );
		$i = 0;
		if ($terms && ! is_wp_error($terms)) {
			foreach( $terms as $term ) {
				if(!empty($number)){
					if($i == $number){
						break;
					}
				}
				$term_link = get_term_link($term->term_id);
				if ($i > 0) {
					$comma = ', ';
				}
				$output .= sprintf( $format, esc_html( $term->$key ), esc_attr($term_link), $comma );
				$i++;
			}
		}
		return $output;
	}

	public function get_feature_image_url( $thumb_size = '', $thumb_type = 'large', $idThumb = '', $echo = false ) {
		$output = $thumb_img = '';
		if (empty($idThumb)) {
			$idThumb = get_post_thumbnail_id( $this->post_id );
		}
		if ( empty($thumb_size) ) {
			$thumb_size = $this->attributes['thumb-size'][$thumb_type];
		}
		if( !empty($idThumb) ) {
			$thumb_img = wp_get_attachment_image_src( $idThumb, $thumb_size );
			$output = $thumb_img[0];
		}

		if( $echo ) {
			echo wp_kses_post( $output );
		} else {
			return $output;
		}
	}

	public function get_meta_gallery_image_fancybox( $thumb_type = 'large', $echo = false ) {
		$output = $thumb_img = '';
		$gallery = $this->post_meta['gallery_images'];
		$galleryArr = explode(',', $gallery);
		$galleryArr = array_filter($galleryArr);
		$group = $this->attributes['uniq_id'];
		if( isset($this->attributes['tab_key']) ) {
			$group .= '-' . $this->attributes['tab_key'] ;
		}
		if( !empty($galleryArr) && is_array($galleryArr) ) {
			foreach ($galleryArr as $value) {
				$get_attached_file = get_attached_file($value);
				if ( !file_exists($get_attached_file) ) {
					continue;
				}
				$thumb_img_src = wp_get_attachment_image_src( $value, 'large' );
				$thumb_img .= sprintf( '<a href="%s" class="fancybox hide" data-fancybox-group-ori="%s-%s"></a>', $thumb_img_src[0], $group, $this->post_id );
			}
			if ( $thumb_img ) {
				$output = sprintf( '<div class="slz-fancybox-list list-%s hide">%s</div>', $this->post_id, $thumb_img);
			}
		}

		if( $echo ) {
			echo wp_kses_post( $output );
		} else {
			return $output;
		}
	}

	public function get_atts_align() {
		$classAlign = '';
		$align = $this->attributes['filter_align'];
		if ( !empty($align) ) {
			if ( $align == 'left' ) {
				$classAlign = 'text-left';
			} elseif ( $align == 'right' ) {
				$classAlign = 'text-right';
			} elseif ( $align == 'center' ) {
				$classAlign = 'text-center';
			}
		}
 		return $classAlign;
	}

}