<?php
$model = new BuildPlus_Core_Service();
$model->init( $atts );
$uniq_id = $model->attributes['uniq_id'];
$block_cls = $model->attributes['extra_class'] . ' ' . $uniq_id;
$style = !empty($model->attributes['style']) ? $model->attributes['style'] : 'grid';
$column = !empty($model->attributes['column']) ? $model->attributes['column'] : '3';

$classRowBegin = $classRowEnd = '';
$classInlineBlock = 'inline_block';
$slick_json = $model->get_atts_option_slick_slide();

if ( $style == 'slide' ) {
	$classRowBegin = '<div class="service_slide_slick slide-block" data-slick-json="'.esc_attr($slick_json).'">';
	$classRowEnd = '</div>';
	$classInlineBlock = '';
}

// 1$ - image, 2$ - title, 3$ - description, 4$ - permalink, 5$ - post_id, 6$ - responsive class, 7$ - read more
$image_format = '<div class="block-image">%1$s<a href="%2$s" class="link"></a></div>';
$html_format = '
	<div class="item item-layout-1 service_%5$s '.$classInlineBlock.'">
		<div class="block-1">
			%1$s
			<div class="block-content">
				<a href="%4$s" class="title">%2$s</a>
				%3$s
				%7$s
			</div>
		</div>
	</div>
';
if ( $style == 'grid-2' ) {
	$html_format = '
	    <div class="item grid-2">
	        <div class="block-service">
	            <div class="block-icons">
	                %8$s
	            </div>
	            <div class="block-content">
	                <a href="%4$s" class="title">%2$s</a>
	               	%3$s
	            </div>
	            <div class="water-hover">
	                <svg>
	                    <path d="m 1.4810806,12.859773 0,358.307407 742.0378394,0 0,-360.922789 c 0,0 -20.61084,-7.4397831 -64.9908,2.615382 -30.64025,6.942161 -63.18756,7.000011 -94.14209,2.77792 -27.29442,-3.722864 -42.51823,-14.3171679 -97.97358,-4.521509 -46.92459,8.288782 -81.99291,1.376871 -81.99291,1.376871 0,0 -37.31132,-15.0421469 -92.26813,-4.864045 -50.12657,9.283533 -85.70217,-1e-6 -85.70217,-1e-6 0,0 -35.49986,-8.9670824 -80.73825,-1.238513 -44.97587,7.68372 -69.239209,3.38137 -69.239209,3.38137 -37.51474,-9.8721366 -74.9907004,3.087907 -74.9907004,3.087907 z"
	                        class="waveShape"></path>
	                </svg>
	            </div>
	        </div>
	    </div>';
}else if( $style == 'list' ){
	$html_format = ' <div class="item style-list">
				        <div class="recent-post-inner">
				            <div class="media style-4">
				                <div class="media-left">
				                    %1$s
				                </div>
				                <div class="media-right block-content">
				                    <a href="%4$s" class="media-heading title">%2$s</a>
				                    %3$s
				                </div>
				            </div>
				        </div>
				    </div>';
	$image_format = '<a href="%2$s" class="wrapper-image block-image">
                      %1$s
                    </a>';
}
$html_render = array(
	'html_format' 		=> $html_format,
	'excerpt_format' 	=> '<div class="description">%s</div>',
	'thumb_class' 		=> 'img-full',
	'image_format'		=> $image_format 
);
?>
<div class="slz-shortcode sc_service_list <?php echo esc_attr( $block_cls ); ?>" data-item="<?php echo esc_attr($uniq_id); ?>">
	<div class="list-block-services">
		<div class="list-block column-<?php echo esc_attr( $column ); ?>">
			<?php
			echo ($classRowBegin);
			$model->render_service_list_sc( $html_render ); 
			echo ($classRowEnd); ?>
		</div>
	</div>
</div>