<?php
/**
 * Core config class.
 * 
 * @author Swlabs
 * @since 1.0
 */
if( ! class_exists( 'Buildplus_Core_Config' ) ) {
	class Buildplus_Core_Config {
		private static $setting = array(
			'save_post' => array(
				'buildplus_project'     => array( 'posttype.Project_Controller', 'save' ),
				'buildplus_service'     => array( 'posttype.Service_Controller', 'save' ),
				'buildplus_team'        => array( 'posttype.Team_Controller', 'save' ),
				'buildplus_testi'       => array( 'posttype.Testimonial_Controller', 'save' ),
				'buildplus_gallery'     => array( 'posttype.Gallery_Controller', 'save' ),
				'buildplus_partner'     => array( 'posttype.Partner_Controller', 'save' ),
				'buildplus_pricing'     => array( 'posttype.Pricing_Controller', 'save' ),
			),
			'shortcode' => array(
				
				'slzcore_banner_sc'           => 'banner',
				'slzcore_block_title_sc'      => 'block_title',
				'slzcore_button_sc'           => 'button',
				'slzcore_contact_sc'          => 'contact',
				'slzcore_contact_map_sc'      => 'contact_map',
				'slzcore_count_down_sc'       => 'count_down',
				'slzcore_download_sc'         => 'download',
				'slzcore_icon_box_sc'         => 'icon_box',
				'slzcore_item_list_sc'        => 'item_list',
				'slzcore_image_slider_sc'     => 'image_slider',
				'slzcore_number_factor_sc'    => 'number_factor',
				'slzcore_gallery_masonry_sc'  => 'gallery_masonry',
				'slzcore_gallery_slide_sc'    => 'gallery_slide',
				'slzcore_gallery_tab_sc'      => 'gallery_tab',
				'slzcore_partner_sc'          => 'partner',
				'slzcore_post_carousel_sc'    => 'post_carousel',
				'slzcore_post_list_sc'        => 'post_list',
				'slzcore_project_carousel_sc' => 'project_carousel',
				'slzcore_project_list_sc'     => 'project_list',
				'slzcore_service_carousel_sc' => 'service_carousel',
				'slzcore_service_list_sc'     => 'service_list',
				'slzcore_team_list_sc'        => 'team_list',
				'slzcore_testimonial_sc'      => 'testimonial',
				'slzcore_toggle_box_sc'       => 'toggle_box',
				'slzcore_video_sc'            => 'video',
				'slzcore_newsletter_widget_sc'=> 'newsletter_widget',
				'slzcore_pricing_sc'          => 'pricing',
			),
			'post_type' => array(
				'custom_column' => array(
					'buildplus_project',
					'buildplus_service',
					'buildplus_team',
					'buildplus_testi',
					'buildplus_gallery',
					'buildplus_partner',
				),
				'feature_video' => array( 'post', 'buildplus_project', 'buildplus_service' ),
			)
		);
		/**
		 * Retrieve value from the config variable.
		 *
		 * @param string $name The key name of first level.
		 * @param string $field optional The key name of second level.
		 * @return mixed.
		 */
		public static function get( $name, $field = NULL ) {
			if( isset( self::$setting[ $name ] ) ) {
				if( $field ) {
					return ( isset( self::$setting[ $name ][ $field ] ) ) ? self::$setting[ $name ][ $field ] : null;
				} else {
					return self::$setting[ $name ];
				}
			}
			
			return array();
		}
	}
}