<?php
/**
 * 
 * Pricing Controller
 * 
 * @author Swlabs
 * @since 1.0
 */
class Buildplus_Core_Pricing_Controller extends Buildplus_Core_Abstract {

	/**
	 * Save metabox
	 */
	public function save() {
		global $post;
		$post_id = $post->ID;
		parent::save();
		$post_meta = '';
		$feature_count = 0;
		if(isset($_POST['slz_pricing_meta'])){
			$post_meta = $_POST['slz_pricing_meta'];
			if(isset($post_meta['pricing_item'])) {
				unset($post_meta['pricing_item']);
			}
			foreach( $post_meta as $key=>$item ) {
				$count = 0;
				$feature = Buildplus_Core::get_value( $item, 'feature' );
				if( $feature ) {
					foreach( $feature as $f_key => $row ) {
						if( (isset($row['first_content']) && !empty($row['first_content'])) || 
							(isset($row['last_content']) && !empty($row['last_content'])) ) {
							$count ++;
						} else {
							unset($feature[$f_key]);
						}
					}
					if( $feature_count < $count ) {
						$feature_count = $count;
					}
				}
				$post_meta[$key]['feature'] = $feature;
				$post_meta[$key]['count'] = $count;
			}
		}
		update_post_meta( $post_id, 'buildplus_pricing_feature_count', $feature_count );
		update_post_meta( $post_id, 'buildplus_pricing_meta_table', $post_meta );
	}
	/**
	 * Pricing - metabox
	 */
	public function metabox_pricing() {
		global $post;
		$post_id = $post->ID;

		$post_meta = array();
		if( $post_id ) {
			$post_meta = get_post_meta( $post_id, 'buildplus_pricing_meta_table', true );
		}
		if( ! $post_meta ) {
			$def_feature[] = array(
				'first_content' => '',
				'last_content' => '',
				'available' => '1'
			);
			$post_meta[] = array(
				'icon'         => 'send',
				'title'        => '',
				'price'        => '',
				'description'  => '',
				'header_color' => '',
				'feature'      => $def_feature
			);
		}
		// default
		$theme_icon_list = Buildplus_Core_Params::get( 'font_flaticon' );
		$icon_list = Buildplus_Core_Params::get( 'font_awesome' );
		$icon_list = array_merge( $theme_icon_list, $icon_list );
		$params = array(
			'icons_list'     => $icon_list,
			'display_content' => array('first_last' => esc_html__('First Last', 'slz-core'), 'last_first' => esc_html__('Last First', 'slz-core') ),
		);
		$this->render( 'pricing-option', array(
			'params' => $params,
			'post_meta' => $post_meta,
		));
	}
}