jQuery(function($) {
	"use strict";

	var buildplus_fn = window.buildplus_fn || {};

	/*=======================================
	=			HEADER AUTOHIDE			=
	=======================================*/

    buildplus_fn.loading_page = function(){
       
        // loading page
         if($('#loading-page').length) {
            $('.wrapper-content').addClass('loaded');
            $('#loading-page').addClass('loaded');
        }
    }

	buildplus_fn.wp_adminbar = function(){

        // Admin bar style
        if ( $( '#wpadminbar' ).length ) {
            var adminbar_style = '<style>html{margin-top:32px;} @media screen and (max-width:782px) {html{margin-top:46px;}}</style>';
            $('body').addClass('adminbar-on');
            $('head').prepend(adminbar_style);
        }
    }
	buildplus_fn.menu = function(){
		// add active class
		$('.mega-menu-tablist ').each(function(){
			$(this).children().first().addClass('active');
		});
		$(".mega-menu-tablist li a").mouseover(function(){
            var tabhover = $(this);
            setTimeout(function() {
                tabhover.tab('show');
            },100);
        });
  
		$('.mega-menu-tablist .tab-item').each(function(){
			var html = $(this).html();
			$(this).parents('.mega-menu-tab').find('.mega-menu-tab-content').append(html);
			$(this).remove();
		});
		$('.mega-menu-tab-content ').each(function(){
			$(this).children().first().addClass('active in');
			$('.tab-pane').each(function(){
				var columns = $(this).attr('data-column');
				$(this).find('.slz-widget').addClass(columns);
			})
			
		});
        // wpml plugin
        $('.header-main .menu-item-language-current').each(function(){
            if($(this).find('.sub-menu').length > 0){
                $(this).addClass('dropdown');
                $(this).find('>a').append('<span class="wpml-menu icons fa fa-angle-down"></span>');
            }
           
        });
        
	}
	buildplus_fn.headerFunction = function() {

        if(!$('.banner-pages').length > 0 && !$('.wpb_revslider_element').length > 0){
            $('.header-wrapper').removeClass('header-absolute');
        }
        // Show - hide box search on menu
        $('.button-search').on('click', function () {
            $(this).toggleClass('active');
            $('.nav-search').toggleClass('hide');
            $('.nav-search input').focus();
        });

        //hide box seach when click outside
        $('body').on('click', function (event) {
            if ($('.button-search').has(event.target).length === 0 && !$('.button-search').is(event.target) && $('.nav-search').has(event.target).length === 0 && !$('.nav-search').is(event.target)) {
                if ($('.nav-search').hasClass('hide') === false) {
                    $('.nav-search').toggleClass('hide');
                    $('.button-search').toggleClass('active');
                }
            }
        });

        // Menu fixded
        var header_position = $('.header-main').offset();
        var window_height = $(window).height();
        $(window).on('scroll load', function (event) {
            var st = $(this).scrollTop();
            if (st > header_position.top) {
                $('.sticky-enable header .header-main').addClass("header-fixed");
            }
            else {
                 $('.sticky-enable header .header-main').removeClass("header-fixed");
            }
        });

        // Scroll show/hide menu on mobile
        var lastScroll = 100;
        if ($(window).width() <= 1024) {
            $(window).on('scroll load', function (event) {
                var st = $(this).scrollTop();
                if (st > lastScroll) {
                    $('header .header-main').addClass("hidden-menu");
                }
                else {
                     $('header .header-main').removeClass("hidden-menu");
                }
                lastScroll = st;
            });
        }

         // hamburger menu click
        $('.hamburger-menu').on('click', function(e) {
            var hamburger = $(this);
            setTimeout(function(){
                $(hamburger).toggleClass('nav-open');
            },500);
            $(".body-wrapper-content").toggleClass('mobile-menu-open');
        });

        // show hide dropdown menu
        $('.menu-mobile-wrapper .dropdown>a>.icons').on('click', function(e){
            e.preventDefault();
            if ($(this).parent().closest('.dropdown').hasClass('mb-dropdown-open') === true) {
                $(this).parent().closest('.dropdown').removeClass('mb-dropdown-open');
            }
            else {
                $(this).parent().closest('.dropdown').addClass('mb-dropdown-open');
            }
        });
    };
    buildplus_fn.backtotop = function() {
        // Backtop
        if ($('#back-top').length) {
            var scrollTrigger = 100; // px
            var backToTop = function() {
                var scrollTop = $(window).scrollTop();
                if (scrollTop > scrollTrigger) {
                    $('#back-top .link').addClass('show');
                } else {
                    $('#back-top .link').removeClass('show');
                }
            };
            backToTop();
            $(window).on('scroll', function() {
                backToTop();
            });
            $('#back-top .link').on('click', function(e) {
                e.preventDefault();
                $('html,body').animate({
                    scrollTop: 0
                }, 700);
            });
        }
    }

	/*======================================
	=			INIT FUNCTIONS			=
	======================================*/
	$(document).ready(function() {
        buildplus_fn.loading_page();
        buildplus_fn.wp_adminbar();
		buildplus_fn.menu();
		buildplus_fn.headerFunction();
        buildplus_fn.backtotop();
	});

	/*=====  End of INIT FUNCTIONS  ======*/
});