<?php
/**
 * Buildplus params class.
 * 
 * @author Swlabs
 * @package BuildPlus
 * @since 1.0
 */
class Buildplus_Params {
	/**
	 * Retrieve value from the params variable.
	 *
	 * @param string $name The key name of first level.
	 * @param string $field optional The key name of second level.
	 * @return mixed.
	 */
	public static function get( $name, $field = NULL ) {
		//get param from special function
		if ( method_exists( __CLASS__, $name ) ) {
			$params = call_user_func( array(__CLASS__, $name) );
			if( $field ) {
				return ( isset( $params[ $field ] ) ) ? $params[ $field ] : null;
			} else {
				return $params;
			}
		}
		//get param from setting function
		if ( method_exists( __CLASS__, 'setting' ) ) {
			$setting_params = call_user_func( array(__CLASS__, 'setting') );
			if(isset( $setting_params[ $name ] )  ) {
				if( $field ) {
					if( isset($setting_params[ $name ][ $field ]) ){
						return $setting_params[ $name ][ $field ];
					} else {
						return null;
					}
				} else {
					return $setting_params[ $name ];
				}
			}
		}
		return array();
	}
	public static function setting() {
		return array(
			'header-social' => array(
				'facebook'   => 'fa-facebook',
				'twitter'    => 'fa-twitter',
				'google-plus'=> 'fa-google-plus',
				'pinterest'  => 'fa-pinterest-p',
				'linkedin'   => 'fa-linkedin',
				'digg'       => 'fa-fa-digg',
			),
			'header-contact' => array(
				'workingtime'  => 'fa-clock-o',
				'phone'        => 'fa-phone',
				'address'      => 'fa-map-marker',
			),
			'social-icons' =>array(
				'facebook'      => 'fa-facebook',
				'twitter'       => 'fa-twitter',
				'google-plus'   => 'fa-google-plus',
				'skype'         => 'fa-skype',
				'youtube'       => 'fa-youtube',
				'rss'           => 'fa-rss',
				'delicious'     => 'fa-delicious',
				'flickr'        => 'fa-flickr',
				'lastfm'        => 'fa-lastfm',
				'linkedin'      => 'fa-linkedin',
				'vimeo'         => 'fa-vimeo',
				'tumblr'        => 'fa-tumblr',
				'pinterest'     => 'fa-pinterest-p',
				'deviantart'    => 'fa-deviantart',
				'git'           => 'fa-git',
				'instagram'     => 'fa-instagram',
				'soundcloud'    => 'fa-soundcloud',
				'stumbleupon'   => 'fa-stumbleupon',
				'behance'       => 'fa-behance',
				'tripAdvisor'   => 'fa-tripadvisor',
				'vk'            => 'fa-vk',
				'foursquare'    => 'fa-foursquare',
				'xing'          => 'fa-xing',
				'weibo'         => 'fa-weibo',
				'odnoklassniki' => 'fa-odnoklassniki',
			),
			// image size
			'default-image-size' => array(
				'recent_news'         => array( 'large' => '100x100' ),
			),
			//************* CustomPost/ Page Setting << ****************
			'video-type' => array(
				''              => esc_html__( 'None', 'buildplus'),
				'vimeo'         => esc_html__( 'Vimeo', 'buildplus'),
				'youtube'       => esc_html__( 'Youtube', 'buildplus'),
			),
			'background-repeat' => array(
				''          => esc_html__( '-Background Repeat-', 'buildplus'),
				'no-repeat' => esc_html__( 'No Repeat', 'buildplus'),
				'repeat'    => esc_html__( 'Repeat All', 'buildplus'),
				'repeat-x'  => esc_html__( 'Repeat Horizontally', 'buildplus'),
				'repeat-y'  => esc_html__( 'Repeat Vertically', 'buildplus'),
				'inherit'   => esc_html__( 'Inherit', 'buildplus'),
			),
			'background-size' => array(
				''        => esc_html__( '-Background Size-', 'buildplus'),
				'inherit' => esc_html__( 'Inherit', 'buildplus'),
				'cover'   => esc_html__( 'Cover', 'buildplus'),
				'contain' => esc_html__( 'Contain', 'buildplus'),
			),
			'background-position' => array(
				''              => esc_html__( '-Background Position-', 'buildplus'),
				'left top'      => esc_html__( 'Left Top', 'buildplus'),
				'left center'   => esc_html__( 'Left Center', 'buildplus'),
				'left bottom'   => esc_html__( 'Left Bottom', 'buildplus'),
				'center top'    => esc_html__( 'Center Top', 'buildplus'),
				'center center' => esc_html__( 'Center Center', 'buildplus'),
				'center bottom' => esc_html__( 'Center Bottom', 'buildplus'),
				'right top'     => esc_html__( 'Right Top', 'buildplus'),
				'right center'  => esc_html__( 'Right Center', 'buildplus'),
				'right bottom'  => esc_html__( 'Right Bottom', 'buildplus'),
			),
			'background-attachment' => array(
				''        => esc_html__( '-Background Attachment-', 'buildplus'),
				'fixed'   => esc_html__( 'Fixed', 'buildplus'),
				'scroll'  => esc_html__( 'Scroll', 'buildplus'),
				'inherit' => esc_html__( 'Inherit', 'buildplus'),
			),
			'sidebar-layout' => array(
				'none'  => esc_html__( 'None', 'buildplus'),
				'left'  => esc_html__( 'Left', 'buildplus'),
				'right' => esc_html__( 'Right', 'buildplus')
			),
			'header_layout' => array(
				'one'   => 'header_style_01.jpg',
				'two'   => 'header_style_02.jpg',
				'three' => 'header_style_03.jpg',
				'four'  => 'header_style_04.jpg',
				'five'  => 'header_style_05.jpg',
			),
		);
	}
	public static function author_social_links() {
		return array(
			'behance'       => esc_html__( 'Behance', 'buildplus' ),
			'delicious'     => esc_html__( 'Delicious', 'buildplus' ),
			'deviantart'    => esc_html__( 'Deviantart', 'buildplus' ),
			'facebook'      => esc_html__( 'Facebook', 'buildplus' ),
			'flickr'        => esc_html__( 'Flickr', 'buildplus' ),
			'foursquare'    => esc_html__( 'Foursquare', 'buildplus' ),
			'lastfm'        => esc_html__( 'Lastfm', 'buildplus' ),
			'linkedin'      => esc_html__( 'Linkedin', 'buildplus' ),
			'git'           => esc_html__( 'Github', 'buildplus' ),
			'google-plus'   => esc_html__( 'Google+', 'buildplus' ),
			'instagram'     => esc_html__( 'Instagram', 'buildplus' ),
			'odnoklassniki' => esc_html__( 'Odnoklassniki', 'buildplus' ),
			'pinterest'     => esc_html__( 'Pinterest', 'buildplus' ),
			'rss'           => esc_html__( 'RSS', 'buildplus' ),
			'skype'         => esc_html__( 'Skype', 'buildplus' ),
			'soundcloud'    => esc_html__( 'Soundcloud', 'buildplus' ),
			'stumbleupon'   => esc_html__( 'Stumbleupon', 'buildplus' ),
			'tripAdvisor'   => esc_html__( 'TripAdvisor', 'buildplus' ),
			'tumblr'        => esc_html__( 'Tumblr', 'buildplus' ),
			'twitter'       => esc_html__( 'Twitter', 'buildplus' ),
			'vimeo'         => esc_html__( 'Vimeo', 'buildplus' ),
			'vk'            => esc_html__( 'VK', 'buildplus' ),
			'weibo'         => esc_html__( 'Weibo', 'buildplus' ),
			'xing'          => esc_html__( 'XING', 'buildplus' ),
			'youtube'       => esc_html__( 'YouTube', 'buildplus' ),
		);
	} 
	public static function style_formats() {
		return array(
			'buildplus_dropcap' => array(
				'title' => esc_html__( 'Dropcaps', 'buildplus' ),
				'items' => array(
					array(
						'parent_id' => 'buildplus_dropcap',
						'title'     => esc_html__( 'Box', 'buildplus' ),
						'classes'   => 'dropcap',
						'inline'    => 'span',
					),
					array(
						'parent_id' => 'buildplus_dropcap',
						'title'     => esc_html__( 'Circle', 'buildplus' ),
						'classes'   => 'dropcap1',
						'inline'    => 'span',
					),
					array(
						'parent_id' => 'buildplus_dropcap',
						'title'     => esc_html__( 'Regular', 'buildplus' ),
						'classes'   => 'dropcap2',
						'inline'    => 'span',
					),
					array(
						'parent_id' => 'buildplus_dropcap',
						'title'     => esc_html__( 'Bold', 'buildplus' ),
						'classes'   => 'dropcap3',
						'inline'    => 'span',
					),
				)
			),
			'buildplus_text_highlight' => array(
				'title' => esc_html__( 'Text Highlighting', 'buildplus' ),
				'items' => array(
					array(
						'parent_id' => 'buildplus_text_highlight',
						'title'     => esc_html__( 'Black censured', 'buildplus' ),
						'classes'   => 'highlight',
						'inline'    => 'span',
					),
					array(
						'parent_id' => 'buildplus_text_highlight',
						'title'     => esc_html__( 'Red marker', 'buildplus' ),
						'classes'   => 'highlight_maker red',
						'inline'    => 'span',
					),
					array(
						'parent_id' => 'buildplus_text_highlight',
						'title'     => esc_html__( 'Blue marker', 'buildplus' ),
						'classes'   => 'highlight_maker blue',
						'inline'    => 'span',
					),
					array(
						'parent_id' => 'buildplus_text_highlight',
						'title'     => esc_html__( 'Green marker', 'buildplus' ),
						'classes'   => 'highlight_maker green',
						'inline'    => 'span',
					),
					array(
						'parent_id' => 'buildplus_text_highlight',
						'title'     => esc_html__( 'Yellow  marker', 'buildplus' ),
						'classes'   => 'highlight_maker yellow ',
						'inline'    => 'span',
					),
					array(
						'parent_id' => 'buildplus_text_highlight',
						'title'     => esc_html__( 'Pink  marker', 'buildplus' ),
						'classes'   => 'highlight_maker pink ',
						'inline'    => 'span',
					),
				)
			),
		);
	}
	public static function sort_blog(){
		return array(
			esc_html__( '- Latest -', 'buildplus' )               => '',
			esc_html__( 'A to Z', 'buildplus')                    => 'az_order',
			esc_html__( 'Z to A', 'buildplus')                    => 'za_order',
			esc_html__( 'Random posts today', 'buildplus' )       => 'random_today',
			esc_html__( 'Random posts a week ago', 'buildplus' )  => 'random_7_day',
			esc_html__( 'Random posts a month ago', 'buildplus' ) => 'random_month',
			esc_html__( 'Random Posts', 'buildplus' )             => 'random_posts',
			esc_html__( 'Most Commented', 'buildplus' )           => 'comment_count',
		);
	}
	
	
}