<?php
/**
 * Constants.
 * 
 * @package BuildPlus
 * @since 1.0
 */
defined( 'BUILDPLUS_THEME_VER' )      || define( 'BUILDPLUS_THEME_VER', time() );

defined( 'BUILDPLUS_THEME_DIR' )      || define( 'BUILDPLUS_THEME_DIR', get_template_directory() );
defined( 'BUILDPLUS_THEME_URI' )      || define( 'BUILDPLUS_THEME_URI', get_template_directory_uri() );
defined( 'BUILDPLUS_FRAMEWORK_DIR' )  || define( 'BUILDPLUS_FRAMEWORK_DIR', BUILDPLUS_THEME_DIR . '/framework' );
defined( 'BUILDPLUS_REDUX_EXT_DIR' )  || define( 'BUILDPLUS_REDUX_EXT_DIR', get_template_directory() . '/admin/redux-extensions' );

defined( 'BUILDPLUS_MODULES_DIR' )    || define( 'BUILDPLUS_MODULES_DIR', BUILDPLUS_FRAMEWORK_DIR . '/modules' );
defined( 'BUILDPLUS_FRONT_DIR' )      || define( 'BUILDPLUS_FRONT_DIR', BUILDPLUS_FRAMEWORK_DIR . '/modules/front' );
defined( 'BUILDPLUS_PLUGINS_DIR' )    || define( 'BUILDPLUS_PLUGINS_DIR', BUILDPLUS_FRAMEWORK_DIR . '/plugins' );
defined( 'BUILDPLUS_EXTERNAL_DIR' )   || define( 'BUILDPLUS_EXTERNAL_DIR', BUILDPLUS_FRAMEWORK_DIR . '/external' );

defined( 'BUILDPLUS_ADMIN_URI' )      || define( 'BUILDPLUS_ADMIN_URI', BUILDPLUS_THEME_URI . '/assets/admin' );
defined( 'BUILDPLUS_PUBLIC_URI' )     || define( 'BUILDPLUS_PUBLIC_URI', BUILDPLUS_THEME_URI . '/assets/public' );
defined( 'BUILDPLUS_PLUGIN_IMG_URI' ) || define( 'BUILDPLUS_PLUGIN_IMG_URI', BUILDPLUS_THEME_URI . '/assets/admin/images/plugin' );
defined( 'BUILDPLUS_THEME_CORE_URI' ) || define( 'BUILDPLUS_THEME_CORE_URI', WP_PLUGIN_DIR . '/slz-core/' );

defined( 'BUILDPLUS_COPYRIGHT' )      || define( 'BUILDPLUS_COPYRIGHT', esc_html__('&#169; 2016 SWLABS', 'buildplus') );
defined( 'BUILDPLUS_LOGO' )           || define( 'BUILDPLUS_LOGO', BUILDPLUS_PUBLIC_URI . '/images/logo/logo-default.png' );

defined( 'BUILDPLUS_NO_IMG' )         || define( 'BUILDPLUS_NO_IMG', BUILDPLUS_PUBLIC_URI.'/images/thumb-no-image.gif' );
defined( 'BUILDPLUS_NO_IMG_URI' )     || define( 'BUILDPLUS_NO_IMG_URI', BUILDPLUS_PUBLIC_URI.'/images/no-image/' );

//*********************Plugin***************************
//Active slz-core Plugin - BUILDPLUS_CORE_VERSION
if( defined( 'BUILDPLUS_CORE_VERSION' ) ) {
	define( 'BUILDPLUS_CORE_IS_ACTIVE', defined( 'BUILDPLUS_CORE_VERSION' ) );
}
else {
	define( 'BUILDPLUS_CORE_IS_ACTIVE', '' );
}
//ReduxFrameworkPlugin
defined( 'BUILDPLUS_REDUX_ACTIVE' )     || define( 'BUILDPLUS_REDUX_ACTIVE', class_exists( 'ReduxFrameworkPlugin' ) );

//Active RS
if( defined( 'RS_PLUGIN_PATH' ) ) {
	define( 'BUILDPLUS_REVSLIDER_ACTIVE', defined( 'RS_PLUGIN_PATH' ) );
}
else {
	define( 'BUILDPLUS_REVSLIDER_ACTIVE', '' );
}

//Active ContactForm7 Plugin
if( defined( 'WPCF7_LOAD_JS' ) ) {
	define( 'BUILDPLUS_WPCF7_ACTIVE', defined( 'WPCF7_LOAD_JS' ) );
}
else {
	define( 'BUILDPLUS_WPCF7_ACTIVE', '' );
}
//Active Woocommerce Plugin
defined( 'BUILDPLUS_WOOCOMMERCE_ACTIVE' )     || define( 'BUILDPLUS_WOOCOMMERCE_ACTIVE', class_exists( 'WooCommerce' ) );

if ( defined( 'YITH_WCWL' ) ) {
	define( 'BUILDPLUS_WOOCOMMERCE_WISHLIST', defined( 'YITH_WCWL' ) );
}
else {
	define( 'BUILDPLUS_WOOCOMMERCE_WISHLIST', '' );
}