<?php
	$arr_pages = array(
		'requirement'	=> esc_html__( "Requirements & Recommendations", 'buildplus' ),
		'plugin'		=> esc_html__( "Plugins", 'buildplus' ),
		'importer'		=> esc_html__( "Demo Importer", 'buildplus' ),
		'icon'			=> esc_html__( "BuildPlus Icons", 'buildplus' ),
		'changelog'		=> esc_html__( "Changes Log", 'buildplus' )
	);
	$screen = get_current_screen();
	$args = explode('_', $screen->id);
	$id_page = array_pop($args);
?>
	<h1><?php esc_html_e( "Welcome to BuildPlus!", 'buildplus' ); ?></h1>
	<div class="about-text">
		<?php esc_html_e( "BuildPlus is now installed and ready to use!  Get ready to build something beautiful. Please register your purchase to get support and automatic theme updates. Read below for additional information. We hope you enjoy it!", 'buildplus' ); ?>
	</div>
	<h2 class="nav-tab-wrapper">
		<?php 
		foreach ( $arr_pages as $id => $name ) {
			$active = '';
			if( $id == $id_page || $id == 'welcome') {
				$active = 'nav-tab-active';
			}
			if( $id == 'icon' && ! BUILDPLUS_CORE_IS_ACTIVE ){
				continue;
			}
			printf( '<a href="%1$s" class="nav-tab %3$s">%2$s</a>',
					esc_url( admin_url( 'admin.php?page=buildplus_' . $id ) ),
					$name,
					$active );
		}
		?>
	</h2>